/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j.sessionsettings;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import org.tn5250j.SessionConfig;
import org.tn5250j.sessionsettings.AttributesPanel;
import org.tn5250j.tools.LangTool;

class ColorAttributesPanel
extends AttributesPanel {
    private static final long serialVersionUID = 1L;
    private JComboBox colorList;
    private JColorChooser jcc;
    private Schema colorSchema;
    private Properties schemaProps;

    ColorAttributesPanel(SessionConfig config) {
        super(config, "Colors");
    }

    @Override
    public void initPanel() throws Exception {
        JPanel cp = new JPanel();
        cp.setLayout(new BorderLayout());
        JPanel cschp = new JPanel();
        TitledBorder tb = BorderFactory.createTitledBorder(LangTool.getString("sa.colorSchema"));
        cschp.setBorder(tb);
        JComboBox colorSchemaList = new JComboBox();
        this.loadSchemas(colorSchemaList);
        colorSchemaList.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JComboBox cb = (JComboBox)e.getSource();
                Object obj = cb.getSelectedItem();
                if (obj instanceof Schema) {
                    System.out.println(" we got a schema ");
                    ColorAttributesPanel.this.colorSchema = (Schema)obj;
                } else {
                    ColorAttributesPanel.this.colorSchema = null;
                }
            }
        });
        cschp.add(colorSchemaList);
        tb = BorderFactory.createTitledBorder(LangTool.getString("sa.colors"));
        cp.setBorder(tb);
        this.colorList = new JComboBox();
        this.colorList.addItem(LangTool.getString("sa.bg"));
        this.colorList.addItem(LangTool.getString("sa.blue"));
        this.colorList.addItem(LangTool.getString("sa.red"));
        this.colorList.addItem(LangTool.getString("sa.pink"));
        this.colorList.addItem(LangTool.getString("sa.green"));
        this.colorList.addItem(LangTool.getString("sa.turq"));
        this.colorList.addItem(LangTool.getString("sa.yellow"));
        this.colorList.addItem(LangTool.getString("sa.white"));
        this.colorList.addItem(LangTool.getString("sa.guiField"));
        this.colorList.addItem(LangTool.getString("sa.cursorColor"));
        this.colorList.addItem(LangTool.getString("sa.columnSep"));
        this.colorList.addItem(LangTool.getString("sa.hexAttrColor"));
        this.jcc = new JColorChooser();
        this.jcc.setColor(this.getColorProperty("colorBg"));
        this.colorList.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JComboBox cb = (JComboBox)e.getSource();
                String newSelection = (String)cb.getSelectedItem();
                if (newSelection.equals(LangTool.getString("sa.bg"))) {
                    if (ColorAttributesPanel.this.colorSchema != null) {
                        ColorAttributesPanel.this.jcc.setColor(ColorAttributesPanel.this.colorSchema.getColorBg());
                    } else {
                        ColorAttributesPanel.this.jcc.setColor(ColorAttributesPanel.this.getColorProperty("colorBg"));
                    }
                }
                if (newSelection.equals(LangTool.getString("sa.blue"))) {
                    if (ColorAttributesPanel.this.colorSchema != null) {
                        ColorAttributesPanel.this.jcc.setColor(ColorAttributesPanel.this.colorSchema.getColorBlue());
                    } else {
                        ColorAttributesPanel.this.jcc.setColor(ColorAttributesPanel.this.getColorProperty("colorBlue"));
                    }
                }
                if (newSelection.equals(LangTool.getString("sa.red"))) {
                    if (ColorAttributesPanel.this.colorSchema != null) {
                        ColorAttributesPanel.this.jcc.setColor(ColorAttributesPanel.this.colorSchema.getColorRed());
                    } else {
                        ColorAttributesPanel.this.jcc.setColor(ColorAttributesPanel.this.getColorProperty("colorRed"));
                    }
                }
                if (newSelection.equals(LangTool.getString("sa.pink"))) {
                    if (ColorAttributesPanel.this.colorSchema != null) {
                        ColorAttributesPanel.this.jcc.setColor(ColorAttributesPanel.this.colorSchema.getColorPink());
                    } else {
                        ColorAttributesPanel.this.jcc.setColor(ColorAttributesPanel.this.getColorProperty("colorPink"));
                    }
                }
                if (newSelection.equals(LangTool.getString("sa.green"))) {
                    if (ColorAttributesPanel.this.colorSchema != null) {
                        ColorAttributesPanel.this.jcc.setColor(ColorAttributesPanel.this.colorSchema.getColorGreen());
                    } else {
                        ColorAttributesPanel.this.jcc.setColor(ColorAttributesPanel.this.getColorProperty("colorGreen"));
                    }
                }
                if (newSelection.equals(LangTool.getString("sa.turq"))) {
                    if (ColorAttributesPanel.this.colorSchema != null) {
                        ColorAttributesPanel.this.jcc.setColor(ColorAttributesPanel.this.colorSchema.getColorTurq());
                    } else {
                        ColorAttributesPanel.this.jcc.setColor(ColorAttributesPanel.this.getColorProperty("colorTurq"));
                    }
                }
                if (newSelection.equals(LangTool.getString("sa.yellow"))) {
                    if (ColorAttributesPanel.this.colorSchema != null) {
                        ColorAttributesPanel.this.jcc.setColor(ColorAttributesPanel.this.colorSchema.getColorYellow());
                    } else {
                        ColorAttributesPanel.this.jcc.setColor(ColorAttributesPanel.this.getColorProperty("colorYellow"));
                    }
                }
                if (newSelection.equals(LangTool.getString("sa.white"))) {
                    if (ColorAttributesPanel.this.colorSchema != null) {
                        ColorAttributesPanel.this.jcc.setColor(ColorAttributesPanel.this.colorSchema.getColorWhite());
                    } else {
                        ColorAttributesPanel.this.jcc.setColor(ColorAttributesPanel.this.getColorProperty("colorWhite"));
                    }
                }
                if (newSelection.equals(LangTool.getString("sa.guiField"))) {
                    if (ColorAttributesPanel.this.colorSchema != null) {
                        ColorAttributesPanel.this.jcc.setColor(ColorAttributesPanel.this.colorSchema.getColorGuiField());
                    } else {
                        ColorAttributesPanel.this.jcc.setColor(ColorAttributesPanel.this.getColorProperty("colorGUIField", Color.white));
                    }
                }
                if (newSelection.equals(LangTool.getString("sa.cursorColor"))) {
                    if (ColorAttributesPanel.this.colorSchema != null) {
                        ColorAttributesPanel.this.jcc.setColor(ColorAttributesPanel.this.colorSchema.getColorBg());
                    } else {
                        ColorAttributesPanel.this.jcc.setColor(ColorAttributesPanel.this.getColorProperty("colorCursor", ColorAttributesPanel.this.getColorProperty("colorBg")));
                    }
                }
                if (newSelection.equals(LangTool.getString("sa.columnSep"))) {
                    if (ColorAttributesPanel.this.colorSchema != null) {
                        ColorAttributesPanel.this.jcc.setColor(ColorAttributesPanel.this.colorSchema.getColorSeparator());
                    } else {
                        ColorAttributesPanel.this.jcc.setColor(ColorAttributesPanel.this.getColorProperty("colorSep", ColorAttributesPanel.this.getColorProperty("colorWhite")));
                    }
                }
                if (newSelection.equals(LangTool.getString("sa.hexAttrColor"))) {
                    if (ColorAttributesPanel.this.colorSchema != null) {
                        ColorAttributesPanel.this.jcc.setColor(ColorAttributesPanel.this.colorSchema.getColorHexAttr());
                    } else {
                        ColorAttributesPanel.this.jcc.setColor(ColorAttributesPanel.this.getColorProperty("colorHexAttr", ColorAttributesPanel.this.getColorProperty("colorWhite")));
                    }
                }
            }
        });
        cp.add((Component)this.colorList, "North");
        cp.add((Component)this.jcc, "Center");
        this.add((Component)cschp, "North");
        this.add((Component)cp, "Center");
    }

    @Override
    public void applyAttributes() {
        String newSelection = (String)this.colorList.getSelectedItem();
        if (this.colorSchema != null) {
            if (!this.getColorProperty("colorBg").equals(this.colorSchema.getColorBg())) {
                this.changes.firePropertyChange(this, "colorBg", this.getColorProperty("colorBg"), this.colorSchema.getColorBg());
                this.setProperty("colorBg", Integer.toString(this.colorSchema.getColorBg().getRGB()));
            }
            if (!this.getColorProperty("colorBlue").equals(this.colorSchema.getColorBlue())) {
                this.changes.firePropertyChange(this, "colorBlue", this.getColorProperty("colorBlue"), this.colorSchema.getColorBlue());
                this.setProperty("colorBlue", Integer.toString(this.colorSchema.getColorBlue().getRGB()));
            }
            if (!this.getColorProperty("colorRed").equals(this.colorSchema.getColorRed())) {
                this.changes.firePropertyChange(this, "colorRed", this.getColorProperty("colorRed"), this.colorSchema.getColorRed());
                this.setProperty("colorRed", Integer.toString(this.colorSchema.getColorRed().getRGB()));
            }
            if (!this.getColorProperty("colorPink").equals(this.colorSchema.getColorPink())) {
                this.changes.firePropertyChange(this, "colorPink", this.getColorProperty("colorPink"), this.colorSchema.getColorPink());
                this.setProperty("colorPink", Integer.toString(this.colorSchema.getColorPink().getRGB()));
            }
            if (!this.getColorProperty("colorGreen").equals(this.colorSchema.getColorGreen())) {
                this.changes.firePropertyChange(this, "colorGreen", this.getColorProperty("colorGreen"), this.colorSchema.getColorGreen());
                this.setProperty("colorGreen", Integer.toString(this.colorSchema.getColorGreen().getRGB()));
            }
            if (!this.getColorProperty("colorTurq").equals(this.colorSchema.getColorTurq())) {
                this.changes.firePropertyChange(this, "colorTurq", this.getColorProperty("colorTurq"), this.colorSchema.getColorTurq());
                this.setProperty("colorTurq", Integer.toString(this.colorSchema.getColorTurq().getRGB()));
            }
            if (!this.getColorProperty("colorYellow").equals(this.colorSchema.getColorYellow())) {
                this.changes.firePropertyChange(this, "colorYellow", this.getColorProperty("colorYellow"), this.colorSchema.getColorYellow());
                this.setProperty("colorYellow", Integer.toString(this.colorSchema.getColorYellow().getRGB()));
            }
            if (!this.getColorProperty("colorWhite").equals(this.colorSchema.getColorWhite())) {
                this.changes.firePropertyChange(this, "colorWhite", this.getColorProperty("colorWhite"), this.colorSchema.getColorWhite());
                this.setProperty("colorWhite", Integer.toString(this.colorSchema.getColorWhite().getRGB()));
            }
            if (!this.getColorProperty("colorGUIField").equals(this.colorSchema.getColorGuiField())) {
                this.changes.firePropertyChange(this, "colorGUIField", this.getColorProperty("colorGUIField"), this.colorSchema.getColorGuiField());
                this.setProperty("colorGUIField", Integer.toString(this.colorSchema.getColorGuiField().getRGB()));
            }
            if (!this.getColorProperty("colorCursor").equals(this.colorSchema.getColorCursor())) {
                this.changes.firePropertyChange(this, "colorCursor", this.getColorProperty("colorCursor"), this.colorSchema.getColorCursor());
                this.setProperty("colorCursor", Integer.toString(this.colorSchema.getColorCursor().getRGB()));
            }
            if (!this.getColorProperty("colorSep").equals(this.colorSchema.getColorSeparator())) {
                this.changes.firePropertyChange(this, "colorSep", this.getColorProperty("colorSep"), this.colorSchema.getColorSeparator());
                this.setProperty("colorSep", Integer.toString(this.colorSchema.getColorSeparator().getRGB()));
            }
            if (!this.getColorProperty("colorHexAttr").equals(this.colorSchema.getColorHexAttr())) {
                this.changes.firePropertyChange(this, "colorHexAttr", this.getColorProperty("colorHexAttr"), this.colorSchema.getColorHexAttr());
                this.setProperty("colorHexAttr", Integer.toString(this.colorSchema.getColorHexAttr().getRGB()));
            }
        } else {
            Color nc = this.jcc.getColor();
            if (newSelection.equals(LangTool.getString("sa.bg")) && !this.getColorProperty("colorBg").equals(nc)) {
                this.changes.firePropertyChange(this, "colorBg", this.getColorProperty("colorBg"), nc);
                this.setProperty("colorBg", Integer.toString(nc.getRGB()));
            }
            if (newSelection.equals(LangTool.getString("sa.blue")) && !this.getColorProperty("colorBlue").equals(nc)) {
                this.changes.firePropertyChange(this, "colorBlue", this.getColorProperty("colorBlue"), nc);
                this.setProperty("colorBlue", Integer.toString(nc.getRGB()));
            }
            if (newSelection.equals(LangTool.getString("sa.red")) && !this.getColorProperty("colorRed").equals(nc)) {
                this.changes.firePropertyChange(this, "colorRed", this.getColorProperty("colorRed"), nc);
                this.setProperty("colorRed", Integer.toString(nc.getRGB()));
            }
            if (newSelection.equals(LangTool.getString("sa.pink")) && !this.getColorProperty("colorPink").equals(nc)) {
                this.changes.firePropertyChange(this, "colorPink", this.getColorProperty("colorPink"), nc);
                this.setProperty("colorPink", Integer.toString(nc.getRGB()));
            }
            if (newSelection.equals(LangTool.getString("sa.green")) && !this.getColorProperty("colorGreen").equals(nc)) {
                this.changes.firePropertyChange(this, "colorGreen", this.getColorProperty("colorGreen"), nc);
                this.setProperty("colorGreen", Integer.toString(nc.getRGB()));
            }
            if (newSelection.equals(LangTool.getString("sa.turq")) && !this.getColorProperty("colorTurq").equals(nc)) {
                this.changes.firePropertyChange(this, "colorTurq", this.getColorProperty("colorTurq"), nc);
                this.setProperty("colorTurq", Integer.toString(nc.getRGB()));
            }
            if (newSelection.equals(LangTool.getString("sa.yellow")) && !this.getColorProperty("colorYellow").equals(nc)) {
                this.changes.firePropertyChange(this, "colorYellow", this.getColorProperty("colorYellow"), nc);
                this.setProperty("colorYellow", Integer.toString(nc.getRGB()));
            }
            if (newSelection.equals(LangTool.getString("sa.white")) && !this.getColorProperty("colorWhite").equals(nc)) {
                this.changes.firePropertyChange(this, "colorWhite", this.getColorProperty("colorWhite"), nc);
                this.setProperty("colorWhite", Integer.toString(nc.getRGB()));
            }
            if (newSelection.equals(LangTool.getString("sa.guiField")) && !this.getColorProperty("colorGUIField").equals(nc)) {
                this.changes.firePropertyChange(this, "colorGUIField", this.getColorProperty("colorGUIField"), nc);
                this.setProperty("colorGUIField", Integer.toString(nc.getRGB()));
            }
            if (newSelection.equals(LangTool.getString("sa.cursorColor")) && !this.getColorProperty("colorCursor").equals(nc)) {
                this.changes.firePropertyChange(this, "colorCursor", this.getColorProperty("colorCursor"), nc);
                this.setProperty("colorCursor", Integer.toString(nc.getRGB()));
            }
            if (newSelection.equals(LangTool.getString("sa.columnSep")) && !this.getColorProperty("colorSep").equals(nc)) {
                this.changes.firePropertyChange(this, "colorSep", this.getColorProperty("colorSep"), nc);
                this.setProperty("colorSep", Integer.toString(nc.getRGB()));
            }
            if (newSelection.equals(LangTool.getString("sa.cursorColor")) && !this.getColorProperty("colorCursor").equals(nc)) {
                this.changes.firePropertyChange(this, "colorCursor", this.getColorProperty("colorCursor"), nc);
                this.setProperty("colorCursor", Integer.toString(nc.getRGB()));
            }
            if (newSelection.equals(LangTool.getString("sa.hexAttrColor")) && !this.getColorProperty("colorHexAttr").equals(nc)) {
                this.changes.firePropertyChange(this, "colorHexAttr", this.getColorProperty("colorHexAttr"), nc);
                this.setProperty("colorHexAttr", Integer.toString(nc.getRGB()));
            }
        }
    }

    private void loadSchemas(JComboBox schemas) {
        this.schemaProps = new Properties();
        URL file = null;
        try {
            ClassLoader cl = this.getClass().getClassLoader();
            if (cl == null) {
                cl = ClassLoader.getSystemClassLoader();
            }
            file = cl.getResource("tn5250jSchemas.properties");
            this.schemaProps.load(file.openStream());
        }
        catch (Exception e) {
            System.err.println(e);
        }
        schemas.addItem(LangTool.getString("sa.colorDefault"));
        int numSchemas = Integer.parseInt((String)this.schemaProps.get("schemas"));
        Schema s = null;
        String prefix = "";
        for (int x = 1; x <= numSchemas; ++x) {
            s = new Schema();
            prefix = "schema" + x;
            s.setDescription((String)this.schemaProps.get(prefix + ".title"));
            s.setColorBg(this.getSchemaProp(prefix + ".colorBg"));
            s.setColorRed(this.getSchemaProp(prefix + ".colorRed"));
            s.setColorTurq(this.getSchemaProp(prefix + ".colorTurq"));
            s.setColorCursor(this.getSchemaProp(prefix + ".colorCursor"));
            s.setColorGuiField(this.getSchemaProp(prefix + ".colorGUIField"));
            s.setColorWhite(this.getSchemaProp(prefix + ".colorWhite"));
            s.setColorYellow(this.getSchemaProp(prefix + ".colorYellow"));
            s.setColorGreen(this.getSchemaProp(prefix + ".colorGreen"));
            s.setColorPink(this.getSchemaProp(prefix + ".colorPink"));
            s.setColorBlue(this.getSchemaProp(prefix + ".colorBlue"));
            s.setColorSeparator(this.getSchemaProp(prefix + ".colorSep"));
            s.setColorHexAttr(this.getSchemaProp(prefix + ".colorHexAttr"));
            schemas.addItem(s);
        }
    }

    private int getSchemaProp(String key) {
        if (this.schemaProps.containsKey(key)) {
            return Integer.parseInt((String)this.schemaProps.get(key));
        }
        return 0;
    }

    class Schema {
        private String description;
        private Color bg;
        private Color blue;
        private Color red;
        private Color pink;
        private Color green;
        private Color turq;
        private Color white;
        private Color yellow;
        private Color gui;
        private Color cursor;
        private Color columnSep;
        private Color hexAttr;

        Schema() {
        }

        public String toString() {
            return this.description;
        }

        public void setDescription(String desc) {
            this.description = desc;
        }

        public void setColorBg(int color) {
            this.bg = new Color(color);
        }

        public Color getColorBg() {
            return this.bg;
        }

        public void setColorBlue(int color) {
            this.blue = new Color(color);
        }

        public Color getColorBlue() {
            return this.blue;
        }

        public void setColorRed(int color) {
            this.red = new Color(color);
        }

        public Color getColorRed() {
            return this.red;
        }

        public void setColorPink(int color) {
            this.pink = new Color(color);
        }

        public Color getColorPink() {
            return this.pink;
        }

        public void setColorGreen(int color) {
            this.green = new Color(color);
        }

        public Color getColorGreen() {
            return this.green;
        }

        public void setColorTurq(int color) {
            this.turq = new Color(color);
        }

        public Color getColorTurq() {
            return this.turq;
        }

        public void setColorYellow(int color) {
            this.yellow = new Color(color);
        }

        public Color getColorYellow() {
            return this.yellow;
        }

        public void setColorWhite(int color) {
            this.white = new Color(color);
        }

        public Color getColorWhite() {
            return this.white;
        }

        public void setColorGuiField(int color) {
            this.gui = new Color(color);
        }

        public Color getColorGuiField() {
            return this.gui;
        }

        public void setColorCursor(int color) {
            this.cursor = new Color(color);
        }

        public Color getColorCursor() {
            return this.cursor;
        }

        public void setColorSeparator(int color) {
            this.columnSep = new Color(color);
        }

        public Color getColorSeparator() {
            return this.columnSep;
        }

        public void setColorHexAttr(int color) {
            this.hexAttr = new Color(color);
        }

        public Color getColorHexAttr() {
            return this.hexAttr;
        }
    }
}

