/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j.sessionsettings;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.tn5250j.SessionConfig;
import org.tn5250j.sessionsettings.AttributesPanel;
import org.tn5250j.tools.LangTool;

class CursorAttributesPanel
extends AttributesPanel {
    private static final long serialVersionUID = 1L;
    private JRadioButton cFull;
    private JRadioButton cHalf;
    private JRadioButton cLine;
    private JRadioButton chNone;
    private JRadioButton chHorz;
    private JRadioButton chVert;
    private JRadioButton chCross;
    private JCheckBox rulerFixed;
    private JTextField cursorBottOffset;
    private JRadioButton blink;

    CursorAttributesPanel(SessionConfig config) {
        super(config, "Cursor");
    }

    @Override
    public void initPanel() throws Exception {
        this.setLayout(new BorderLayout());
        this.contentPane = new JPanel();
        this.contentPane.setLayout(new BoxLayout(this.contentPane, 1));
        this.add((Component)this.contentPane, "North");
        JPanel crp = new JPanel();
        crp.setBorder(BorderFactory.createTitledBorder(LangTool.getString("sa.crsSize")));
        this.cFull = new JRadioButton(LangTool.getString("sa.cFull"));
        this.cHalf = new JRadioButton(LangTool.getString("sa.cHalf"));
        this.cLine = new JRadioButton(LangTool.getString("sa.cLine"));
        ButtonGroup cGroup = new ButtonGroup();
        cGroup.add(this.cFull);
        cGroup.add(this.cHalf);
        cGroup.add(this.cLine);
        int cursorSize = 0;
        if (this.getStringProperty("cursorSize").equals("Full")) {
            cursorSize = 2;
        }
        if (this.getStringProperty("cursorSize").equals("Half")) {
            cursorSize = 1;
        }
        switch (cursorSize) {
            case 0: {
                this.cLine.setSelected(true);
                break;
            }
            case 1: {
                this.cHalf.setSelected(true);
                break;
            }
            case 2: {
                this.cFull.setSelected(true);
            }
        }
        crp.add(this.cFull);
        crp.add(this.cHalf);
        crp.add(this.cLine);
        JPanel chp = new JPanel();
        chp.setBorder(BorderFactory.createTitledBorder(LangTool.getString("sa.crossHair")));
        this.chNone = new JRadioButton(LangTool.getString("sa.chNone"));
        this.chHorz = new JRadioButton(LangTool.getString("sa.chHorz"));
        this.chVert = new JRadioButton(LangTool.getString("sa.chVert"));
        this.chCross = new JRadioButton(LangTool.getString("sa.chCross"));
        ButtonGroup chGroup = new ButtonGroup();
        chGroup.add(this.chNone);
        chGroup.add(this.chHorz);
        chGroup.add(this.chVert);
        chGroup.add(this.chCross);
        int crossHair = 0;
        if (this.getStringProperty("crossHair").equals("Horz")) {
            crossHair = 1;
        }
        if (this.getStringProperty("crossHair").equals("Vert")) {
            crossHair = 2;
        }
        if (this.getStringProperty("crossHair").equals("Both")) {
            crossHair = 3;
        }
        switch (crossHair) {
            case 0: {
                this.chNone.setSelected(true);
                break;
            }
            case 1: {
                this.chHorz.setSelected(true);
                break;
            }
            case 2: {
                this.chVert.setSelected(true);
                break;
            }
            case 3: {
                this.chCross.setSelected(true);
            }
        }
        chp.add(this.chNone);
        chp.add(this.chHorz);
        chp.add(this.chVert);
        chp.add(this.chCross);
        JPanel rulerFPanel = new JPanel();
        rulerFPanel.setBorder(BorderFactory.createTitledBorder(""));
        this.rulerFixed = new JCheckBox(LangTool.getString("sa.rulerFixed"));
        this.rulerFixed.setSelected(true);
        if (this.getStringProperty("rulerFixed").equals("Yes")) {
            this.rulerFixed.setSelected(false);
        }
        rulerFPanel.add(this.rulerFixed);
        JPanel blinkPanel = new JPanel();
        blinkPanel.setBorder(BorderFactory.createTitledBorder(LangTool.getString("sa.blinkCursor")));
        this.blink = new JRadioButton(LangTool.getString("sa.blinkYes"));
        JRadioButton noBlink = new JRadioButton(LangTool.getString("sa.blinkNo"));
        ButtonGroup blinkGroup = new ButtonGroup();
        blinkGroup.add(this.blink);
        blinkGroup.add(noBlink);
        this.blink.setSelected(false);
        if (this.getStringProperty("cursorBlink").equals("Yes")) {
            this.blink.setSelected(true);
        } else {
            noBlink.setSelected(true);
        }
        blinkPanel.add(this.blink);
        blinkPanel.add(noBlink);
        JPanel bottOffPanel = new JPanel();
        bottOffPanel.setBorder(BorderFactory.createTitledBorder(LangTool.getString("sa.curBottOffset")));
        this.cursorBottOffset = new JTextField(5);
        try {
            int i = Integer.parseInt(this.getStringProperty("cursorBottOffset", "0"));
            this.cursorBottOffset.setText(Integer.toString(i));
        }
        catch (NumberFormatException ne) {
            this.cursorBottOffset.setText("0");
        }
        bottOffPanel.add(this.cursorBottOffset);
        this.contentPane.add(crp);
        this.contentPane.add(chp);
        this.contentPane.add(rulerFPanel);
        this.contentPane.add(blinkPanel);
        this.contentPane.add(bottOffPanel);
    }

    @Override
    public void applyAttributes() {
        if (this.cFull.isSelected()) {
            this.changes.firePropertyChange(this, "cursorSize", this.getStringProperty("cursorSize"), "Full");
            this.setProperty("cursorSize", "Full");
        }
        if (this.cHalf.isSelected()) {
            this.changes.firePropertyChange(this, "cursorSize", this.getStringProperty("cursorSize"), "Half");
            this.setProperty("cursorSize", "Half");
        }
        if (this.cLine.isSelected()) {
            this.changes.firePropertyChange(this, "cursorSize", this.getStringProperty("cursorSize"), "Line");
            this.setProperty("cursorSize", "Line");
        }
        if (this.chNone.isSelected()) {
            this.changes.firePropertyChange(this, "crossHair", this.getStringProperty("crossHair"), "None");
            this.setProperty("crossHair", "None");
        }
        if (this.chHorz.isSelected()) {
            this.changes.firePropertyChange(this, "crossHair", this.getStringProperty("crossHair"), "Horz");
            this.setProperty("crossHair", "Horz");
        }
        if (this.chVert.isSelected()) {
            this.changes.firePropertyChange(this, "crossHair", this.getStringProperty("crossHair"), "Vert");
            this.setProperty("crossHair", "Vert");
        }
        if (this.chCross.isSelected()) {
            this.changes.firePropertyChange(this, "crossHair", this.getStringProperty("crossHair"), "Both");
            this.setProperty("crossHair", "Both");
        }
        if (this.rulerFixed.isSelected()) {
            this.changes.firePropertyChange(this, "rulerFixed", this.getStringProperty("rulerFixed"), "No");
            this.setProperty("rulerFixed", "No");
        } else {
            this.changes.firePropertyChange(this, "rulerFixed", this.getStringProperty("rulerFixed"), "Yes");
            this.setProperty("rulerFixed", "Yes");
        }
        this.changes.firePropertyChange(this, "cursorBottOffset", this.getStringProperty("cursorBottOffset"), this.cursorBottOffset.getText());
        this.setProperty("cursorBottOffset", this.cursorBottOffset.getText());
        if (this.blink.isSelected()) {
            this.changes.firePropertyChange(this, "cursorBlink", this.getStringProperty("cursorBlink"), "Yes");
            this.setProperty("cursorBlink", "Yes");
        } else {
            this.changes.firePropertyChange(this, "cursorBlink", this.getStringProperty("cursorBlink"), "No");
            this.setProperty("cursorBlink", "No");
        }
    }
}

