/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j.spoolfile;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.IFSFileOutputStream;
import com.ibm.as400.access.PrintObjectTransformedInputStream;
import com.ibm.as400.access.PrintParameterList;
import com.ibm.as400.access.SpooledFile;
import com.ibm.as400.vaccess.FileFilter;
import com.ibm.as400.vaccess.IFSFileDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.tn5250j.SessionPanel;
import org.tn5250j.event.WizardEvent;
import org.tn5250j.event.WizardListener;
import org.tn5250j.gui.GenericTn5250JFrame;
import org.tn5250j.gui.TN5250jFileChooser;
import org.tn5250j.gui.Wizard;
import org.tn5250j.gui.WizardPage;
import org.tn5250j.mailtools.SendEMailDialog;
import org.tn5250j.spoolfile.ExportFileFilter;
import org.tn5250j.tools.AlignLayout;
import org.tn5250j.tools.LangTool;

public class SpoolExportWizard
extends GenericTn5250JFrame
implements WizardListener {
    private static final long serialVersionUID = 1L;
    JPanel contentPane;
    JLabel statusBar = new JLabel();
    JPanel spoolPanel = new JPanel();
    JPanel spoolData = new JPanel();
    JPanel spoolOptions = new JPanel();
    JPanel destPanel = new JPanel();
    JLabel labelSpooledFile = new JLabel();
    JLabel spooledFile = new JLabel();
    JLabel labelJobName = new JLabel();
    JLabel jobName = new JLabel();
    JLabel labelUser = new JLabel();
    JLabel user = new JLabel();
    JLabel labelNumber = new JLabel();
    JLabel number = new JLabel();
    JLabel labelFileNumber = new JLabel();
    JLabel spooledFileNumber = new JLabel();
    JLabel labelSystem = new JLabel();
    JLabel systemName = new JLabel();
    JLabel labelPages = new JLabel();
    JLabel pages = new JLabel();
    JComboBox cvtType;
    JTextField pcPathInfo;
    JTextField ifsPathInfo;
    JButton pcSave;
    JButton ifsSave;
    JRadioButton pc;
    JRadioButton ifs;
    JRadioButton email;
    JTextField title;
    JTextField subject;
    JTextField author;
    JTextField fontSize;
    JComboBox pageSize;
    JRadioButton portrait;
    JRadioButton landscape;
    JCheckBox openAfter;
    JTextField editor;
    JButton getEditor;
    SpooledFile splfile;
    SessionPanel session;
    JPanel twoPDF;
    JPanel twoText;
    Wizard wizard;
    WizardPage page;
    WizardPage pagePDF;
    WizardPage pageText;
    JButton nextButton;
    private FileOutputStream fw;
    private IFSFileOutputStream ifsfw;
    private String conicalPath;
    private Thread workingThread;

    public SpoolExportWizard(SpooledFile splfile, SessionPanel session) {
        this.enableEvents(64L);
        this.splfile = splfile;
        this.session = session;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.wizard = new Wizard();
        this.wizard.addWizardListener(this);
        this.getContentPane().add(this.wizard);
        this.page = new WizardPage(30);
        this.page.setName(LangTool.getString("spool.titlePage1"));
        this.setTitle(this.page.getName());
        this.nextButton = this.page.getNextButton();
        this.page.getContentPane().add((Component)this.pageOne(), "Center");
        this.wizard.add(this.page);
        this.pagePDF = new WizardPage(29);
        this.pagePDF.setName(LangTool.getString("spool.titlePage2PDF"));
        this.pagePDF.getContentPane().add((Component)this.pageTwoPDF(), "Center");
        this.wizard.add(this.pagePDF);
        this.pageText = new WizardPage(29);
        this.pageText.setName(LangTool.getString("spool.titlePage2Txt"));
        this.pageText.getContentPane().add((Component)this.pageTwoText(), "Center");
        this.wizard.add(this.pageText);
        this.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = this.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        this.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
    }

    private JPanel pageTwoPDF() {
        this.twoPDF = new JPanel();
        this.twoPDF.setLayout(new BorderLayout());
        JPanel docProps = new JPanel();
        docProps.setBorder(BorderFactory.createTitledBorder(LangTool.getString("spool.labelProps")));
        docProps.setLayout(new AlignLayout(2, 5, 5));
        docProps.add(new JLabel(LangTool.getString("spool.labelPropsTitle")));
        this.title = new JTextField(40);
        docProps.add(this.title);
        docProps.add(new JLabel(LangTool.getString("spool.labelPropsSubject")));
        this.subject = new JTextField(40);
        docProps.add(this.subject);
        docProps.add(new JLabel(LangTool.getString("spool.labelPropsAuthor")));
        this.author = new JTextField(40);
        docProps.add(this.author);
        JPanel options = new JPanel();
        options.setBorder(BorderFactory.createTitledBorder(LangTool.getString("spool.labelOpts")));
        options.setLayout(new AlignLayout(2, 5, 5));
        options.add(new JLabel(LangTool.getString("spool.labelOptsFontSize")));
        this.fontSize = new JTextField(5);
        options.add(this.fontSize);
        options.add(new JLabel(LangTool.getString("spool.labelOptsPageSize")));
        this.pageSize = new JComboBox();
        options.add(this.pageSize);
        this.pageSize.addItem("A3");
        this.pageSize.addItem("A4");
        this.pageSize.addItem("A5");
        this.pageSize.addItem("LETTER");
        this.pageSize.addItem("LEGAL");
        this.pageSize.addItem("LEDGER");
        this.portrait = new JRadioButton(LangTool.getString("spool.labelOptsPortrait"));
        options.add(this.portrait);
        this.landscape = new JRadioButton(LangTool.getString("spool.labelOptsLandscape"));
        options.add(this.landscape);
        ButtonGroup orientation = new ButtonGroup();
        orientation.add(this.portrait);
        orientation.add(this.landscape);
        this.landscape.setSelected(true);
        this.twoPDF.add((Component)docProps, "North");
        this.twoPDF.add((Component)options, "Center");
        return this.twoPDF;
    }

    private JPanel pageTwoText() {
        this.twoText = new JPanel();
        this.twoText.setLayout(new BorderLayout());
        JPanel textProps = new JPanel();
        textProps.setBorder(BorderFactory.createTitledBorder(LangTool.getString("spool.labelTextProps")));
        textProps.setLayout(new AlignLayout(2, 5, 5));
        this.openAfter = new JCheckBox(LangTool.getString("spool.labelUseExternal"));
        textProps.add(this.openAfter);
        textProps.add(new JLabel());
        this.editor = new JTextField(30);
        textProps.add(this.editor);
        this.getEditor = new JButton("Browse");
        this.getEditor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SpoolExportWizard.this.getEditor();
            }
        });
        textProps.add(this.getEditor);
        if (this.session.getSession().getConfiguration().isPropertyExists("useExternal")) {
            this.openAfter.setEnabled(true);
        }
        if (this.session.getSession().getConfiguration().isPropertyExists("externalViewer")) {
            this.editor.setText(this.session.getSession().getConfiguration().getStringProperty("externalViewer"));
        }
        this.twoText.add((Component)textProps, "Center");
        return this.twoText;
    }

    private JPanel pageOne() throws Exception {
        this.contentPane = new JPanel();
        this.contentPane.setLayout(new BorderLayout());
        this.statusBar.setText(" ");
        this.statusBar.setBorder(BorderFactory.createEtchedBorder());
        this.spoolPanel.setLayout(new BorderLayout());
        this.contentPane.add((Component)this.spoolPanel, "Center");
        this.contentPane.add((Component)this.statusBar, "South");
        this.labelSpooledFile.setText(LangTool.getString("spool.labelSpooledFile"));
        this.labelJobName.setText(LangTool.getString("spool.labelJobName"));
        this.labelUser.setText(LangTool.getString("spool.labelJobUser"));
        this.labelNumber.setText(LangTool.getString("spool.labelJobNumber"));
        this.labelFileNumber.setText(LangTool.getString("spool.labelSpoolNumber"));
        this.labelSystem.setText(LangTool.getString("spool.labelSystem"));
        this.labelPages.setText(LangTool.getString("spool.labelPages"));
        this.spoolData.setLayout(new AlignLayout(2, 5, 5));
        this.spoolData.setBorder(BorderFactory.createTitledBorder(LangTool.getString("spool.labelSpoolInfo")));
        this.spooledFile.setText(this.splfile.getName());
        this.jobName.setText(this.splfile.getJobName());
        this.user.setText(this.splfile.getJobUser());
        this.spooledFileNumber.setText(Integer.toString(this.splfile.getNumber()));
        this.number.setText(this.splfile.getJobNumber());
        this.systemName.setText(this.splfile.getSystem().getSystemName());
        this.pages.setText(this.splfile.getIntegerAttribute(111).toString());
        this.spoolData.add((Component)this.labelSystem, null);
        this.spoolData.add((Component)this.systemName, null);
        this.spoolData.add((Component)this.labelSpooledFile, null);
        this.spoolData.add((Component)this.spooledFile, null);
        this.spoolData.add((Component)this.labelJobName, null);
        this.spoolData.add((Component)this.jobName, null);
        this.spoolData.add((Component)this.labelUser, null);
        this.spoolData.add((Component)this.user, null);
        this.spoolData.add((Component)this.labelNumber, null);
        this.spoolData.add((Component)this.number, null);
        this.spoolData.add((Component)this.labelFileNumber, null);
        this.spoolData.add((Component)this.spooledFileNumber, null);
        this.spoolData.add((Component)this.labelPages, null);
        this.spoolData.add((Component)this.pages, null);
        this.spoolPanel.add((Component)this.spoolOptions, "South");
        this.spoolPanel.add((Component)this.spoolData, "Center");
        this.spoolOptions.setLayout(new BorderLayout());
        JPanel spoolInfo = new JPanel();
        AlignLayout alignMe2 = new AlignLayout(3, 5, 5);
        spoolInfo.setLayout(alignMe2);
        spoolInfo.setBorder(BorderFactory.createTitledBorder(LangTool.getString("spool.labelExportInfo")));
        this.cvtType = new JComboBox();
        this.cvtType.addItem(LangTool.getString("spool.toPDF"));
        this.cvtType.addItem(LangTool.getString("spool.toText"));
        spoolInfo.add(new JLabel(LangTool.getString("spool.labelFormat")));
        spoolInfo.add(this.cvtType);
        spoolInfo.add(new JLabel(""));
        this.pc = new JRadioButton(LangTool.getString("spool.labelPCPath"));
        this.pcPathInfo = new JTextField(30);
        this.pcSave = new JButton("...");
        this.pcSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SpoolExportWizard.this.getPCFile();
            }
        });
        spoolInfo.add(this.pc);
        spoolInfo.add(this.pcPathInfo);
        spoolInfo.add(this.pcSave);
        this.ifs = new JRadioButton(LangTool.getString("spool.labelIFSPath"));
        this.ifsPathInfo = new JTextField(30);
        this.ifsSave = new JButton("...");
        this.ifsSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SpoolExportWizard.this.getIFSFile();
            }
        });
        spoolInfo.add(this.ifs);
        spoolInfo.add(this.ifsPathInfo);
        spoolInfo.add(this.ifsSave);
        this.email = new JRadioButton(LangTool.getString("spool.labelEmail"));
        spoolInfo.add(this.email);
        spoolInfo.add(new JLabel(""));
        spoolInfo.add(new JLabel(""));
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.pc);
        bg.add(this.ifs);
        bg.add(this.email);
        this.pc.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                SpoolExportWizard.this.doItemStateChanged(e);
            }
        });
        this.ifs.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                SpoolExportWizard.this.doItemStateChanged(e);
            }
        });
        this.email.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                SpoolExportWizard.this.doItemStateChanged(e);
            }
        });
        this.pc.setSelected(true);
        this.spoolOptions.add((Component)spoolInfo, "Center");
        return this.contentPane;
    }

    private void doItemStateChanged(ItemEvent e) {
        this.pcPathInfo.setEnabled(false);
        this.ifsPathInfo.setEnabled(false);
        this.pcSave.setEnabled(false);
        this.ifsSave.setEnabled(false);
        if (e.getStateChange() == 1) {
            if (this.pc.isSelected()) {
                this.pcPathInfo.setEnabled(true);
                this.pcSave.setEnabled(true);
                this.pcPathInfo.grabFocus();
            }
            if (this.ifs.isSelected()) {
                this.ifsPathInfo.setEnabled(true);
                this.ifsSave.setEnabled(true);
                this.ifsPathInfo.grabFocus();
            }
        }
    }

    private boolean pagesValid() {
        if (this.pc.isSelected()) {
            if (this.pcPathInfo.getText().length() == 0) {
                this.getPCFile();
            }
            if (this.pcPathInfo.getText().length() == 0) {
                return false;
            }
        }
        return true;
    }

    private void getPCFile() {
        String workingDir = System.getProperty("user.dir");
        TN5250jFileChooser pcFileChooser = new TN5250jFileChooser(workingDir);
        ExportFileFilter filter = ((String)this.cvtType.getSelectedItem()).equals(LangTool.getString("spool.toPDF")) ? new ExportFileFilter("pdf", "PDF Files") : new ExportFileFilter("txt", "Text Files");
        pcFileChooser.addChoosableFileFilter(filter);
        int ret = pcFileChooser.showSaveDialog(this);
        if (ret == 0) {
            File file = pcFileChooser.getSelectedFile();
            this.pcPathInfo.setText(filter.setExtension(file));
        }
    }

    private void getIFSFile() {
        IFSFileDialog fd = new IFSFileDialog((Frame)this, "Save As", this.splfile.getSystem());
        FileFilter[] filterList = new FileFilter[]{new FileFilter("All files (*.*)", "*.*"), this.cvtType.getSelectedIndex() == 0 ? new FileFilter("PDF files (*.pdf)", "*.pdf") : new FileFilter("Text files (*.txt)", "*.txt")};
        fd.setFileFilter(filterList, 1);
        if (fd.showDialog() == 1) {
            this.ifsPathInfo.setText(fd.getAbsolutePath());
        }
    }

    private void getEditor() {
        String workingDir = System.getProperty("user.dir");
        TN5250jFileChooser pcFileChooser = new TN5250jFileChooser(workingDir);
        int ret = pcFileChooser.showOpenDialog(this);
        if (ret == 0) {
            File file = pcFileChooser.getSelectedFile();
            try {
                this.editor.setText(file.getCanonicalPath());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        super.processWindowEvent(e);
        if (e.getID() == 201) {
            this.setVisible(false);
            this.dispose();
        }
    }

    private void doExport() {
        if (!this.pagesValid()) {
            return;
        }
        this.workingThread = null;
        this.workingThread = this.cvtType.getSelectedIndex() == 0 ? new Thread(new Runnable(){

            @Override
            public void run() {
                SpoolExportWizard.this.cvtToPDF();
            }
        }) : new Thread(new Runnable(){

            @Override
            public void run() {
                SpoolExportWizard.this.cvtToText();
            }
        });
        this.workingThread.start();
    }

    private void emailMe() {
        SendEMailDialog semd = new SendEMailDialog((Frame)this, this.session, this.conicalPath);
    }

    private void cvtToText() {
        try {
            this.openOutputFile();
            PrintStream dw = this.ifs.isSelected() ? new PrintStream((OutputStream)this.ifsfw) : new PrintStream(this.fw);
            AS400 system = new AS400(this.systemName.getText());
            String splfName = this.spooledFile.getText();
            int splfNumber = Integer.parseInt(this.spooledFileNumber.getText());
            String _jobName = this.jobName.getText();
            String _jobUser = this.user.getText();
            String _jobNumber = this.number.getText();
            SpooledFile splF = new SpooledFile(system, splfName, splfNumber, _jobName, _jobUser, _jobNumber);
            PrintParameterList printParms = new PrintParameterList();
            printParms.setParameter(-8, "/QSYS.LIB/QWPDEFAULT.WSCST");
            printParms.setParameter(65, "*WSCST");
            PrintObjectTransformedInputStream inStream = splF.getTransformedInputStream(printParms);
            int avail = inStream.available();
            byte[] buf = new byte[avail + 1];
            int read = 0;
            int totBytes = 0;
            StringBuffer sb = new StringBuffer();
            this.updateStatus("Starting Output");
            while (avail > 0) {
                if (avail > buf.length) {
                    buf = new byte[avail + 1];
                }
                read = inStream.read(buf, 0, avail);
                block11: for (int x = 0; x < read; ++x) {
                    switch (buf[x]) {
                        case 0: {
                            continue block11;
                        }
                        case 10: {
                            dw.println(sb.toString().toCharArray());
                            sb.setLength(0);
                            continue block11;
                        }
                        case 13: {
                            continue block11;
                        }
                        case 12: {
                            dw.println(sb.toString().toCharArray());
                            sb.setLength(0);
                            continue block11;
                        }
                        default: {
                            sb.append(SpoolExportWizard.byte2char(buf[x], "cp850"));
                        }
                    }
                }
                this.updateStatus("Bytes read " + (totBytes += read));
                avail = inStream.available();
            }
            if (sb.length() > 0) {
                dw.println(sb.toString().toCharArray());
            }
            dw.flush();
            dw.close();
            this.updateStatus("Total bytes converted " + totBytes);
            if (this.openAfter.isSelected()) {
                try {
                    Runtime rt = Runtime.getRuntime();
                    String[] cmdArray = new String[]{this.editor.getText(), this.pcPathInfo.getText()};
                    rt.exec(cmdArray);
                    if (this.openAfter.isSelected()) {
                        this.session.getSession().getConfiguration().setProperty("useExternal", "");
                    } else {
                        this.session.getSession().getConfiguration().removeProperty("useExternal");
                    }
                    this.session.getSession().getConfiguration().setProperty("externalViewer", this.editor.getText());
                    this.session.getSession().getConfiguration().saveSessionProps();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    JOptionPane.showMessageDialog(this, t.getMessage(), "error", 0);
                }
            }
            if (this.email.isSelected()) {
                this.emailMe();
            }
        }
        catch (Exception e) {
            this.updateStatus("Error: " + e.getMessage());
            System.out.println("Error: " + e.getMessage());
        }
    }

    private void cvtToPDF() {
        try {
            this.openOutputFile();
            PrintParameterList printParms = new PrintParameterList();
            printParms.setParameter(-8, "/QSYS.LIB/QWPDEFAULT.WSCST");
            printParms.setParameter(65, "*WSCST");
            PrintObjectTransformedInputStream inStream = this.splfile.getTransformedInputStream(printParms);
            int avail = inStream.available();
            byte[] buf = new byte[avail + 1];
            int read = 0;
            int totBytes = 0;
            StringBuffer sb = new StringBuffer();
            this.updateStatus("Starting Output");
            while (avail > 0) {
                if (avail > buf.length) {
                    buf = new byte[avail + 1];
                }
                read = inStream.read(buf, 0, avail);
                block9: for (int x = 0; x < read; ++x) {
                    switch (buf[x]) {
                        case 0: {
                            continue block9;
                        }
                        case 10: {
                            sb.append((char)buf[x]);
                            continue block9;
                        }
                        case 13: {
                            continue block9;
                        }
                        case 12: {
                            this.writeBuffer(sb.toString());
                            sb.setLength(0);
                            continue block9;
                        }
                        default: {
                            sb.append(SpoolExportWizard.byte2char(buf[x], "cp850"));
                        }
                    }
                }
                this.updateStatus("Bytes read " + (totBytes += read));
                avail = inStream.available();
            }
            this.closeOutputFile();
            this.updateStatus("Total bytes converted " + totBytes);
            if (this.email.isSelected()) {
                this.emailMe();
            }
        }
        catch (Exception e) {
            this.updateStatus("Error: " + e.getMessage());
            System.out.println("Error: " + e.getMessage());
        }
    }

    private void writeBuffer(String s) {
    }

    public void openOutputFile() {
        try {
            this.updateStatus("Opening File");
            String suffix = ".txt";
            String fileName = "";
            if (this.cvtType.getSelectedIndex() == 0) {
                suffix = ".pdf";
            }
            if (this.email.isSelected()) {
                File dir = new File(System.getProperty("user.dir"));
                String tempFile = this.spooledFile.getText().trim() + '_' + this.jobName.getText().trim() + '_' + this.user.getText().trim() + '_' + this.spooledFileNumber.getText().trim() + '_' + this.number.getText().trim();
                File f = File.createTempFile(tempFile, suffix, dir);
                System.out.println(f.getName());
                System.out.println(f.getCanonicalPath());
                this.conicalPath = f.getCanonicalPath();
                f.deleteOnExit();
                this.fw = new FileOutputStream(f);
            } else if (this.ifs.isSelected()) {
                fileName = this.ifsPathInfo.getText().trim();
                this.ifsfw = new IFSFileOutputStream(this.splfile.getSystem(), fileName);
            } else {
                fileName = this.pcPathInfo.getText().trim();
                this.fw = new FileOutputStream(fileName);
            }
            if (this.cvtType.getSelectedIndex() > 0) {
                return;
            }
        }
        catch (IOException _ex) {
            System.out.println("Cannot open 1 " + _ex.getMessage());
        }
        catch (Exception _ex2) {
            System.out.println("Cannot open 2 " + _ex2.getMessage());
        }
    }

    private void closeOutputFile() {
    }

    private void updateStatus(final String stat) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SpoolExportWizard.this.statusBar.setText(stat);
            }
        });
    }

    @Override
    public void nextBegin(WizardEvent e) {
        if (((String)this.cvtType.getSelectedItem()).equals(LangTool.getString("spool.toText"))) {
            this.twoText.add((Component)this.statusBar, "South");
            e.setNewPage(this.pageText);
        } else {
            this.twoPDF.add((Component)this.statusBar, "South");
            e.setNewPage(this.pagePDF);
        }
    }

    @Override
    public void nextComplete(WizardEvent e) {
        this.setTitle(e.getNewPage().getName());
    }

    @Override
    public void previousBegin(WizardEvent e) {
        e.setNewPage(this.page);
        this.contentPane.add((Component)this.statusBar, "South");
    }

    @Override
    public void previousComplete(WizardEvent e) {
        this.setTitle(e.getNewPage().getName());
    }

    @Override
    public void finished(WizardEvent e) {
        this.doExport();
    }

    @Override
    public void canceled(WizardEvent e) {
        if (this.workingThread != null) {
            this.workingThread.interrupt();
            this.workingThread = null;
        }
        this.setVisible(false);
        this.dispose();
    }

    @Override
    public void help(WizardEvent e) {
        System.out.println(e.getCurrentPage().getName());
    }

    public static char byte2char(byte b, String charsetName) {
        char c = ' ';
        try {
            byte[] bytes = new byte[]{b};
            c = new String(bytes, charsetName).charAt(0);
        }
        catch (UnsupportedEncodingException uee) {
            System.err.println(uee);
            System.err.println("Error while converting byte to char, returning blank...");
        }
        return c;
    }
}

