/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j.spoolfile;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.PrintObjectListEvent;
import com.ibm.as400.access.PrintObjectListListener;
import com.ibm.as400.access.SpooledFile;
import com.ibm.as400.access.SpooledFileList;
import com.ibm.as400.vaccess.SpooledFileViewer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import org.tn5250j.SessionPanel;
import org.tn5250j.framework.tn5250.tnvt;
import org.tn5250j.gui.DefaultSortTableModel;
import org.tn5250j.gui.GenericTn5250JFrame;
import org.tn5250j.gui.JSortTable;
import org.tn5250j.spoolfile.SpoolExportWizard;
import org.tn5250j.spoolfile.SpoolFilterPane;
import org.tn5250j.tools.GUIGraphicsUtils;
import org.tn5250j.tools.LangTool;

public class SpoolExporter
extends GenericTn5250JFrame {
    private static final long serialVersionUID = 1L;
    SpoolFilterPane filter;
    SpoolTableModel stm;
    JScrollPane scrollPane;
    ListSelectionModel rowSM;
    JSortTable spools;
    JLabel status;
    AS400 system;
    tnvt vt;
    SessionPanel session;
    Vector data = new Vector();
    Vector row = new Vector();
    Vector names = new Vector();
    SpooledFileList splfList;

    public SpoolExporter(tnvt vt, SessionPanel session) {
        this.vt = vt;
        this.session = session;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setTitle(LangTool.getString("spool.title"));
        this.setIconImages(GUIGraphicsUtils.getApplicationIcons());
        this.getContentPane().add((Component)this.createFilterPanel(), "North");
        this.stm = new SpoolTableModel();
        this.spools = new JSortTable(this.stm);
        TableColumn column = null;
        for (int x = 0; x < this.stm.getColumnCount(); ++x) {
            column = this.spools.getColumnModel().getColumn(x);
            column.setPreferredWidth(this.stm.getColumnPreferredSize(x));
        }
        this.spools.setAutoResizeMode(0);
        this.spools.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                SpoolExporter.this.spools_mouseClicked(e);
            }

            @Override
            public void mousePressed(MouseEvent event) {
                if (SwingUtilities.isRightMouseButton(event)) {
                    SpoolExporter.this.showPopupMenu(event);
                }
            }

            @Override
            public void mouseReleased(MouseEvent event) {
                if (SwingUtilities.isRightMouseButton(event)) {
                    SpoolExporter.this.showPopupMenu(event);
                }
            }
        });
        this.spools.setShowGrid(false);
        this.scrollPane = new JScrollPane(this.spools);
        this.scrollPane.setVerticalScrollBarPolicy(20);
        this.scrollPane.setHorizontalScrollBarPolicy(30);
        this.spools.setPreferredScrollableViewportSize(new Dimension(this.spools.getPreferredScrollableViewportSize().width, this.spools.getFontMetrics(this.spools.getFont()).getHeight() * 8));
        this.scrollPane.getViewport().setBackground(this.spools.getBackground());
        this.scrollPane.setBackground(this.spools.getBackground());
        this.rowSM = this.spools.getSelectionModel();
        this.rowSM.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel lsm = (ListSelectionModel)e.getSource();
            }
        });
        this.rowSM.setSelectionMode(0);
        this.getContentPane().add((Component)this.scrollPane, "Center");
        this.status = new JLabel("0 " + LangTool.getString("spool.count"));
        this.status.setBorder(BorderFactory.createEtchedBorder());
        this.getContentPane().add((Component)this.status, "South");
        this.packFrame = true;
        this.centerFrame();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                if (SpoolExporter.this.system != null) {
                    if (SpoolExporter.this.splfList != null) {
                        SpoolExporter.this.splfList.close();
                        SpoolExporter.this.splfList = null;
                    }
                    SpoolExporter.this.system.disconnectAllServices();
                }
                SpoolExporter.this.setVisible(false);
                SpoolExporter.this.dispose();
            }
        });
    }

    private JPanel createFilterPanel() {
        JPanel fp = new JPanel();
        fp.setLayout(new BorderLayout());
        fp.setBorder(BorderFactory.createTitledBorder(LangTool.getString("spool.filterTitle")));
        this.filter = new SpoolFilterPane();
        JPanel bp = new JPanel();
        JButton load = new JButton(LangTool.getString("spool.load"));
        JButton resetAll = new JButton(LangTool.getString("spool.resetAll"));
        JButton reset = new JButton(LangTool.getString("spool.resetPanel"));
        bp.add(load);
        load.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SpoolExporter.this.runLoader();
            }
        });
        bp.add(reset);
        reset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SpoolExporter.this.filter.resetCurrent();
            }
        });
        bp.add(resetAll);
        resetAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SpoolExporter.this.filter.resetAll();
            }
        });
        fp.add((Component)this.filter, "Center");
        fp.add((Component)bp, "South");
        return fp;
    }

    private void runLoader() {
        Runnable loader = new Runnable(){

            @Override
            public void run() {
                SpoolExporter.this.loadSpoolFiles();
            }
        };
        Thread t = new Thread(loader);
        t.setDaemon(true);
        t.start();
    }

    private void loadSpoolFiles() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        if (this.splfList != null) {
            this.splfList.removePrintObjectListListener((PrintObjectListListener)this.stm);
            this.splfList.close();
            this.splfList = null;
        }
        this.data.clear();
        try {
            this.updateStatus(LangTool.getString("spool.working"));
            if (this.system == null) {
                this.system = new AS400(this.vt.getHostName());
            }
            this.splfList = new SpooledFileList(this.system);
            this.splfList.setUserFilter(this.filter.getUser());
            this.splfList.setQueueFilter("/QSYS.LIB/" + this.filter.getLibrary() + ".LIB/" + this.filter.getQueue() + ".OUTQ");
            if (this.filter.getUserData().length() > 0) {
                this.splfList.setUserDataFilter(this.filter.getUserData());
            }
            this.stm.setDataVector(this.data, this.names);
            TableColumn column = null;
            for (int x = 0; x < this.stm.getColumnCount(); ++x) {
                column = this.spools.getColumnModel().getColumn(x);
                column.setPreferredWidth(this.stm.getColumnPreferredSize(x));
            }
            this.splfList.openAsynchronously();
            this.splfList.addPrintObjectListListener((PrintObjectListListener)this.stm);
            if (this.splfList != null) {
                this.updateStatus(this.splfList.size() + " " + LangTool.getString("spool.count"));
            }
        }
        catch (Exception erp) {
            this.updateStatus(erp.getMessage(), true);
        }
    }

    private void loadStringAttribute(SpooledFile p, Vector row, int attribute) {
        try {
            row.add(p.getStringAttribute(attribute));
        }
        catch (Exception ex) {
            row.add("Attribute Not supported");
        }
    }

    private void loadIntegerAttribute(SpooledFile p, Vector row, int attribute) {
        try {
            row.add(p.getIntegerAttribute(attribute));
        }
        catch (Exception ex) {
            row.add("Attribute Not supported");
        }
    }

    private void loadCreateDateTime(SpooledFile p, Vector row) {
        try {
            String datetime = SpoolExporter.formatDate(p.getStringAttribute(34)) + " " + SpoolExporter.formatTime(p.getStringAttribute(110));
            row.add(datetime);
        }
        catch (Exception ex) {
            row.add("Attribute Not supported");
        }
    }

    static String formatDate(String dateString) {
        if (dateString != null) {
            char[] dateArray = dateString.toCharArray();
            if (dateArray.length != 7) {
                return dateString;
            }
            StringBuffer db = new StringBuffer(10);
            db.append(dateArray, 1, 6);
            if (dateArray[0] == '0') {
                db.insert(0, "19");
            } else {
                db.insert(0, "20");
            }
            db.insert(4, '/');
            db.insert(7, '/');
            return db.toString();
        }
        return "";
    }

    static String formatTime(String timeString) {
        if (timeString != null) {
            StringBuffer tb = new StringBuffer(timeString);
            tb.insert(tb.length() - 2, ':');
            tb.insert(tb.length() - 5, ':');
            return tb.toString();
        }
        return "";
    }

    private void showPopupMenu(MouseEvent me) {
        JPopupMenu jpm = new JPopupMenu();
        final int row = this.spools.rowAtPoint(me.getPoint());
        final int col = this.spools.convertColumnIndexToModel(this.spools.columnAtPoint(me.getPoint()));
        AbstractAction action = new AbstractAction(LangTool.getString("spool.optionView")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println(row + " is selected ");
                SpoolExporter.this.spools.setCursor(Cursor.getPredefinedCursor(3));
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SpoolExporter.this.displayViewer(SpoolExporter.this.getSpooledFile(row));
                    }
                });
            }
        };
        jpm.add(action);
        action = new AbstractAction(LangTool.getString("spool.optionProps")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                JOptionPane.showMessageDialog(null, "Not Available yet", "Not yet", 2);
            }
        };
        jpm.add(action);
        jpm.addSeparator();
        action = new AbstractAction(LangTool.getString("spool.optionExport")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                SpoolExportWizard sew = new SpoolExportWizard(SpoolExporter.this.getSpooledFile(row), SpoolExporter.this.session);
                sew.setVisible(true);
            }
        };
        jpm.add(action);
        jpm.addSeparator();
        switch (col) {
            case 0: 
            case 3: 
            case 6: {
                action = new AbstractAction(LangTool.getString("spool.labelFilter")){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        SpoolExporter.this.setFilter(row, col);
                    }
                };
                jpm.add(action);
                jpm.addSeparator();
            }
        }
        action = new AbstractAction(LangTool.getString("spool.optionHold")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                SpoolExporter.this.doSpoolStuff(SpoolExporter.this.getSpooledFile(row), e.getActionCommand());
            }
        };
        jpm.add(action);
        action = new AbstractAction(LangTool.getString("spool.optionRelease")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                SpoolExporter.this.doSpoolStuff(SpoolExporter.this.getSpooledFile(row), e.getActionCommand());
            }
        };
        jpm.add(action);
        action = new AbstractAction(LangTool.getString("spool.optionDelete")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                SpoolExporter.this.doSpoolStuff(SpoolExporter.this.getSpooledFile(row), e.getActionCommand());
            }
        };
        jpm.add(action);
        GUIGraphicsUtils.positionPopup(this.spools, jpm, me.getX(), me.getY());
    }

    private SpooledFile getSpooledFile(int row) {
        Vector rows = (Vector)this.data.get(row);
        SpooledFile splf = new SpooledFile(this.system, (String)rows.get(0), ((Integer)rows.get(1)).intValue(), (String)rows.get(2), (String)rows.get(3), (String)rows.get(4));
        return splf;
    }

    private void doSpoolStuff(SpooledFile splf, String action) {
        try {
            if (action.equals(LangTool.getString("spool.optionHold"))) {
                splf.hold(null);
            }
            if (action.equals(LangTool.getString("spool.optionRelease"))) {
                splf.release();
            }
            if (action.equals(LangTool.getString("spool.optionDelete"))) {
                splf.delete();
            }
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
    }

    void spools_mouseClicked(MouseEvent e) {
        if (e.getClickCount() > 1) {
            final int row = this.spools.rowAtPoint(e.getPoint());
            this.spools.setCursor(Cursor.getPredefinedCursor(3));
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SpoolExporter.this.displayViewer(SpoolExporter.this.getSpooledFile(row));
                }
            });
        }
    }

    private void displayViewer(SpooledFile splf) {
        SpooledFileViewer sfv = new SpooledFileViewer(splf, 1);
        try {
            sfv.load();
            JFrame viewer = new JFrame(LangTool.getString("spool.viewerTitle"));
            viewer.setIconImage(this.getIconImage());
            viewer.getContentPane().add((Component)sfv);
            viewer.pack();
            viewer.setVisible(true);
        }
        catch (Exception exc) {
            this.updateStatus(exc.getMessage(), true);
        }
        this.spools.setCursor(Cursor.getPredefinedCursor(0));
    }

    private void setFilter(int row, int col) {
        switch (col) {
            case 0: {
                this.filter.setSpoolName((String)this.spools.getModel().getValueAt(row, col));
                break;
            }
            case 3: {
                this.filter.setUser((String)this.spools.getModel().getValueAt(row, col));
                break;
            }
            case 6: {
                this.filter.setUserData((String)this.spools.getModel().getValueAt(row, col));
                break;
            }
        }
        System.out.println((String)this.spools.getModel().getValueAt(row, col));
    }

    private void updateStatus(final String stat, boolean error) {
        if (error) {
            this.status.setForeground(Color.red);
        } else {
            this.status.setForeground(Color.black);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SpoolExporter.this.status.setText(stat);
            }
        });
    }

    private void updateStatus(String stat) {
        this.updateStatus(stat, false);
    }

    class SpoolTableModel
    extends DefaultSortTableModel
    implements PrintObjectListListener {
        private static final long serialVersionUID = 1L;
        String[] cols;
        int[] colsSizes;
        final String colLayout = "Spool Name|100|Spool Number|90|Job Name|100|Job User|100|Job Number|90|Queue|200|User Data|100|Status|100|Total Pages|90|Current Page|90|Copies|90|Form Type|100|Priority|40|Creation Date/Time|175|Size|120";

        public SpoolTableModel() {
            StringTokenizer stringtokenizer = new StringTokenizer("Spool Name|100|Spool Number|90|Job Name|100|Job User|100|Job Number|90|Queue|200|User Data|100|Status|100|Total Pages|90|Current Page|90|Copies|90|Form Type|100|Priority|40|Creation Date/Time|175|Size|120", "|");
            this.colsSizes = new int[stringtokenizer.countTokens() / 2];
            this.cols = new String[stringtokenizer.countTokens() / 2];
            int i = 0;
            while (stringtokenizer.hasMoreTokens()) {
                this.cols[i] = stringtokenizer.nextToken();
                this.colsSizes[i++] = Integer.parseInt(stringtokenizer.nextToken());
            }
        }

        @Override
        public int getColumnCount() {
            return this.cols.length;
        }

        @Override
        public String getColumnName(int col) {
            return this.cols[col];
        }

        public int getColumnPreferredSize(int col) {
            return this.colsSizes[col];
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }

        public void listClosed(PrintObjectListEvent e) {
            SwingUtilities.invokeLater(new Thread(){

                @Override
                public void run() {
                    SpoolTableModel.this.fireTableDataChanged();
                }
            });
        }

        public void listCompleted(PrintObjectListEvent e) {
            SpoolExporter.this.setCursor(Cursor.getPredefinedCursor(0));
            SwingUtilities.invokeLater(new Thread(){

                @Override
                public void run() {
                    SpoolTableModel.this.fireTableDataChanged();
                }
            });
        }

        public void listErrorOccurred(PrintObjectListEvent e) {
            System.err.println("list error occurred : " + e.getException().getMessage());
            SwingUtilities.invokeLater(new Thread(){

                @Override
                public void run() {
                    SpoolTableModel.this.fireTableDataChanged();
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void listObjectAdded(PrintObjectListEvent e) {
            boolean spoolFilter = SpoolExporter.this.filter.getSpoolName().length() > 0;
            String spoolName = SpoolExporter.this.filter.getSpoolName();
            SpooledFile p = (SpooledFile)e.getObject();
            Vector<String> row = new Vector<String>();
            if (spoolFilter && !spoolName.equals(p.getName())) {
                return;
            }
            row.add(p.getName());
            SpoolExporter.this.loadIntegerAttribute(p, row, 105);
            SpoolExporter.this.loadStringAttribute(p, row, 59);
            SpoolExporter.this.loadStringAttribute(p, row, 62);
            SpoolExporter.this.loadStringAttribute(p, row, 60);
            SpoolExporter.this.loadStringAttribute(p, row, -6);
            SpoolExporter.this.loadStringAttribute(p, row, 116);
            SpoolExporter.this.loadStringAttribute(p, row, 106);
            SpoolExporter.this.loadIntegerAttribute(p, row, 111);
            SpoolExporter.this.loadIntegerAttribute(p, row, 30);
            SpoolExporter.this.loadIntegerAttribute(p, row, 28);
            SpoolExporter.this.loadStringAttribute(p, row, 48);
            SpoolExporter.this.loadStringAttribute(p, row, 72);
            SpoolExporter.this.loadCreateDateTime(p, row);
            SpoolExporter.this.loadIntegerAttribute(p, row, 125);
            Vector vector = SpoolExporter.this.data;
            synchronized (vector) {
                SpoolExporter.this.data.add(row);
            }
            SwingUtilities.invokeLater(new Thread(){

                @Override
                public void run() {
                    SpoolTableModel.this.fireTableDataChanged();
                    SpoolExporter.this.updateStatus(SpoolExporter.this.data.size() + " " + LangTool.getString("spool.count"));
                }
            });
        }

        public void listOpened(PrintObjectListEvent e) {
            System.out.println("list opened");
            SwingUtilities.invokeLater(new Thread(){

                @Override
                public void run() {
                    SpoolTableModel.this.fireTableDataChanged();
                }
            });
        }
    }
}

