/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j.sql;

import com.ibm.as400.access.AS400;
import com.ibm.as400.vaccess.SQLConnection;
import com.ibm.as400.vaccess.SQLQueryBuilderPane;
import com.ibm.as400.vaccess.SQLResultSetTablePane;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Driver;
import java.sql.DriverManager;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import org.tn5250j.tools.GUIGraphicsUtils;
import org.tn5250j.tools.LangTool;
import org.tn5250j.tools.system.OperatingSystem;

public class SqlWizard
extends JFrame {
    private static final long serialVersionUID = 1L;
    private SQLConnection connection;
    private AS400 system;
    private SQLQueryBuilderPane queryBuilder;
    private SQLResultSetTablePane tablePane;
    private String name;
    private String password;
    private String host;
    private String queryText;
    private JTextArea queryTextArea;

    public SqlWizard(String host, String name, String password) {
        this.host = host;
        this.name = name;
        this.password = password;
        this.enableEvents(64L);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        try {
            this.setIconImages(GUIGraphicsUtils.getApplicationIcons());
            this.setTitle(LangTool.getString("xtfr.wizardTitle"));
            Driver driver2 = (Driver)Class.forName("com.ibm.as400.access.AS400JDBCDriver").newInstance();
            DriverManager.registerDriver(driver2);
            this.connection = new SQLConnection("jdbc:as400://" + this.host, this.name, this.password);
            this.queryBuilder = new SQLQueryBuilderPane(this.connection);
            this.queryBuilder.setTableSchemas(new String[]{"*USRLIBL"});
            this.queryBuilder.load();
            JButton done = new JButton(LangTool.getString("xtfr.tableDone"));
            done.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SqlWizard.this.fillQueryTextArea();
                }
            });
            JPanel panel = new JPanel();
            panel.add(done);
            this.getContentPane().add((Component)this.queryBuilder, "Center");
            this.getContentPane().add((Component)panel, "South");
            Dimension max = new Dimension(OperatingSystem.getScreenBounds().width, OperatingSystem.getScreenBounds().height);
            this.pack();
            if (this.getSize().width > max.width) {
                this.setSize(max.width, this.getSize().height);
            }
            if (this.getSize().height > max.height) {
                this.setSize(this.getSize().width, max.height);
            }
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension frameSize = this.getSize();
            if (frameSize.height > screenSize.height) {
                frameSize.height = screenSize.height;
            }
            if (frameSize.width > screenSize.width) {
                frameSize.width = screenSize.width;
            }
            this.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
            this.setVisible(true);
        }
        catch (ClassNotFoundException cnfe) {
            JOptionPane.showMessageDialog(null, "Error loading AS400 JDBC Driver", "Error", 0);
        }
    }

    private void fillQueryTextArea() {
        this.queryTextArea.append(this.queryBuilder.getQuery());
        this.setVisible(false);
        this.dispose();
    }

    public void setQueryTextArea(JTextArea qta) {
        this.queryTextArea = qta;
    }
}

