/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j.tools;

import java.awt.Toolkit;
import java.text.NumberFormat;
import java.text.ParseException;
import javax.swing.JTextField;
import org.tn5250j.tools.FormattedDocument;

public class DecimalField
extends JTextField {
    private static final long serialVersionUID = 1L;
    private NumberFormat format;

    public DecimalField(double value, int columns, NumberFormat f) {
        super(columns);
        this.setDocument(new FormattedDocument(f));
        this.format = f;
        this.setValue(value);
    }

    public double getValue() {
        double retVal = 0.0;
        try {
            retVal = this.format.parse(this.getText()).doubleValue();
        }
        catch (ParseException e) {
            Toolkit.getDefaultToolkit().beep();
            System.err.println("getValue: could not parse: " + this.getText());
        }
        return retVal;
    }

    public void setValue(double value) {
        this.setText(this.format.format(value));
    }
}

