/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j.tools;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.tn5250j.event.FTPStatusEvent;
import org.tn5250j.event.FTPStatusListener;
import org.tn5250j.framework.tn5250.tnvt;
import org.tn5250j.tools.As400Util;
import org.tn5250j.tools.LangTool;
import org.tn5250j.tools.filters.FileFieldDef;
import org.tn5250j.tools.filters.OutputFilterInterface;

public class FTP5250Prot {
    private Socket ftpConnectionSocket;
    private BufferedReader ftpInputStream;
    private PrintStream ftpOutputStream;
    private InetAddress localHost;
    private boolean loggedIn;
    private String lastResponse;
    private int lastIntResponse;
    private String hostName;
    private int timeout = 50000;
    private boolean connected;
    private String remoteDir;
    private ArrayList ffd;
    private tnvt vt;
    private int recordLength;
    private int recordOutLength;
    private int fileSize;
    private Vector<FTPStatusListener> listeners;
    private FTPStatusEvent status;
    private boolean aborted;
    private char decChar;
    private OutputFilterInterface ofi;
    private Vector members;
    private Thread getThread;

    public FTP5250Prot(tnvt v) {
        this.vt = v;
        this.status = new FTPStatusEvent(this);
        DecimalFormat formatter = (DecimalFormat)NumberFormat.getInstance(Locale.getDefault());
        this.decChar = formatter.getDecimalFormatSymbols().getDecimalSeparator();
    }

    public void setOutputFilter(OutputFilterInterface o) {
        this.ofi = o;
    }

    public void setDecimalChar(char dec) {
        this.decChar = dec;
    }

    public boolean connect(String host, int port) {
        try {
            this.hostName = host;
            this.ftpConnectionSocket = new Socket(host, port);
            this.ftpConnectionSocket.setSoTimeout(this.timeout);
            this.localHost = this.ftpConnectionSocket.getLocalAddress();
            this.ftpInputStream = new BufferedReader(new InputStreamReader(this.ftpConnectionSocket.getInputStream()));
            this.ftpOutputStream = new PrintStream(this.ftpConnectionSocket.getOutputStream());
            this.parseResponse();
            this.fileSize = 0;
            if (this.lastIntResponse == 220) {
                this.connected = true;
                return true;
            }
            this.connected = false;
            return false;
        }
        catch (Exception _ex) {
            return false;
        }
    }

    public void disconnect() {
        try {
            if (this.isConnected()) {
                this.executeCommand("QUIT");
                this.ftpOutputStream.close();
                this.ftpInputStream.close();
                this.ftpConnectionSocket.close();
                this.connected = false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isConnected() {
        return this.connected;
    }

    public synchronized void addFTPStatusListener(FTPStatusListener listener) {
        if (this.listeners == null) {
            this.listeners = new Vector(3);
        }
        this.listeners.addElement(listener);
    }

    private void fireStatusEvent() {
        if (this.listeners != null) {
            int size = this.listeners.size();
            for (int i = 0; i < size; ++i) {
                FTPStatusListener target = this.listeners.elementAt(i);
                target.statusReceived(this.status);
            }
        }
    }

    private void fireCommandEvent() {
        if (this.listeners != null) {
            int size = this.listeners.size();
            for (int i = 0; i < size; ++i) {
                FTPStatusListener target = this.listeners.elementAt(i);
                target.commandStatusReceived(this.status);
            }
        }
    }

    private void fireInfoEvent() {
        if (this.listeners != null) {
            int size = this.listeners.size();
            for (int i = 0; i < size; ++i) {
                FTPStatusListener target = this.listeners.elementAt(i);
                target.fileInfoReceived(this.status);
            }
        }
    }

    public synchronized void removeFTPStatusListener(FTPStatusListener listener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.removeElement(listener);
    }

    public boolean login(String user, String passWord) {
        if (this.ftpOutputStream == null) {
            this.printFTPInfo("Not connected to any server!");
            return false;
        }
        this.aborted = false;
        this.loggedIn = true;
        this.executeCommand("USER", user);
        int resp = this.executeCommand("PASS", passWord);
        if (resp != 230) {
            this.loggedIn = false;
            return false;
        }
        this.loggedIn = true;
        if (!this.isConnectedToOS400()) {
            this.printFTPInfo("Remote server is not an OS/400.  Disconnecting!");
            this.disconnect();
        }
        this.getRemoteDirectory();
        return true;
    }

    protected void printDirListing() {
        try {
            String file;
            Socket passSocket = this.createPassiveSocket("NLST");
            BufferedReader br = new BufferedReader(new InputStreamReader(passSocket.getInputStream()));
            while ((file = br.readLine()) != null) {
                System.out.println(file);
            }
            passSocket.close();
            this.parseResponse();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean isConnectedToOS400() {
        this.executeCommand("SYST");
        return this.lastResponse.toUpperCase().indexOf("OS/400") >= 0;
    }

    public boolean isFieldSelected(int which) {
        FileFieldDef ffD = (FileFieldDef)this.ffd.get(which);
        return ffD.isWriteField();
    }

    protected void selectAll() {
        for (int x = 0; x < this.ffd.size(); ++x) {
            FileFieldDef f = (FileFieldDef)this.ffd.get(x);
            f.setWriteField(true);
        }
    }

    protected void selectNone() {
        for (int x = 0; x < this.ffd.size(); ++x) {
            FileFieldDef f = (FileFieldDef)this.ffd.get(x);
            f.setWriteField(false);
        }
    }

    public boolean isFieldsSelected() {
        for (int x = 0; x < this.ffd.size(); ++x) {
            FileFieldDef f = (FileFieldDef)this.ffd.get(x);
            if (!f.isWriteField()) continue;
            return true;
        }
        return false;
    }

    public void setFieldSelected(int which, boolean value) {
        FileFieldDef ffD = (FileFieldDef)this.ffd.get(which);
        ffD.setWriteField(value);
    }

    public String getFieldName(int which) {
        FileFieldDef ffD = (FileFieldDef)this.ffd.get(which);
        return ffD.getFieldName();
    }

    public int getNumberOfFields() {
        return this.ffd.size();
    }

    private void getRemoteDirectory() {
        this.executeCommand("PWD");
        int i = this.lastResponse.indexOf("\"");
        int j = this.lastResponse.lastIndexOf("\"");
        this.remoteDir = i != -1 && j != -1 ? this.lastResponse.substring(i + 1, j) : "Can't parse remote dir!";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Socket createPassiveSocket(String cmd) {
        ServerSocket ss = null;
        try {
            byte[] abyte0 = this.localHost.getAddress();
            ss = new ServerSocket(0);
            ss.setSoTimeout(this.timeout);
            StringBuffer pb = new StringBuffer("PORT ");
            for (int i = 0; i < abyte0.length; ++i) {
                pb.append(abyte0[i] & 0xFF);
                pb.append(",");
            }
            pb.append(ss.getLocalPort() >>> 8 & 0xFF);
            pb.append(",");
            pb.append(ss.getLocalPort() & 0xFF);
            this.executeCommand(pb.toString());
            this.executeCommand(cmd);
            if (this.lastResponse.startsWith("5") || this.lastResponse.startsWith("4")) {
                Socket i = null;
                return i;
            }
            Socket socket = ss.accept();
            socket.setSoTimeout(this.timeout);
            Socket socket2 = socket;
            return socket2;
        }
        catch (IOException ioexception) {
            this.printFTPInfo("I/O error while setting up a ServerSocket on the client machine!" + ioexception);
            Socket socket = null;
            return socket;
        }
        finally {
            try {
                if (ss != null) {
                    ss.close();
                }
            }
            catch (IOException ioexception1) {
                this.printFTPInfo("createPassiveSocket.close() exception!" + ioexception1);
            }
        }
    }

    protected boolean getFileInfo(String tFile, boolean useInternal) {
        int memberOffset = tFile.indexOf(".");
        String file2 = null;
        String member2 = null;
        if (memberOffset > 0) {
            file2 = tFile.substring(0, memberOffset);
            member2 = tFile.substring(memberOffset + 1);
        } else {
            file2 = tFile;
        }
        final String file = file2;
        final String member = member2;
        final boolean internal = useInternal;
        Runnable getInfo = new Runnable(){

            @Override
            public void run() {
                FTP5250Prot.this.executeCommand("RCMD", "dspffd FILE(" + file + ") OUTPUT(*OUTFILE) OUTFILE(QTEMP/FFD) ");
                if (FTP5250Prot.this.lastResponse.startsWith("2") && FTP5250Prot.this.loadFFD(internal) && FTP5250Prot.this.lastResponse.startsWith("2") && FTP5250Prot.this.getMbrInfo(file, member)) {
                    FTP5250Prot.this.fireInfoEvent();
                }
            }
        };
        Thread infoThread = new Thread(getInfo);
        infoThread.start();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadFFD(boolean useInternal) {
        Socket socket = null;
        BufferedReader dis = null;
        String remoteFile = "QTEMP/FFD";
        String recLength = "";
        Vector<String> allowsNullFields = null;
        try {
            String data;
            socket = this.createPassiveSocket("RETR " + remoteFile);
            if (socket == null) {
                boolean bl = false;
                return bl;
            }
            dis = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            if (this.ffd != null) {
                this.ffd.clear();
                this.ffd = null;
            }
            this.ffd = new ArrayList();
            while ((data = dis.readLine()) != null) {
                FileFieldDef ffDesc = new FileFieldDef(this.vt, this.decChar);
                if (useInternal) {
                    ffDesc.setFieldName(data.substring(129, 139));
                } else {
                    String text = "";
                    text = data.substring(261, 281).trim() + " " + data.substring(281, 301).trim() + " " + data.substring(301, 321).trim();
                    if (text.length() > 0) {
                        ffDesc.setFieldName(text);
                    } else {
                        ffDesc.setFieldName(data.substring(168, 218).trim());
                        if (ffDesc.getFieldName().trim().length() == 0) {
                            ffDesc.setFieldName(data.substring(129, 139));
                        }
                    }
                }
                ffDesc.setStartOffset(data.substring(149, 154));
                ffDesc.setFieldLength(data.substring(159, 164));
                ffDesc.setNumDigits(data.substring(164, 166));
                ffDesc.setDecPositions(data.substring(166, 168));
                ffDesc.setFieldType(data.substring(321, 322));
                ffDesc.setFieldText(data.substring(168, 218));
                if (data.substring(503, 504).equals("Y")) {
                    if (allowsNullFields == null) {
                        allowsNullFields = new Vector<String>(3);
                    }
                    allowsNullFields.add(ffDesc.getFieldName());
                    this.printFTPInfo("Warning -- File allows null fields!!!");
                }
                ffDesc.setWriteField(true);
                recLength = data.substring(124, 129);
                this.ffd.add(ffDesc);
            }
            this.printFTPInfo("Field Information Transfer complete!");
            if (allowsNullFields != null) {
                JPanel jp = new JPanel();
                jp.setLayout(new BorderLayout());
                JLabel message = new JLabel(LangTool.getString("messages.nullFieldWarning"));
                JTextArea jta = new JTextArea(6, 30);
                jta.setEditable(false);
                JScrollPane sp = new JScrollPane(jta);
                String text = new String();
                for (int x = 0; x < allowsNullFields.size(); ++x) {
                    text = text + allowsNullFields.get(x) + "\n";
                }
                jta.setText(text);
                jp.add((Component)message, "North");
                jp.add((Component)sp, "Center");
                JOptionPane.showMessageDialog(null, jp, "Warning", 2);
            }
        }
        catch (Exception _ex) {
            this.printFTPInfo("I/O error!");
            boolean jp = false;
            return jp;
        }
        finally {
            try {
                socket.close();
            }
            catch (Exception message) {}
            try {
                dis.close();
            }
            catch (Exception message) {}
        }
        int l = 0;
        int o = 0;
        int r = Integer.parseInt(recLength);
        this.printFTPInfo("<----------------- File Field Information ---------------->");
        for (int x = 0; x < this.ffd.size(); ++x) {
            FileFieldDef f = (FileFieldDef)this.ffd.get(x);
            l += f.getFieldLength();
            o += f.getBufferOutLength();
            this.printFTPInfo(f.toString());
        }
        this.recordLength = l;
        this.recordOutLength = o;
        System.out.println(r + " " + l + " " + o);
        this.parseResponse();
        return true;
    }

    protected boolean getMbrInfo(String file, String member) {
        this.executeCommand("RCMD", "dspfd FILE(" + file + ") TYPE(*MBR) OUTPUT(*OUTFILE) OUTFILE(QTEMP/FML) ");
        if (!this.lastResponse.startsWith("2")) {
            return false;
        }
        return !this.getMbrSize(member) || this.lastResponse.startsWith("2");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getMbrSize(String member) {
        boolean flag = true;
        if (this.ftpOutputStream == null) {
            this.printFTPInfo("Not connected to any server!");
            return false;
        }
        if (!this.loggedIn) {
            this.printFTPInfo("Login was not successful! Aborting!");
            return false;
        }
        Socket socket = null;
        FilterInputStream datainputstream = null;
        this.executeCommand("TYPE", "I");
        String remoteFile = "QTEMP/FML";
        this.members = new Vector(10);
        try {
            socket = this.createPassiveSocket("RETR " + remoteFile);
            if (socket != null) {
                datainputstream = new DataInputStream(socket.getInputStream());
                byte[] abyte0 = new byte[858];
                int c = 0;
                int len = 0;
                StringBuffer sb = new StringBuffer(10);
                this.printFTPInfo("<----------------- Member Information ---------------->");
                int j = 0;
                while (j != -1 && !this.aborted && (j = datainputstream.read()) != -1) {
                    ++c;
                    abyte0[len++] = (byte)j;
                    if (len != abyte0.length) continue;
                    sb.setLength(0);
                    for (int f = 0; f < 10; ++f) {
                        sb.append(this.vt.getCodePage().ebcdic2uni(abyte0[163 + f] & 0xFF));
                    }
                    this.printFTPInfo(sb + " " + As400Util.packed2int(abyte0, 345, 5));
                    this.members.add(new MemberInfo(sb.toString(), As400Util.packed2int(abyte0, 345, 5)));
                    len = 0;
                }
                this.printFTPInfo("Member list Transfer complete!");
            } else {
                flag = false;
            }
        }
        catch (Exception _ex) {
            this.printFTPInfo("Error! " + _ex);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                socket.close();
            }
            catch (Exception exception) {}
            try {
                datainputstream.close();
            }
            catch (Exception exception) {}
        }
        this.parseResponse();
        return flag;
    }

    public String getFullFileName(String tFile) {
        int memberOffset = tFile.indexOf(".");
        String file2 = null;
        String member2 = null;
        if (memberOffset > 0) {
            file2 = tFile.substring(0, memberOffset);
            member2 = tFile.substring(memberOffset + 1);
        } else {
            file2 = tFile;
        }
        if (this.members != null) {
            if (member2 == null) {
                MemberInfo mi = (MemberInfo)this.members.get(0);
                this.fileSize = mi.getSize();
                this.status.setFileLength(mi.getSize());
                member2 = mi.getName();
            } else {
                Iterator i = this.members.iterator();
                MemberInfo mi = null;
                while (i.hasNext()) {
                    mi = (MemberInfo)i.next();
                    if (!mi.getName().trim().equalsIgnoreCase(member2.trim())) continue;
                    this.fileSize = mi.getSize();
                    this.status.setFileLength(mi.getSize());
                    break;
                }
            }
        }
        if (member2 != null) {
            return file2.trim() + "." + member2.trim();
        }
        return file2.trim();
    }

    public int getFileSize() {
        return this.fileSize;
    }

    protected boolean printHelp() {
        this.executeCommand("HELP");
        return true;
    }

    protected boolean getFile(String remoteFile, String localFile) {
        boolean flag = true;
        if (this.ftpOutputStream == null) {
            this.printFTPInfo("Not connected to any server!");
            return false;
        }
        if (!this.loggedIn) {
            this.printFTPInfo("Login was not successful! Aborting!");
            return false;
        }
        final String localFileF = localFile;
        final String remoteFileF = remoteFile;
        Runnable getRun = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Socket socket = null;
                FilterInputStream datainputstream = null;
                String localFileFull = localFileF;
                FTP5250Prot.this.executeCommand("TYPE", "I");
                try {
                    socket = FTP5250Prot.this.createPassiveSocket("RETR " + remoteFileF);
                    if (socket != null) {
                        datainputstream = new DataInputStream(socket.getInputStream());
                        FTP5250Prot.this.writeHeader(localFileFull);
                        byte[] abyte0 = new byte[FTP5250Prot.this.recordLength];
                        StringBuffer rb = new StringBuffer(FTP5250Prot.this.recordOutLength);
                        int c = 0;
                        int len = 0;
                        int j = 0;
                        while (j != -1 && !FTP5250Prot.this.aborted && (j = datainputstream.read()) != -1) {
                            ++c;
                            abyte0[len++] = (byte)j;
                            if (len == FTP5250Prot.this.recordLength) {
                                rb.setLength(0);
                                FTP5250Prot.this.parseFFD(abyte0, rb);
                                len = 0;
                                FTP5250Prot.this.status.setCurrentRecord(c / FTP5250Prot.this.recordLength);
                                FTP5250Prot.this.fireStatusEvent();
                            }
                            Thread.yield();
                        }
                        System.out.println(c);
                        if (c == 0) {
                            FTP5250Prot.this.status.setCurrentRecord(c);
                            FTP5250Prot.this.fireStatusEvent();
                        } else if (!FTP5250Prot.this.aborted) {
                            FTP5250Prot.this.parseResponse();
                        }
                        FTP5250Prot.this.writeFooter();
                        FTP5250Prot.this.printFTPInfo("Transfer complete!");
                    }
                }
                catch (InterruptedIOException iioe) {
                    FTP5250Prot.this.printFTPInfo("Interrupted! " + iioe.getMessage());
                }
                catch (Exception _ex) {
                    FTP5250Prot.this.printFTPInfo("Error! " + _ex);
                }
                finally {
                    try {
                        socket.close();
                    }
                    catch (Exception iioe) {}
                    try {
                        datainputstream.close();
                    }
                    catch (Exception iioe) {}
                    try {
                        FTP5250Prot.this.writeFooter();
                    }
                    catch (Exception iioe) {}
                    FTP5250Prot.this.disconnect();
                }
            }
        };
        this.getThread = new Thread(getRun);
        this.getThread.setPriority(2);
        this.getThread.start();
        return flag;
    }

    private void parseFFD(byte[] cByte, StringBuffer rb) {
        this.ofi.parseFields(cByte, this.ffd, rb);
    }

    public void setAborted() {
        this.aborted = true;
    }

    private void printFTPInfo(String msgText) {
        this.status.setMessage(msgText);
        this.fireCommandEvent();
    }

    private int executeCommand(String cmd) {
        return this.executeCommand(cmd, null);
    }

    private int executeCommand(String cmd, String params) {
        if (this.ftpOutputStream == null) {
            this.printFTPInfo("Not connected to any server!");
            return 0;
        }
        if (!this.loggedIn) {
            this.printFTPInfo("Login was not successful! Aborting!");
            return 0;
        }
        if (params != null) {
            this.ftpOutputStream.print(cmd + " " + params + "\r\n");
        } else {
            this.ftpOutputStream.print(cmd + "\r\n");
        }
        if (!cmd.equals("PASS")) {
            this.printFTPInfo("SENT: " + cmd + " " + (params != null ? params : ""));
        } else {
            this.printFTPInfo("SENT: PASS ****************");
        }
        this.parseResponse();
        return this.lastIntResponse;
    }

    private String parseResponse() {
        try {
            String response;
            if (this.ftpInputStream == null) {
                return "0000 Response Invalid";
            }
            String response2 = response = this.ftpInputStream.readLine();
            boolean append = true;
            while (!(response2 != null && response2.length() >= 4 && Character.isDigit(response2.charAt(0)) && Character.isDigit(response2.charAt(1)) && Character.isDigit(response2.charAt(2)) && response2.charAt(3) == ' ')) {
                if (append) {
                    response = response + "\n";
                    append = false;
                }
                response2 = this.ftpInputStream.readLine();
                response = response + response2 + "\n";
            }
            this.lastIntResponse = Integer.parseInt(response.substring(0, 3));
            this.lastResponse = response;
            this.printFTPInfo(this.lastResponse);
            return this.lastResponse;
        }
        catch (Exception exception) {
            System.out.println(exception);
            exception.printStackTrace();
            return "0000 Response Invalid";
        }
    }

    private void writeHeader(String fileName) throws FileNotFoundException {
        this.ofi.createFileInstance(fileName);
        this.ofi.writeHeader(fileName, this.hostName, this.ffd, this.decChar);
    }

    private void writeFooter() {
        this.ofi.writeFooter(this.ffd);
    }

    class MemberInfo {
        private String name;
        private int size;

        MemberInfo(String name, int size) {
            this.name = name;
            this.size = size;
        }

        public String getName() {
            return this.name;
        }

        public int getSize() {
            return this.size;
        }
    }
}

