/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j.tools;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.tn5250j.SessionPanel;
import org.tn5250j.interfaces.ConfigureFactory;
import org.tn5250j.scripting.InterpreterDriverManager;

public class Macronizer {
    private static Properties macros;
    private static boolean macrosExist;

    public static void init() {
        if (macros != null) {
            return;
        }
        macrosExist = Macronizer.loadMacros();
    }

    private static boolean loadMacros() {
        macros = ConfigureFactory.getInstance().getProperties("macros");
        if (macros != null && macros.size() > 0) {
            return true;
        }
        return Macronizer.checkScripts();
    }

    private static final void saveMacros() {
        ConfigureFactory.getInstance().saveSettings("macros", "------ Macros --------");
    }

    public static final boolean isMacrosExist() {
        return macrosExist;
    }

    public static final int getNumOfMacros() {
        return macros.size();
    }

    public static final String[] getMacroList() {
        String[] macroList = new String[macros.size()];
        Set<Object> macroSet = macros.keySet();
        Iterator<Object> macroIterator = macroSet.iterator();
        String byName = null;
        int x = 0;
        while (macroIterator.hasNext()) {
            byName = (String)macroIterator.next();
            int period = byName.indexOf(".");
            macroList[x++] = byName.substring(period + 1);
        }
        return macroList;
    }

    public static final String getMacroByNumber(int num) {
        String mac = "macro" + num + ".";
        Set<Object> macroSet = macros.keySet();
        Iterator<Object> macroIterator = macroSet.iterator();
        String byNum = null;
        while (macroIterator.hasNext()) {
            byNum = (String)macroIterator.next();
            if (!byNum.startsWith(mac)) continue;
            return (String)macros.get(byNum);
        }
        return null;
    }

    public static final String getMacroByName(String name) {
        Set<Object> macroSet = macros.keySet();
        Iterator<Object> macroIterator = macroSet.iterator();
        String byName = null;
        while (macroIterator.hasNext()) {
            byName = (String)macroIterator.next();
            if (!byName.endsWith(name)) continue;
            return (String)macros.get(byName);
        }
        return null;
    }

    public static final void removeMacroByName(String name) {
        Set<Object> macroSet = macros.keySet();
        Iterator<Object> macroIterator = macroSet.iterator();
        String byName = null;
        while (macroIterator.hasNext()) {
            byName = (String)macroIterator.next();
            if (!byName.endsWith(name)) continue;
            macros.remove(byName);
            Macronizer.saveMacros();
            return;
        }
    }

    public static final void setMacro(String name, String keyStrokes) {
        int x = 0;
        if (macrosExist && Macronizer.getMacroByName(name) != null) {
            Set<Object> macroSet = macros.keySet();
            Iterator<Object> macroIterator = macroSet.iterator();
            String byName = null;
            String prefix = null;
            while (macroIterator.hasNext()) {
                byName = (String)macroIterator.next();
                if (!byName.endsWith(name)) continue;
                prefix = byName.substring(0, byName.indexOf(name));
                macros.put(prefix + name, keyStrokes);
            }
        } else {
            while (Macronizer.getMacroByNumber(++x) != null) {
            }
            macros.put("macro" + x + "." + name, keyStrokes);
            macrosExist = true;
        }
        Macronizer.saveMacros();
    }

    public static void showRunScriptDialog(SessionPanel session) {
        String value;
        JPanel rsp = new JPanel();
        rsp.setLayout(new BorderLayout());
        JLabel jl = new JLabel("Enter script to run");
        final JTextField rst = new JTextField();
        rsp.add((Component)jl, "North");
        rsp.add((Component)rst, "Center");
        Object[] message = new Object[]{rsp};
        Object[] options = new String[]{"Run", "Cancel"};
        JOptionPane pane = new JOptionPane(message, 3, -1, null, options, options[0]);
        JDialog dialog = pane.createDialog(session, "Run Script");
        dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                super.windowOpened(e);
                rst.requestFocus();
            }
        });
        dialog.setVisible(true);
        Object myValue = pane.getValue();
        if (!(myValue instanceof Integer) && (value = (String)myValue).equals(options[0]) && rst.getText().length() > 0) {
            Macronizer.invoke(rst.getText(), session);
        }
    }

    public static final void invoke(String macro, SessionPanel session) {
        String keys = Macronizer.getMacroByName(macro);
        if (keys != null) {
            session.getScreen().sendKeys(keys);
        } else {
            try {
                if (!macro.endsWith(".py")) {
                    macro = macro + ".py";
                }
                InterpreterDriverManager.executeScriptFile(session, "scripts" + File.separatorChar + macro);
            }
            catch (Exception ex) {
                System.err.println(ex);
            }
        }
    }

    private static boolean checkScripts() {
        File directory = new File("scripts");
        File directory2 = new File(ConfigureFactory.getInstance().getProperty("emulator.settingsDirectory") + "scripts");
        return directory.isDirectory() || directory2.isDirectory();
    }
}

