/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j.tools;

import java.awt.Component;
import java.awt.Frame;
import java.io.File;
import org.tn5250j.SessionPanel;
import org.tn5250j.gui.TN5250jFileChooser;
import org.tn5250j.tools.encoder.EncodeComponent;
import org.tn5250j.tools.filters.XTFRFileFilter;
import org.tn5250j.tools.logging.TN5250jLogFactory;
import org.tn5250j.tools.logging.TN5250jLogger;

public class SendScreenImageToFile {
    SessionPanel session;
    Frame parent;
    private TN5250jLogger log = TN5250jLogFactory.getLogger(this.getClass());

    public SendScreenImageToFile(Frame parent, SessionPanel ses) {
        this.session = ses;
        this.parent = parent;
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            this.log.warn("Error in constructor: " + ex.getMessage());
        }
    }

    void jbInit() throws Exception {
        this.getPCFile();
    }

    private void getPCFile() {
        String workingDir = System.getProperty("user.dir");
        TN5250jFileChooser pcFileChooser = new TN5250jFileChooser(workingDir);
        XTFRFileFilter pngFilter = new XTFRFileFilter("png", "Portable Network Graphics");
        pcFileChooser.setFileFilter(pngFilter);
        int ret = pcFileChooser.showSaveDialog(this.parent);
        if (ret == 0) {
            try {
                File file = !pcFileChooser.getSelectedFile().getCanonicalPath().endsWith(".png") ? new File(pcFileChooser.getSelectedFile().getCanonicalPath() + ".png") : pcFileChooser.getSelectedFile();
                EncodeComponent.encode(EncodeComponent.PNG, (Component)this.session, file);
            }
            catch (Exception e) {
                this.log.warn("Error generating PNG exception caught: " + e.getMessage());
            }
        }
    }
}

