/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j.tools;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ProgressMonitor;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.table.AbstractTableModel;
import org.tn5250j.SessionConfig;
import org.tn5250j.SessionPanel;
import org.tn5250j.event.FTPStatusEvent;
import org.tn5250j.event.FTPStatusListener;
import org.tn5250j.framework.tn5250.tnvt;
import org.tn5250j.gui.GenericTn5250JFrame;
import org.tn5250j.gui.TN5250jFileChooser;
import org.tn5250j.gui.TN5250jFileFilter;
import org.tn5250j.mailtools.SendEMailDialog;
import org.tn5250j.sql.AS400Xtfr;
import org.tn5250j.sql.SqlWizard;
import org.tn5250j.tools.FTP5250Prot;
import org.tn5250j.tools.LangTool;
import org.tn5250j.tools.filters.XTFRFileFilter;

public class XTFRFile
extends GenericTn5250JFrame
implements ActionListener,
FTPStatusListener,
ItemListener {
    private static final long serialVersionUID = 1L;
    private FTP5250Prot ftpProtocol;
    private AS400Xtfr axtfr;
    private GridBagConstraints gbc;
    private JTextField user;
    private JPasswordField password;
    private JTextField systemName;
    private JTextField hostFile;
    private JTextField localFile;
    private JRadioButton allFields;
    private JRadioButton selectedFields;
    private JComboBox decimalSeparator;
    private JComboBox fileFormat;
    private JCheckBox useQuery;
    private JButton queryWizard;
    private JTextArea queryStatement;
    private JButton customize;
    private JButton xtfrButton;
    private JRadioButton intDesc;
    private JRadioButton txtDesc;
    private JPanel as400QueryP;
    private JPanel as400p;
    boolean fieldsSelected;
    boolean emailIt;
    tnvt vt;
    XTFRFileFilter htmlFilter;
    XTFRFileFilter KSpreadFilter;
    XTFRFileFilter OOFilter;
    XTFRFileFilter ExcelFilter;
    XTFRFileFilter DelimitedFilter;
    XTFRFileFilter FixedWidthFilter;
    XTFRFileFilter fileFilter;
    ProgressMonitor pm;
    JProgressBar progressBar;
    JTextArea taskOutput;
    JLabel fieldsLabel;
    JLabel textDescLabel;
    JLabel label;
    JLabel note;
    ProgressOptionPane monitor;
    JDialog dialog;
    XTFRFileFilter filter;
    SessionPanel session;
    static String messageProgress;

    public XTFRFile(Frame parent, tnvt pvt, SessionPanel session) {
        this(parent, pvt, session, null);
    }

    public XTFRFile(Frame parent, tnvt pvt, SessionPanel session, Properties XTFRProps) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.session = session;
        this.vt = pvt;
        this.ftpProtocol = new FTP5250Prot(this.vt);
        this.ftpProtocol.addFTPStatusListener(this);
        this.axtfr = new AS400Xtfr(this.vt);
        this.axtfr.addFTPStatusListener(this);
        this.createProgressMonitor();
        this.initFileFilters();
        this.initXTFRInfo(XTFRProps);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                if (XTFRFile.this.ftpProtocol != null && XTFRFile.this.ftpProtocol.isConnected()) {
                    XTFRFile.this.ftpProtocol.disconnect();
                }
            }
        });
        messageProgress = LangTool.getString("xtfr.messageProgress");
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    private void initFileFilters() {
        this.htmlFilter = new XTFRFileFilter(new String[]{"html", "htm"}, "Hyper Text Markup Language");
        this.htmlFilter.setOutputFilterName("org.tn5250j.tools.filters.HTMLOutputFilter");
        this.KSpreadFilter = new XTFRFileFilter("ksp", "KSpread KDE Spreadsheet");
        this.KSpreadFilter.setOutputFilterName("org.tn5250j.tools.filters.KSpreadOutputFilter");
        this.OOFilter = new XTFRFileFilter("sxc", "OpenOffice");
        this.OOFilter.setOutputFilterName("org.tn5250j.tools.filters.OpenOfficeOutputFilter");
        this.ExcelFilter = new XTFRFileFilter("xls", "Excel");
        this.ExcelFilter.setOutputFilterName("org.tn5250j.tools.filters.ExcelOutputFilter");
        this.DelimitedFilter = new XTFRFileFilter(new String[]{"csv", "tab"}, "Delimited");
        this.DelimitedFilter.setOutputFilterName("org.tn5250j.tools.filters.DelimitedOutputFilter");
        this.FixedWidthFilter = new XTFRFileFilter("txt", "Fixed Width");
        this.FixedWidthFilter.setOutputFilterName("org.tn5250j.tools.filters.FixedWidthOutputFilter");
    }

    @Override
    public void statusReceived(FTPStatusEvent statusevent) {
        if (this.monitor.isCanceled()) {
            this.ftpProtocol.setAborted();
        } else {
            final int prog = statusevent.getCurrentRecord();
            final int len = statusevent.getFileLength();
            Runnable udp = new Runnable(){

                @Override
                public void run() {
                    if (prog >= len) {
                        XTFRFile.this.progressBar.setValue(len);
                        XTFRFile.this.label.setText(LangTool.getString("xtfr.labelComplete"));
                        XTFRFile.this.note.setText(XTFRFile.this.getTransferredNote(len));
                        XTFRFile.this.monitor.setDone();
                        if (XTFRFile.this.emailIt) {
                            XTFRFile.this.emailMe();
                        }
                    } else {
                        XTFRFile.this.progressBar.setValue(prog);
                        XTFRFile.this.note.setText(XTFRFile.this.getProgressNote(prog, len));
                    }
                }
            };
            SwingUtilities.invokeLater(udp);
        }
    }

    private String getProgressNote(int prog, int len) {
        Object[] args = new Object[]{Integer.toString(prog), Integer.toString(len)};
        try {
            return MessageFormat.format(messageProgress, args);
        }
        catch (Exception exc) {
            System.out.println(" getProgressNote: " + exc.getMessage());
            return "Record " + prog + " of " + len;
        }
    }

    private void emailMe() {
        SendEMailDialog semd = new SendEMailDialog((Frame)this.getParent(), this.session, this.localFile.getText());
    }

    private String getTransferredNote(int len) {
        Object[] args = new Object[]{Integer.toString(len)};
        try {
            return MessageFormat.format(LangTool.getString("xtfr.messageTransferred"), args);
        }
        catch (Exception exc) {
            System.out.println(" getTransferredNote: " + exc.getMessage());
            return len + " records transferred!";
        }
    }

    @Override
    public void commandStatusReceived(FTPStatusEvent statusevent) {
        final String message = statusevent.getMessage() + '\n';
        Runnable cdp = new Runnable(){

            @Override
            public void run() {
                XTFRFile.this.taskOutput.setText(XTFRFile.this.taskOutput.getText() + message);
            }
        };
        SwingUtilities.invokeLater(cdp);
    }

    @Override
    public void fileInfoReceived(FTPStatusEvent statusevent) {
        this.hostFile.setText(this.ftpProtocol.getFullFileName(this.hostFile.getText()));
        if (this.allFields.isSelected()) {
            this.doTransfer();
        } else {
            this.selectFields();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("SAVE")) {
            this.saveXTFRInfo();
        }
        if (e.getActionCommand().equals("LOAD")) {
            this.loadXTFRInfo();
        }
        if (e.getActionCommand().equals("XTFR") || e.getActionCommand().equals("EMAIL")) {
            this.saveXTFRFields();
            this.emailIt = e.getActionCommand().equals("EMAIL");
            this.initializeMonitor();
            this.dialog.setVisible(true);
            if (this.useQuery.isSelected()) {
                this.axtfr.login(this.user.getText(), new String(this.password.getPassword()));
                this.axtfr.setDecimalChar(this.getDecimalChar());
                this.axtfr.connect(this.systemName.getText());
            } else if (this.ftpProtocol != null && this.ftpProtocol.connect(this.systemName.getText(), 21)) {
                if (this.ftpProtocol.login(this.user.getText(), new String(this.password.getPassword()))) {
                    this.ftpProtocol.setDecimalChar(this.getDecimalChar());
                    this.ftpProtocol.getFileInfo(this.hostFile.getText(), this.intDesc.isSelected());
                }
            } else {
                this.disconnect();
            }
        }
        if (e.getActionCommand().equals("BROWSEPC")) {
            this.getPCFile();
        }
        if (e.getActionCommand().equals("CUSTOMIZE")) {
            this.filter.getOutputFilterInstance().setCustomProperties();
        }
    }

    private char getDecimalChar() {
        String ds = (String)this.decimalSeparator.getSelectedItem();
        return ds.charAt(1);
    }

    private void initializeMonitor() {
        this.progressBar.setValue(0);
        this.progressBar.setMinimum(0);
        this.progressBar.setMaximum(0);
        this.label.setText(LangTool.getString("xtfr.labelInProgress"));
        this.note.setText(LangTool.getString("xtfr.labelFileInfo"));
        this.progressBar.setStringPainted(false);
        this.monitor.reset();
    }

    private void disconnect() {
        if (this.ftpProtocol != null) {
            this.ftpProtocol.disconnect();
            this.ftpProtocol = null;
        }
    }

    private void doTransfer() {
        this.progressBar.setMaximum(this.ftpProtocol.getFileSize());
        this.progressBar.setStringPainted(true);
        this.fileFilter = this.getFilterByDescription();
        if (this.useQuery.isSelected()) {
            this.axtfr.setOutputFilter(this.fileFilter.getOutputFilterInstance());
            this.axtfr.getFile(this.hostFile.getText(), this.fileFilter.setExtension(this.localFile.getText()), this.queryStatement.getText().trim(), this.intDesc.isSelected());
        } else {
            this.ftpProtocol.setOutputFilter(this.fileFilter.getOutputFilterInstance());
            this.ftpProtocol.getFile(this.hostFile.getText(), this.fileFilter.setExtension(this.localFile.getText()));
        }
    }

    private XTFRFileFilter getFilterByDescription() {
        String desc = (String)this.fileFormat.getSelectedItem();
        if (this.KSpreadFilter.getDescription().equals(desc)) {
            return this.KSpreadFilter;
        }
        if (this.OOFilter.getDescription().equals(desc)) {
            return this.OOFilter;
        }
        if (this.ExcelFilter.getDescription().equals(desc)) {
            return this.ExcelFilter;
        }
        if (this.DelimitedFilter.getDescription().equals(desc)) {
            return this.DelimitedFilter;
        }
        if (this.FixedWidthFilter.getDescription().equals(desc)) {
            return this.FixedWidthFilter;
        }
        return this.htmlFilter;
    }

    private void createProgressMonitor() {
        this.progressBar = new JProgressBar(0, 0);
        this.progressBar.setValue(0);
        this.taskOutput = new JTextArea(5, 20);
        this.taskOutput.setMargin(new Insets(5, 5, 5, 5));
        this.taskOutput.setEditable(false);
        JPanel panel = new JPanel();
        this.note = new JLabel();
        this.note.setForeground(Color.blue);
        this.label = new JLabel();
        this.label.setForeground(Color.blue);
        panel.setLayout(new BorderLayout());
        panel.add((Component)this.label, "North");
        panel.add((Component)this.note, "Center");
        panel.add((Component)this.progressBar, "South");
        JPanel contentPane = new JPanel();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)panel, "North");
        contentPane.add((Component)new JScrollPane(this.taskOutput), "Center");
        this.monitor = new ProgressOptionPane(contentPane);
        this.taskOutput.setRows(6);
        this.dialog = this.monitor.createDialog(this, LangTool.getString("xtfr.progressTitle"));
    }

    private void startWizard() {
        try {
            SqlWizard wizard = new SqlWizard(this.systemName.getText().trim(), this.user.getText(), new String(this.password.getPassword()));
            wizard.setQueryTextArea(this.queryStatement);
        }
        catch (NoClassDefFoundError ncdfe) {
            JOptionPane.showMessageDialog(this, LangTool.getString("messages.noAS400Toolbox"), "Error", 0, null);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    private void getPCFile() {
        String workingDir = System.getProperty("user.dir");
        TN5250jFileChooser pcFileChooser = new TN5250jFileChooser(workingDir);
        this.filter = this.getFilterByDescription();
        pcFileChooser.addChoosableFileFilter(this.filter);
        int ret = pcFileChooser.showSaveDialog(this);
        if (ret == 0) {
            File file = pcFileChooser.getSelectedFile();
            this.filter = null;
            this.filter = pcFileChooser.getFileFilter() instanceof XTFRFileFilter ? (XTFRFileFilter)pcFileChooser.getFileFilter() : this.htmlFilter;
            this.localFile.setText(this.filter.setExtension(file));
        }
    }

    private void initXTFRInfo(Properties XTFRProps) {
        BorderLayout borderLayout = new BorderLayout();
        Border emptyBorder = BorderFactory.createEmptyBorder(10, 10, 0, 10);
        JPanel mp = new JPanel();
        mp.setLayout(borderLayout);
        JPanel sp = new JPanel();
        sp.setLayout(new BorderLayout());
        sp.setBorder(emptyBorder);
        this.as400p = new JPanel();
        this.as400p.setBorder(BorderFactory.createTitledBorder(LangTool.getString("xtfr.labelAS400")));
        this.as400p.setLayout(new GridBagLayout());
        JLabel snpLabel = new JLabel(LangTool.getString("xtfr.labelSystemName"));
        this.systemName = new JTextField(this.vt.getHostName());
        this.systemName.setColumns(30);
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 0;
        this.gbc.gridy = 0;
        this.gbc.anchor = 17;
        this.gbc.insets = new Insets(5, 10, 5, 5);
        this.as400p.add((Component)snpLabel, this.gbc);
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 1;
        this.gbc.gridy = 0;
        this.gbc.gridwidth = 2;
        this.gbc.anchor = 17;
        this.gbc.insets = new Insets(5, 5, 5, 10);
        this.as400p.add((Component)this.systemName, this.gbc);
        JLabel hfnpLabel = new JLabel(LangTool.getString("xtfr.labelHostFile"));
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 0;
        this.gbc.gridy = 1;
        this.gbc.anchor = 17;
        this.gbc.insets = new Insets(5, 10, 5, 5);
        this.as400p.add((Component)hfnpLabel, this.gbc);
        this.hostFile = new JTextField();
        this.hostFile.setColumns(30);
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 1;
        this.gbc.gridy = 1;
        this.gbc.gridwidth = 2;
        this.gbc.anchor = 17;
        this.gbc.insets = new Insets(5, 5, 5, 10);
        this.as400p.add((Component)this.hostFile, this.gbc);
        JLabel idpLabel = new JLabel(LangTool.getString("xtfr.labelUserId"));
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 0;
        this.gbc.gridy = 2;
        this.gbc.anchor = 17;
        this.gbc.insets = new Insets(5, 10, 5, 5);
        this.as400p.add((Component)idpLabel, this.gbc);
        this.user = new JTextField();
        this.user.setColumns(15);
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 1;
        this.gbc.gridy = 2;
        this.gbc.anchor = 17;
        this.gbc.insets = new Insets(5, 5, 5, 5);
        this.as400p.add((Component)this.user, this.gbc);
        JLabel pwpLabel = new JLabel(LangTool.getString("xtfr.labelPassword"));
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 0;
        this.gbc.gridy = 3;
        this.gbc.anchor = 17;
        this.gbc.insets = new Insets(5, 10, 5, 5);
        this.as400p.add((Component)pwpLabel, this.gbc);
        this.password = new JPasswordField();
        this.password.setColumns(15);
        this.password.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                XTFRFile.this.txtONKeyPressed(evt);
            }
        });
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 1;
        this.gbc.gridy = 3;
        this.gbc.anchor = 17;
        this.gbc.insets = new Insets(5, 5, 5, 5);
        this.as400p.add((Component)this.password, this.gbc);
        this.useQuery = new JCheckBox(LangTool.getString("xtfr.labelUseQuery"));
        this.useQuery.addItemListener(this);
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 0;
        this.gbc.gridy = 4;
        this.gbc.anchor = 17;
        this.gbc.insets = new Insets(5, 10, 5, 5);
        this.as400p.add((Component)this.useQuery, this.gbc);
        this.queryWizard = new JButton(LangTool.getString("xtfr.labelQueryWizard"));
        this.queryWizard.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XTFRFile.this.startWizard();
            }
        });
        this.queryWizard.setEnabled(false);
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 1;
        this.gbc.gridy = 4;
        this.gbc.anchor = 17;
        this.gbc.fill = 2;
        this.gbc.insets = new Insets(0, 5, 0, 5);
        this.as400p.add((Component)this.queryWizard, this.gbc);
        this.fieldsLabel = new JLabel(LangTool.getString("xtfr.labelFields"));
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 0;
        this.gbc.gridy = 5;
        this.gbc.anchor = 17;
        this.gbc.insets = new Insets(5, 10, 5, 5);
        this.as400p.add((Component)this.fieldsLabel, this.gbc);
        this.allFields = new JRadioButton(LangTool.getString("xtfr.labelAllFields"));
        this.allFields.setSelected(true);
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 1;
        this.gbc.gridy = 5;
        this.gbc.anchor = 10;
        this.gbc.insets = new Insets(0, 5, 0, 5);
        this.as400p.add((Component)this.allFields, this.gbc);
        this.selectedFields = new JRadioButton(LangTool.getString("xtfr.labelSelectedFields"));
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 2;
        this.gbc.gridy = 5;
        this.gbc.anchor = 10;
        this.gbc.insets = new Insets(0, 5, 0, 10);
        this.as400p.add((Component)this.selectedFields, this.gbc);
        ButtonGroup fieldGroup = new ButtonGroup();
        fieldGroup.add(this.allFields);
        fieldGroup.add(this.selectedFields);
        this.textDescLabel = new JLabel(LangTool.getString("xtfr.labelTxtDesc"));
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 0;
        this.gbc.gridy = 6;
        this.gbc.anchor = 17;
        this.gbc.insets = new Insets(5, 10, 5, 5);
        this.as400p.add((Component)this.textDescLabel, this.gbc);
        this.txtDesc = new JRadioButton(LangTool.getString("xtfr.labelTxtDescFull"));
        this.txtDesc.setSelected(true);
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 1;
        this.gbc.gridy = 6;
        this.gbc.anchor = 10;
        this.gbc.insets = new Insets(0, 5, 5, 5);
        this.as400p.add((Component)this.txtDesc, this.gbc);
        this.intDesc = new JRadioButton(LangTool.getString("xtfr.labelTxtDescInt"));
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 2;
        this.gbc.gridy = 6;
        this.gbc.anchor = 10;
        this.gbc.insets = new Insets(0, 5, 5, 10);
        this.as400p.add((Component)this.intDesc, this.gbc);
        ButtonGroup txtDescGroup = new ButtonGroup();
        txtDescGroup.add(this.txtDesc);
        txtDescGroup.add(this.intDesc);
        JPanel pcp = new JPanel(new GridBagLayout());
        pcp.setBorder(BorderFactory.createTitledBorder(LangTool.getString("xtfr.labelpc")));
        JLabel pffLabel = new JLabel(LangTool.getString("xtfr.labelFileFormat"));
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 0;
        this.gbc.gridy = 0;
        this.gbc.anchor = 17;
        this.gbc.insets = new Insets(5, 10, 5, 5);
        pcp.add((Component)pffLabel, this.gbc);
        this.fileFormat = new JComboBox();
        this.fileFormat.setPreferredSize(new Dimension(220, 25));
        this.fileFormat.addItem(this.htmlFilter.getDescription());
        this.fileFormat.addItem(this.OOFilter.getDescription());
        this.fileFormat.addItem(this.ExcelFilter.getDescription());
        this.fileFormat.addItem(this.KSpreadFilter.getDescription());
        this.fileFormat.addItem(this.DelimitedFilter.getDescription());
        this.fileFormat.addItem(this.FixedWidthFilter.getDescription());
        this.fileFormat.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XTFRFile.this.filter = XTFRFile.this.getFilterByDescription();
                if (XTFRFile.this.filter.getOutputFilterInstance().isCustomizable()) {
                    XTFRFile.this.customize.setEnabled(true);
                } else {
                    XTFRFile.this.customize.setEnabled(false);
                }
            }
        });
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 1;
        this.gbc.gridy = 0;
        this.gbc.anchor = 17;
        this.gbc.insets = new Insets(0, 5, 0, 5);
        pcp.add((Component)this.fileFormat, this.gbc);
        this.customize = new JButton(LangTool.getString("xtfr.labelCustomize"));
        this.customize.setPreferredSize(new Dimension(110, 25));
        this.customize.setActionCommand("CUSTOMIZE");
        this.customize.addActionListener(this);
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 2;
        this.gbc.gridy = 0;
        this.gbc.anchor = 17;
        this.gbc.insets = new Insets(0, 5, 0, 10);
        pcp.add((Component)this.customize, this.gbc);
        this.fileFormat.setSelectedIndex(0);
        JLabel pcpLabel = new JLabel(LangTool.getString("xtfr.labelPCFile"));
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 0;
        this.gbc.gridy = 1;
        this.gbc.anchor = 17;
        this.gbc.insets = new Insets(5, 10, 5, 5);
        pcp.add((Component)pcpLabel, this.gbc);
        this.localFile = new JTextField();
        this.localFile.setColumns(15);
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 1;
        this.gbc.gridy = 1;
        this.gbc.anchor = 17;
        this.gbc.fill = 2;
        this.gbc.insets = new Insets(0, 5, 0, 5);
        pcp.add((Component)this.localFile, this.gbc);
        JButton browsePC = new JButton(LangTool.getString("xtfr.labelPCBrowse"));
        browsePC.setActionCommand("BROWSEPC");
        browsePC.addActionListener(this);
        browsePC.setPreferredSize(new Dimension(110, 25));
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 2;
        this.gbc.gridy = 1;
        this.gbc.anchor = 17;
        this.gbc.fill = 2;
        this.gbc.insets = new Insets(0, 5, 0, 10);
        pcp.add((Component)browsePC, this.gbc);
        this.decimalSeparator = new JComboBox();
        this.decimalSeparator.setPreferredSize(new Dimension(220, 25));
        this.decimalSeparator.addItem(LangTool.getString("xtfr.period"));
        this.decimalSeparator.addItem(LangTool.getString("xtfr.comma"));
        DecimalFormat formatter = (DecimalFormat)NumberFormat.getInstance(Locale.getDefault());
        if (formatter.getDecimalFormatSymbols().getDecimalSeparator() == '.') {
            this.decimalSeparator.setSelectedIndex(0);
        } else {
            this.decimalSeparator.setSelectedIndex(1);
        }
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 0;
        this.gbc.gridy = 2;
        this.gbc.anchor = 17;
        this.gbc.insets = new Insets(5, 10, 10, 5);
        pcp.add((Component)new JLabel(LangTool.getString("xtfr.labelDecimal")), this.gbc);
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 1;
        this.gbc.gridy = 2;
        this.gbc.anchor = 17;
        this.gbc.fill = 2;
        this.gbc.insets = new Insets(0, 5, 5, 5);
        pcp.add((Component)this.decimalSeparator, this.gbc);
        sp.add((Component)this.as400p, "North");
        sp.add((Component)pcp, "South");
        JPanel op = new JPanel(new FlowLayout(1, 10, 10));
        this.xtfrButton = new JButton(LangTool.getString("xtfr.labelXTFR"));
        this.xtfrButton.addActionListener(this);
        this.xtfrButton.setActionCommand("XTFR");
        op.add(this.xtfrButton);
        JButton emailButton = new JButton(LangTool.getString("xtfr.labelXTFREmail"));
        emailButton.addActionListener(this);
        emailButton.setActionCommand("EMAIL");
        op.add(emailButton);
        JButton saveButton = new JButton(LangTool.getString("xtfr.labelXTFRSave"));
        saveButton.addActionListener(this);
        saveButton.setActionCommand("SAVE");
        op.add(saveButton);
        JButton loadButton = new JButton(LangTool.getString("xtfr.labelXTFRLoad"));
        loadButton.addActionListener(this);
        loadButton.setActionCommand("LOAD");
        op.add(loadButton);
        mp.add((Component)sp, "Center");
        mp.add((Component)op, "South");
        this.getContentPane().add((Component)mp, "Center");
        this.setTitle(LangTool.getString("xtfr.title"));
        this.as400QueryP = new JPanel();
        this.as400QueryP.setLayout(new BorderLayout());
        this.queryStatement = new JTextArea(2, 40);
        JScrollPane scrollPane = new JScrollPane(this.queryStatement);
        this.queryStatement.setLineWrap(true);
        this.as400QueryP.add((Component)scrollPane, "Center");
        this.initXTFRFields(XTFRProps);
        this.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = this.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        this.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
        this.setVisible(true);
    }

    private void txtONKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.xtfrButton.doClick();
        }
    }

    private void initXTFRFields(Properties props) {
        if (props == null) {
            SessionConfig config = this.session.getSession().getConfiguration();
            props = config.getProperties();
        }
        if (props.containsKey("xtfr.fileName")) {
            this.hostFile.setText(props.getProperty("xtfr.fileName"));
        }
        if (props.containsKey("xtfr.user")) {
            this.user.setText(props.getProperty("xtfr.user"));
        }
        if (props.containsKey("xtfr.useQuery")) {
            if (props.getProperty("xtfr.useQuery").equals("true")) {
                this.useQuery.setSelected(true);
            } else {
                this.useQuery.setSelected(false);
            }
        }
        if (props.containsKey("xtfr.queryStatement")) {
            this.queryStatement.setText(props.getProperty("xtfr.queryStatement"));
        }
        if (props.containsKey("xtfr.allFields")) {
            if (props.getProperty("xtfr.allFields").equals("true")) {
                this.allFields.setSelected(true);
            } else {
                this.allFields.setSelected(false);
            }
        }
        if (props.containsKey("xtfr.txtDesc")) {
            if (props.getProperty("xtfr.txtDesc").equals("true")) {
                this.txtDesc.setSelected(true);
            } else {
                this.txtDesc.setSelected(false);
            }
        }
        if (props.containsKey("xtfr.intDesc")) {
            if (props.getProperty("xtfr.intDesc").equals("true")) {
                this.intDesc.setSelected(true);
            } else {
                this.intDesc.setSelected(false);
            }
        }
        if (props.containsKey("xtfr.fileFormat")) {
            this.fileFormat.setSelectedItem(props.getProperty("xtfr.fileFormat"));
        }
        if (props.containsKey("xtfr.localFile")) {
            this.localFile.setText(props.getProperty("xtfr.localFile"));
        }
        if (props.containsKey("xtfr.decimalSeparator")) {
            this.decimalSeparator.setSelectedItem(props.get("xtfr.decimalSeparator"));
        }
    }

    private void saveXTFRFields() {
        SessionConfig config = this.session.getSession().getConfiguration();
        Properties props = config.getProperties();
        this.saveXTFRFields(props);
        config.setModified();
    }

    private void saveXTFRFields(Properties props) {
        if (this.hostFile.getText().trim().length() > 0) {
            props.setProperty("xtfr.fileName", this.hostFile.getText().trim());
        } else {
            props.remove("xtfr.fileName");
        }
        if (this.user.getText().trim().length() > 0) {
            props.setProperty("xtfr.user", this.user.getText().trim());
        } else {
            props.remove("xtfr.user");
        }
        if (this.useQuery.isSelected()) {
            props.setProperty("xtfr.useQuery", "true");
        } else {
            props.remove("xtfr.useQuery");
        }
        if (this.queryStatement.getText().trim().length() > 0) {
            props.setProperty("xtfr.queryStatement", this.queryStatement.getText().trim());
        } else {
            props.remove("xtfr.queryStatement");
        }
        if (this.allFields.isSelected()) {
            props.setProperty("xtfr.allFields", "true");
        } else {
            props.remove("xtfr.allFields");
        }
        if (this.txtDesc.isSelected()) {
            props.setProperty("xtfr.txtDesc", "true");
        } else {
            props.remove("xtfr.txtDesc");
        }
        if (this.intDesc.isSelected()) {
            props.setProperty("xtfr.intDesc", "true");
        } else {
            props.remove("xtfr.intDesc");
        }
        props.setProperty("xtfr.fileFormat", (String)this.fileFormat.getSelectedItem());
        if (this.localFile.getText().trim().length() > 0) {
            props.setProperty("xtfr.localFile", this.localFile.getText().trim());
        } else {
            props.remove("xtfr.localFile");
        }
        props.setProperty("xtfr.decimalSeparator", (String)this.decimalSeparator.getSelectedItem());
    }

    private void saveXTFRInfo() {
        Properties xtfrProps = new Properties();
        xtfrProps.setProperty("xtfr.destination", "FROM");
        this.saveXTFRFields(xtfrProps);
        String workingDir = System.getProperty("user.dir");
        TN5250jFileChooser pcFileChooser = new TN5250jFileChooser(workingDir);
        TN5250jFileFilter filter = new TN5250jFileFilter("dtf", "Transfer from AS/400");
        pcFileChooser.addChoosableFileFilter(filter);
        int ret = pcFileChooser.showSaveDialog(this);
        if (ret == 0) {
            File file = pcFileChooser.getSelectedFile();
            file = new File(filter.setExtension(file));
            try {
                FileOutputStream out = new FileOutputStream(file);
                xtfrProps.store(out, "------ Transfer Details --------");
                out.flush();
                out.close();
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void loadXTFRInfo() {
        Properties xtfrProps = new Properties();
        String workingDir = System.getProperty("user.dir");
        TN5250jFileChooser pcFileChooser = new TN5250jFileChooser(workingDir);
        TN5250jFileFilter filter = new TN5250jFileFilter("dtf", "Transfer from AS/400");
        pcFileChooser.addChoosableFileFilter(filter);
        int ret = pcFileChooser.showOpenDialog(this);
        if (ret == 0) {
            File file = pcFileChooser.getSelectedFile();
            try {
                FileInputStream in = new FileInputStream(file);
                xtfrProps.load(in);
                in.close();
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (xtfrProps.containsKey("xtfr.destination") && xtfrProps.get("xtfr.destination").equals("FROM")) {
            this.initXTFRFields(xtfrProps);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        ItemSelectable source = e.getItemSelectable();
        if (source == this.useQuery) {
            if (this.useQuery.isSelected()) {
                this.queryWizard.setEnabled(true);
                this.as400p.remove(this.fieldsLabel);
                this.as400p.remove(this.allFields);
                this.as400p.remove(this.selectedFields);
                this.as400p.remove(this.textDescLabel);
                this.as400p.remove(this.txtDesc);
                this.as400p.remove(this.intDesc);
                this.gbc = new GridBagConstraints();
                this.gbc.gridx = 0;
                this.gbc.gridy = 5;
                this.gbc.gridheight = 2;
                this.gbc.gridwidth = 3;
                this.gbc.fill = 1;
                this.gbc.anchor = 17;
                this.gbc.insets = new Insets(5, 10, 10, 10);
                this.as400p.add((Component)this.as400QueryP, this.gbc);
            } else {
                this.queryWizard.setEnabled(false);
                this.as400p.remove(this.as400QueryP);
                this.gbc = new GridBagConstraints();
                this.gbc.gridx = 0;
                this.gbc.gridy = 5;
                this.gbc.anchor = 17;
                this.gbc.insets = new Insets(5, 10, 5, 5);
                this.as400p.add((Component)this.fieldsLabel, this.gbc);
                this.allFields.setSelected(true);
                this.gbc = new GridBagConstraints();
                this.gbc.gridx = 1;
                this.gbc.gridy = 5;
                this.gbc.anchor = 10;
                this.gbc.insets = new Insets(0, 5, 0, 5);
                this.as400p.add((Component)this.allFields, this.gbc);
                this.gbc = new GridBagConstraints();
                this.gbc.gridx = 2;
                this.gbc.gridy = 5;
                this.gbc.anchor = 10;
                this.gbc.insets = new Insets(0, 5, 0, 10);
                this.as400p.add((Component)this.selectedFields, this.gbc);
                this.gbc = new GridBagConstraints();
                this.gbc.gridx = 0;
                this.gbc.gridy = 6;
                this.gbc.anchor = 17;
                this.gbc.insets = new Insets(5, 10, 5, 5);
                this.as400p.add((Component)this.textDescLabel, this.gbc);
                this.txtDesc.setSelected(true);
                this.gbc = new GridBagConstraints();
                this.gbc.gridx = 1;
                this.gbc.gridy = 6;
                this.gbc.anchor = 10;
                this.gbc.insets = new Insets(0, 5, 5, 5);
                this.as400p.add((Component)this.txtDesc, this.gbc);
                this.gbc = new GridBagConstraints();
                this.gbc.gridx = 2;
                this.gbc.gridy = 6;
                this.gbc.anchor = 10;
                this.gbc.insets = new Insets(0, 5, 5, 10);
                this.as400p.add((Component)this.intDesc, this.gbc);
            }
            this.validate();
            this.repaint();
        }
    }

    private void selectFields() {
        FFDTableModel ffdtm = new FFDTableModel();
        JTable fields = new JTable(ffdtm);
        fields.setSelectionMode(0);
        fields.setPreferredScrollableViewportSize(new Dimension(500, 200));
        JScrollPane scrollPane = new JScrollPane(fields);
        scrollPane.setVerticalScrollBarPolicy(20);
        scrollPane.setHorizontalScrollBarPolicy(30);
        JPanel jpm = new JPanel();
        jpm.add(scrollPane);
        Object[] message = new Object[]{jpm};
        Object[] options = new String[]{LangTool.getString("xtfr.tableSelectAll"), LangTool.getString("xtfr.tableSelectNone"), LangTool.getString("xtfr.tableDone")};
        int result = 0;
        block4: while (result != 2) {
            result = JOptionPane.showOptionDialog(null, message, LangTool.getString("xtfr.titleFieldSelection"), -1, -1, null, options, options[1]);
            switch (result) {
                case 0: {
                    this.ftpProtocol.selectAll();
                    continue block4;
                }
                case 1: {
                    this.ftpProtocol.selectNone();
                    continue block4;
                }
            }
            this.fieldsSelected = this.ftpProtocol.isFieldsSelected();
            if (!this.ftpProtocol.isFieldsSelected()) continue;
            this.doTransfer();
        }
    }

    private class ProgressOptionPane
    extends JOptionPane {
        private static final long serialVersionUID = 1L;

        ProgressOptionPane(Object messageList) {
            super(messageList, 1, -1, null, new Object[]{UIManager.getString("OptionPane.cancelButtonText")}, null);
            this.setCursor(Cursor.getPredefinedCursor(3));
        }

        public void setDone() {
            Object[] option = this.getOptions();
            option[0] = LangTool.getString("xtfr.tableDone");
            this.setOptions(option);
            this.setCursor(Cursor.getPredefinedCursor(0));
        }

        public void reset() {
            Object[] option = this.getOptions();
            option[0] = UIManager.getString("OptionPane.cancelButtonText");
            this.setOptions(option);
            XTFRFile.this.monitor.setValue(null);
        }

        @Override
        public int getMaxCharactersPerLineCount() {
            return 60;
        }

        public boolean isCanceled() {
            if (this == null) {
                return false;
            }
            Object v = this.getValue();
            return v != null;
        }

        @Override
        public JDialog createDialog(Component parentComponent, String title) {
            Frame frame = JOptionPane.getFrameForComponent(parentComponent);
            final JDialog dialog = new JDialog(frame, title, false);
            Container contentPane = dialog.getContentPane();
            contentPane.setLayout(new BorderLayout());
            contentPane.add((Component)this, "Center");
            dialog.pack();
            dialog.setLocationRelativeTo(parentComponent);
            dialog.addWindowListener(new WindowAdapter(){
                boolean gotFocus = false;

                @Override
                public void windowClosing(WindowEvent we) {
                    ProgressOptionPane.this.setValue(null);
                }

                @Override
                public void windowActivated(WindowEvent we) {
                    if (!this.gotFocus) {
                        ProgressOptionPane.this.selectInitialValue();
                        this.gotFocus = true;
                    }
                }
            });
            this.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent event) {
                    if (dialog.isVisible() && event.getSource() == ProgressOptionPane.this && (event.getPropertyName().equals("value") || event.getPropertyName().equals("inputValue"))) {
                        if (XTFRFile.this.ftpProtocol != null) {
                            XTFRFile.this.ftpProtocol.setAborted();
                        }
                        dialog.setVisible(false);
                        dialog.dispose();
                    }
                }
            });
            return dialog;
        }
    }

    class FFDTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        final String[] cols = new String[]{LangTool.getString("xtfr.tableColA"), LangTool.getString("xtfr.tableColB")};

        @Override
        public int getColumnCount() {
            return this.cols.length;
        }

        @Override
        public String getColumnName(int col) {
            return this.cols[col];
        }

        @Override
        public int getRowCount() {
            return XTFRFile.this.ftpProtocol.getNumberOfFields();
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (col == 0) {
                return new Boolean(XTFRFile.this.ftpProtocol.isFieldSelected(row));
            }
            if (col == 1) {
                return XTFRFile.this.ftpProtocol.getFieldName(row);
            }
            return null;
        }

        @Override
        public Class<?> getColumnClass(int col) {
            return this.getValueAt(0, col).getClass();
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col == 0;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            this.fireTableCellUpdated(row, col);
            XTFRFile.this.ftpProtocol.setFieldSelected(row, (Boolean)value);
        }
    }
}

