/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j.tools.encoder;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.io.IOException;
import java.io.OutputStream;
import org.tn5250j.tools.encoder.Encoder;
import org.tn5250j.tools.encoder.EncoderException;

public abstract class AbstractImageEncoder
implements Encoder {
    protected Image img = null;
    protected OutputStream ofile = null;

    public void encode(Image image, OutputStream os) throws IOException, EncoderException {
        this.img = image;
        this.ofile = os;
        this.saveImage();
    }

    @Override
    public void encode(Component component, OutputStream os) throws IOException, EncoderException {
        this.encode(AbstractImageEncoder.snapshot(component), os);
    }

    public static Image snapshot(Component component) {
        Image img = component.createImage(component.getSize().width, component.getSize().height);
        if (img != null) {
            Graphics igc = img.getGraphics();
            igc.setClip(0, 0, component.getSize().width, component.getSize().height);
            component.paint(igc);
        }
        return img;
    }

    public abstract void saveImage() throws IOException, EncoderException;

    public byte createByte(int b7, int b6, int b5, int b4, int b3, int b2, int b1, int b0) {
        byte bits = 0;
        if (b0 == 1) {
            bits = (byte)(bits | 1);
        }
        if (b1 == 1) {
            bits = (byte)(bits | 2);
        }
        if (b2 == 1) {
            bits = (byte)(bits | 4);
        }
        if (b3 == 1) {
            bits = (byte)(bits | 8);
        }
        if (b4 == 1) {
            bits = (byte)(bits | 0x10);
        }
        if (b5 == 1) {
            bits = (byte)(bits | 0x20);
        }
        if (b6 == 1) {
            bits = (byte)(bits | 0x40);
        }
        if (b7 == 1) {
            bits = (byte)(bits | 0x80);
        }
        return bits;
    }

    public static byte byteFromInt(int value) {
        return (byte)(value & 0xFF);
    }

    public static byte[] bytesFromLong(long value) {
        byte[] buf = new byte[]{(byte)(value >> 24 & 0xFFL), (byte)(value >> 16 & 0xFFL), (byte)(value >> 8 & 0xFFL), (byte)(value & 0xFFL)};
        return buf;
    }

    public static byte byteFromChar(char ochar) {
        char temp = ochar;
        byte bits = 0;
        boolean curpos = false;
        for (int i = 0; i <= 7; ++i) {
            if ((temp & (byte)Math.pow(2.0, i)) == 0) continue;
            bits = (byte)(bits | (byte)Math.pow(2.0, i));
        }
        return bits;
    }

    public byte compressColor(int clr) {
        return this.compressColor(clr >> 16 & 0xFF, clr >> 8 & 0xFF, clr & 0xFF);
    }

    public byte compressColor(int red, int green, int blue) {
        return (byte)(red & 0xE0 | green >> 3 & 0x1C | blue >> 6 & 3);
    }

    protected void error(String msg) throws EncoderException {
        throw new EncoderException(msg);
    }
}

