/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j.tools.encoder;

import java.awt.image.ColorModel;
import java.awt.image.PixelGrabber;
import java.io.IOException;
import java.util.zip.Deflater;
import org.tn5250j.tools.encoder.AbstractImageEncoder;
import org.tn5250j.tools.encoder.EncoderException;

public class PNGEncoder
extends AbstractImageEncoder {
    private long[] crc_table = null;

    @Override
    public void saveImage() throws IOException, EncoderException {
        if (this.img == null) {
            this.error("PNG encoding error: Image is NULL.");
        }
        PixelGrabber pg = new PixelGrabber(this.img, 0, 0, this.img.getWidth(null), this.img.getHeight(null), false);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException e) {
            this.error("PNG encoding error: Unable to retrieve pixels from image.");
        }
        ColorModel cmodel = pg.getColorModel();
        int pixels = cmodel.getPixelSize();
        int numcolors = (int)Math.pow(2.0, pixels);
        if (pixels != 8 && pixels != 16 && pixels != 24 && pixels != 32) {
            this.error("PNG encoding error: PNG method must have 8 or 16 bit colors.");
        }
        int[] pixelarray = null;
        byte[] pixelarray8 = null;
        if (pixels >= 16) {
            pixelarray = (int[])pg.getPixels();
        } else {
            pixelarray8 = (byte[])pg.getPixels();
        }
        this.ofile.write(PNGEncoder.byteFromInt(137));
        this.ofile.write(PNGEncoder.byteFromInt(80));
        this.ofile.write(PNGEncoder.byteFromInt(78));
        this.ofile.write(PNGEncoder.byteFromInt(71));
        this.ofile.write(PNGEncoder.byteFromInt(13));
        this.ofile.write(PNGEncoder.byteFromInt(10));
        this.ofile.write(PNGEncoder.byteFromInt(26));
        this.ofile.write(PNGEncoder.byteFromInt(10));
        long crc = PNGEncoder.start_crc();
        this.ofile.write(PNGEncoder.bytesFromLong(13L));
        this.ofile.write(PNGEncoder.byteFromChar('I'));
        this.ofile.write(PNGEncoder.byteFromChar('H'));
        this.ofile.write(PNGEncoder.byteFromChar('D'));
        this.ofile.write(PNGEncoder.byteFromChar('R'));
        crc = this.update_crc(crc, PNGEncoder.byteFromChar('I'));
        crc = this.update_crc(crc, PNGEncoder.byteFromChar('H'));
        crc = this.update_crc(crc, PNGEncoder.byteFromChar('D'));
        crc = this.update_crc(crc, PNGEncoder.byteFromChar('R'));
        int width = this.img.getWidth(null);
        int height = this.img.getHeight(null);
        crc = this.update_crc(crc, PNGEncoder.bytesFromLong(width));
        crc = this.update_crc(crc, PNGEncoder.bytesFromLong(height));
        crc = this.update_crc(crc, PNGEncoder.byteFromInt(8));
        crc = pixels >= 16 ? this.update_crc(crc, PNGEncoder.byteFromInt(2)) : this.update_crc(crc, PNGEncoder.byteFromInt(3));
        crc = this.update_crc(crc, PNGEncoder.byteFromInt(0));
        crc = this.update_crc(crc, PNGEncoder.byteFromInt(0));
        crc = this.update_crc(crc, PNGEncoder.byteFromInt(0));
        this.ofile.write(PNGEncoder.bytesFromLong(width));
        this.ofile.write(PNGEncoder.bytesFromLong(height));
        this.ofile.write(PNGEncoder.byteFromInt(8));
        if (pixels >= 16) {
            this.ofile.write(PNGEncoder.byteFromInt(2));
        } else {
            this.ofile.write(PNGEncoder.byteFromInt(3));
        }
        this.ofile.write(PNGEncoder.byteFromInt(0));
        this.ofile.write(PNGEncoder.byteFromInt(0));
        this.ofile.write(PNGEncoder.byteFromInt(0));
        this.ofile.write(PNGEncoder.bytesFromLong(PNGEncoder.end_crc(crc)));
        if (pixels == 8) {
            crc = PNGEncoder.start_crc();
            this.ofile.write(PNGEncoder.bytesFromLong(numcolors * 3));
            this.ofile.write(PNGEncoder.byteFromChar('P'));
            this.ofile.write(PNGEncoder.byteFromChar('L'));
            this.ofile.write(PNGEncoder.byteFromChar('T'));
            this.ofile.write(PNGEncoder.byteFromChar('E'));
            crc = this.update_crc(crc, PNGEncoder.byteFromChar('P'));
            crc = this.update_crc(crc, PNGEncoder.byteFromChar('L'));
            crc = this.update_crc(crc, PNGEncoder.byteFromChar('T'));
            crc = this.update_crc(crc, PNGEncoder.byteFromChar('E'));
            for (int i = 0; i < numcolors; ++i) {
                byte red = PNGEncoder.byteFromInt(cmodel.getRed(i));
                byte green = PNGEncoder.byteFromInt(cmodel.getGreen(i));
                byte blue = PNGEncoder.byteFromInt(cmodel.getBlue(i));
                crc = this.update_crc(crc, red);
                crc = this.update_crc(crc, green);
                crc = this.update_crc(crc, blue);
                this.ofile.write(red);
                this.ofile.write(green);
                this.ofile.write(blue);
            }
            this.ofile.write(PNGEncoder.bytesFromLong(PNGEncoder.end_crc(crc)));
        }
        byte[] outarray = null;
        outarray = pixels == 8 ? new byte[pixelarray8.length + height] : new byte[pixelarray.length * 3 + height];
        for (int i = 0; i < outarray.length; ++i) {
            outarray[i] = 0;
        }
        int size = 0;
        size = pixels >= 16 ? this.compress(outarray, pixelarray, cmodel, width, height) : this.compress(outarray, pixelarray8, width, height);
        crc = PNGEncoder.start_crc();
        this.ofile.write(PNGEncoder.bytesFromLong(size));
        this.ofile.write(PNGEncoder.byteFromChar('I'));
        this.ofile.write(PNGEncoder.byteFromChar('D'));
        this.ofile.write(PNGEncoder.byteFromChar('A'));
        this.ofile.write(PNGEncoder.byteFromChar('T'));
        crc = this.update_crc(crc, PNGEncoder.byteFromChar('I'));
        crc = this.update_crc(crc, PNGEncoder.byteFromChar('D'));
        crc = this.update_crc(crc, PNGEncoder.byteFromChar('A'));
        crc = this.update_crc(crc, PNGEncoder.byteFromChar('T'));
        this.ofile.write(outarray, 0, size);
        for (int i = 0; i < size; ++i) {
            crc = this.update_crc(crc, outarray[i]);
        }
        this.ofile.write(PNGEncoder.bytesFromLong(PNGEncoder.end_crc(crc)));
        crc = PNGEncoder.start_crc();
        this.ofile.write(PNGEncoder.bytesFromLong(0L));
        this.ofile.write(PNGEncoder.byteFromChar('I'));
        this.ofile.write(PNGEncoder.byteFromChar('E'));
        this.ofile.write(PNGEncoder.byteFromChar('N'));
        this.ofile.write(PNGEncoder.byteFromChar('D'));
        crc = this.update_crc(crc, PNGEncoder.byteFromChar('I'));
        crc = this.update_crc(crc, PNGEncoder.byteFromChar('E'));
        crc = this.update_crc(crc, PNGEncoder.byteFromChar('N'));
        crc = this.update_crc(crc, PNGEncoder.byteFromChar('D'));
        this.ofile.write(PNGEncoder.bytesFromLong(PNGEncoder.end_crc(crc)));
    }

    public int compress(byte[] outarray, int[] pixelarray, ColorModel cmodel, int width, int height) throws EncoderException {
        byte[] inarray = new byte[pixelarray.length * 3 + height];
        for (int i = 0; i < height; ++i) {
            inarray[i * (width * 3 + 1)] = PNGEncoder.byteFromInt(0);
            for (int j = 0; j < width * 3; j += 3) {
                inarray[i * (width * 3 + 1) + j + 1] = (byte)cmodel.getRed(pixelarray[i * width + (int)Math.floor(j / 3)]);
                inarray[i * (width * 3 + 1) + j + 2] = (byte)cmodel.getGreen(pixelarray[i * width + (int)Math.floor(j / 3)]);
                inarray[i * (width * 3 + 1) + j + 3] = (byte)cmodel.getBlue(pixelarray[i * width + (int)Math.floor(j / 3)]);
            }
        }
        return this.compressInternal(outarray, inarray);
    }

    public int compress(byte[] outarray, byte[] pixelarray, int width, int height) throws EncoderException {
        byte[] inarray = new byte[pixelarray.length + height];
        for (int i = 0; i < height; ++i) {
            inarray[i * (width + 1)] = PNGEncoder.byteFromInt(0);
            for (int j = 0; j < width; ++j) {
                inarray[i * (width + 1) + j + 1] = pixelarray[i * width + j];
            }
        }
        return this.compressInternal(outarray, inarray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int compressInternal(byte[] outarray, byte[] inarray) throws EncoderException {
        Deflater deflater = new Deflater(-1);
        try {
            deflater.setInput(inarray, 0, inarray.length);
            deflater.finish();
            deflater.deflate(outarray);
            if (!deflater.finished()) {
                this.error("PNG encoding error: Deflater could not compress image data.");
            }
            int n = deflater.getTotalOut();
            return n;
        }
        finally {
            deflater.end();
        }
    }

    private void make_crc_table() {
        this.crc_table = new long[256];
        for (int n = 0; n < 256; ++n) {
            long c = n;
            for (int k = 0; k < 8; ++k) {
                if ((c & 1L) != 0L) {
                    c = 0xEDB88320L ^ c >> 1;
                    continue;
                }
                c >>= 1;
            }
            this.crc_table[n] = c;
        }
    }

    private static final long start_crc() {
        return 0xFFFFFFFFL;
    }

    private static final long end_crc(long crc) {
        return crc ^ 0xFFFFFFFFL;
    }

    private long update_crc(long crc, byte[] buf) {
        long c = crc;
        for (int i = 0; i < buf.length; ++i) {
            c = this.update_crc(c, buf[i]);
        }
        return c;
    }

    private long update_crc(long crc, byte buf) {
        if (this.crc_table == null) {
            this.make_crc_table();
        }
        return this.crc_table[(int)((crc ^ (long)buf) & 0xFFL)] ^ crc >> 8;
    }
}

