/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j.tools.filters;

import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Vector;
import org.tn5250j.tools.filters.FileFieldDef;
import org.tn5250j.tools.filters.OutputFilterInterface;

public class ExcelOutputFilter
implements OutputFilterInterface {
    DataOutputStream fout = null;
    int row = 0;
    StringBuffer sb;
    Vector formats;

    @Override
    public void createFileInstance(String fileName) throws FileNotFoundException {
        try {
            this.fout = new DataOutputStream(new FileOutputStream(fileName));
        }
        catch (Exception e) {
            System.out.println("create file " + e.getMessage());
        }
        this.row = 0;
        this.sb = new StringBuffer();
        this.formats = null;
    }

    @Override
    public void parseFields(byte[] cByte, ArrayList ffd, StringBuffer rb) {
        int col = 0;
        ++this.row;
        boolean fmt = false;
        block3: for (int x = 0; x < ffd.size(); ++x) {
            FileFieldDef f = (FileFieldDef)ffd.get(x);
            if (!f.isWriteField()) continue;
            switch (f.getFieldType()) {
                case 'P': 
                case 'S': {
                    this.writeDouble(f.parseData(cByte), col++, f.getPrecision());
                    continue block3;
                }
                default: {
                    this.writeLabel(f.parseData(cByte), col++);
                }
            }
        }
    }

    private void writeLabel(String label, int col) {
        int wLen = label.length();
        try {
            this.writeShort(4);
            this.writeShort(8 + wLen);
            this.writeShort(this.row);
            this.writeShort(col);
            this.fout.write(0);
            this.fout.write(0);
            this.fout.write(0);
            this.fout.writeByte(wLen);
            this.fout.writeBytes(label);
        }
        catch (IOException ioe) {
            System.out.println("write label: " + ioe.getMessage());
        }
    }

    private void writeDouble(String string, int col, int fmtCode) {
        try {
            this.writeShort(3);
            this.writeShort(15);
            this.writeShort(this.row);
            this.writeShort(col);
            this.fout.writeByte(0);
            this.fout.writeByte(fmtCode);
            this.fout.writeByte(this.formats.indexOf(Integer.toString(fmtCode)));
            double d = Double.parseDouble(string);
            this.writeLong(Double.doubleToLongBits(d));
        }
        catch (IOException ioe) {
            System.out.println("write double: " + ioe.getMessage());
        }
    }

    private void writeFormat(int len, int decPos, int fmtCode) {
        if (this.formats == null) {
            this.formats = new Vector();
        }
        this.sb.setLength(0);
        if (decPos > 0) {
            for (int x = decPos; x > 0; --x) {
                this.sb.insert(0, '0');
            }
            this.sb.insert(0, "#0.");
        } else {
            this.sb.append("#0");
        }
        int fLen = this.sb.length();
        if (!this.formats.contains(Integer.toString(decPos))) {
            this.formats.add(Integer.toString(decPos));
            try {
                this.writeShort(30);
                this.writeShort(1 + fLen);
                this.fout.writeByte(fLen);
                this.fout.writeBytes(this.sb.toString());
            }
            catch (IOException ioe) {
                System.out.println("write label: " + ioe.getMessage());
            }
        }
    }

    public void writeLong(long l) throws IOException {
        this.fout.write((int)l & 0xFF);
        this.fout.write((int)(l >>> 8) & 0xFF);
        this.fout.write((int)(l >>> 16) & 0xFF);
        this.fout.write((int)(l >>> 24) & 0xFF);
        this.fout.write((int)(l >>> 32) & 0xFF);
        this.fout.write((int)(l >>> 40) & 0xFF);
        this.fout.write((int)(l >>> 48) & 0xFF);
        this.fout.write((int)(l >>> 56) & 0xFF);
    }

    public void writeShort(int s) throws IOException {
        this.fout.write(s & 0xFF);
        this.fout.write(s >>> 8 & 0xFF);
    }

    @Override
    public void writeHeader(String fileName, String host, ArrayList ffd, char decChar) {
        byte[] bof = new byte[]{9, 8, 6, 0, 0, 0, 16, 0, 0, 0};
        byte[] dimension = new byte[]{0, 2, 10, 0, 0, 0, 100, 0, 0, 0, 100, 0, 0, 0};
        try {
            FileFieldDef f;
            int x;
            this.fout.write(bof);
            this.fout.write(dimension);
            int c = 0;
            block5: for (x = 0; x < ffd.size(); ++x) {
                f = (FileFieldDef)ffd.get(x);
                if (!f.isWriteField()) continue;
                switch (f.getFieldType()) {
                    case 'P': 
                    case 'S': {
                        this.writeFormat(f.getFieldLength(), f.getPrecision(), ++c);
                        continue block5;
                    }
                }
            }
            c = 0;
            for (x = 0; x < ffd.size(); ++x) {
                f = (FileFieldDef)ffd.get(x);
                if (!f.isWriteField()) continue;
                this.writeLabel(f.getFieldName(), c++);
            }
        }
        catch (IOException ioe) {
            System.out.println("header " + ioe.getMessage());
        }
    }

    @Override
    public void writeFooter(ArrayList ffd) {
        try {
            this.fout.write(10);
            this.fout.write(0);
            this.fout.write(0);
            this.fout.write(0);
            this.fout.flush();
            this.fout.close();
        }
        catch (IOException ioex) {
            System.out.println("write footer: " + ioex.getMessage());
        }
    }

    @Override
    public boolean isCustomizable() {
        return false;
    }

    @Override
    public void setCustomProperties() {
    }
}

