/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j.tools.filters;

import org.tn5250j.framework.tn5250.tnvt;

public class FileFieldDef {
    private int startOffset;
    private int bufferLength;
    private int length;
    private int numDigits;
    private int decPos;
    private char type;
    private String txtDesc;
    private String fieldName;
    private String data;
    private boolean writeField;
    private char decChar;
    private boolean translateIt;
    private tnvt vt;
    private StringBuffer sbdata;

    public FileFieldDef(tnvt v, char dec) {
        this.decChar = dec;
        this.vt = v;
        this.translateIt = true;
    }

    public String parseData(byte[] cByte) {
        if (!this.translateIt) {
            return this.sbdata.toString();
        }
        StringBuffer sb = new StringBuffer(this.bufferLength);
        int end = this.startOffset + this.length - 1;
        switch (this.type) {
            case 'P': {
                for (int f = this.startOffset - 1; f < end - 1; ++f) {
                    byte bzd = cByte[f];
                    int byteZ = bzd >> 4 & 0xF;
                    int byteD = bzd & 0xF;
                    sb.append(byteZ);
                    sb.append(byteD);
                }
                byte bzd = cByte[end - 1];
                int byteZ = bzd >> 4 & 0xF;
                int byteD = bzd & 0xF;
                sb.append(byteZ);
                if ((byteD | 0xD) == 13) {
                    sb.insert(0, '-');
                    break;
                }
                sb.insert(0, '+');
                break;
            }
            case 'S': {
                for (int f = this.startOffset - 1; f < end; ++f) {
                    sb.append(cByte[f] & 0xF);
                }
                if ((cByte[end - 1] & 0xF0) == 208) {
                    sb.insert(0, '-');
                    break;
                }
                sb.insert(0, '+');
                break;
            }
            default: {
                for (int f = this.startOffset - 1; f < end; ++f) {
                    sb.append(this.vt.getCodePage().ebcdic2uni(cByte[f] & 0xFF));
                }
            }
        }
        if (this.decPos > 0) {
            int o = sb.length();
            sb.insert(o - this.decPos, this.decChar);
        }
        this.data = sb.toString();
        return this.data;
    }

    public void setFieldData(String fd) {
        if (this.sbdata == null) {
            this.sbdata = new StringBuffer(this.length);
        }
        this.sbdata.setLength(0);
        this.sbdata.append(fd);
    }

    public String toString() {
        return this.fieldName + " " + this.startOffset + " " + this.length + " " + this.getBufferOutLength() + " " + this.numDigits + " " + this.decPos + " " + this.type + " " + this.txtDesc;
    }

    public char getFieldType() {
        return this.type;
    }

    public int getPrecision() {
        return this.decPos;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String name) {
        this.fieldName = name;
    }

    public void setStartOffset(String pos) {
        this.startOffset = Integer.parseInt(pos);
    }

    public int getBufferOutLength() {
        return this.bufferLength;
    }

    public int getFieldLength() {
        return this.length;
    }

    public void setFieldLength(String len) {
        this.length = Integer.parseInt(len);
    }

    public void setNumDigits(String num) {
        this.numDigits = Integer.parseInt(num);
    }

    public void setDecPositions(String dec) {
        this.decPos = Integer.parseInt(dec);
    }

    public void setFieldType(String fType) {
        this.type = fType.charAt(0);
        this.bufferLength = this.type == 'P' ? this.length * 2 - 1 : this.length;
    }

    public void setFieldText(String text) {
        this.txtDesc = text;
    }

    public void setNeedsTranslation(boolean translate) {
        this.translateIt = translate;
    }

    public boolean isWriteField() {
        return this.writeField;
    }

    public void setWriteField(boolean value) {
        this.writeField = value;
    }
}

