/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j.tools.filters;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import org.tn5250j.tools.filters.FileFieldDef;
import org.tn5250j.tools.filters.OutputFilterInterface;

public class HTMLOutputFilter
implements OutputFilterInterface {
    PrintStream fout = null;

    @Override
    public void createFileInstance(String fileName) throws FileNotFoundException {
        this.fout = new PrintStream(new FileOutputStream(fileName));
    }

    @Override
    public void parseFields(byte[] cByte, ArrayList ffd, StringBuffer rb) {
        rb.append("<TR>");
        rb.append('\n');
        for (int x = 0; x < ffd.size(); ++x) {
            FileFieldDef f = (FileFieldDef)ffd.get(x);
            if (!f.isWriteField()) continue;
            rb.append("<TD>");
            rb.append(f.parseData(cByte));
            rb.append("</TD>");
            rb.append('\n');
        }
        rb.append("</TR>");
        rb.append('\n');
        this.fout.println(rb);
    }

    @Override
    public void writeHeader(String fileName, String host, ArrayList ffd, char decChar) {
        try {
            this.fout.write("<HTML>".getBytes());
            this.fout.write("\n".getBytes());
            this.fout.write("<HEAD>".getBytes());
            this.fout.write(10);
            String out = "<TITLE>" + host + " - " + fileName + "</TITLE>";
            this.fout.write(out.getBytes());
            this.fout.write(10);
            this.fout.write("   <META http-equiv=".getBytes());
            this.fout.write(34);
            this.fout.write("GENERATOR".getBytes());
            this.fout.write(34);
            this.fout.write(" content".getBytes());
            this.fout.write(34);
            this.fout.write("tn5250j Data Transfer".getBytes());
            this.fout.write(34);
            this.fout.write(">".getBytes());
            this.fout.write(10);
            this.fout.write("   <META http-equiv=".getBytes());
            this.fout.write(34);
            this.fout.write("Content-Type".getBytes());
            this.fout.write(34);
            this.fout.write(" content=".getBytes());
            this.fout.write(34);
            this.fout.write("text/html;charset=windows-1252".getBytes());
            this.fout.write(34);
            this.fout.write(">".getBytes());
            this.fout.write(10);
            this.fout.write("</HEAD>".getBytes());
            this.fout.write(10);
            this.fout.write("<BODY>".getBytes());
            this.fout.write(10);
            this.fout.write("<TABLE BORDER>".getBytes());
            this.fout.write(10);
            this.fout.write("<TR ALIGN=center>".getBytes());
            this.fout.write(10);
            for (int x = 0; x < ffd.size(); ++x) {
                FileFieldDef f = (FileFieldDef)ffd.get(x);
                if (!f.isWriteField()) continue;
                out = "<TH>" + f.getFieldName() + "</TH>";
                this.fout.write(out.getBytes());
                this.fout.write(10);
            }
            this.fout.write("</TR>".getBytes());
            this.fout.write(10);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void writeFooter(ArrayList ffd) {
        try {
            this.fout.write("</TABLE>".getBytes());
            this.fout.write(10);
            this.fout.write("</BODY>".getBytes());
            this.fout.write(10);
            this.fout.write("</HTML>".getBytes());
            this.fout.write(10);
            this.fout.flush();
            this.fout.close();
        }
        catch (IOException ioex) {
            System.out.println(ioex.getMessage());
        }
    }

    @Override
    public boolean isCustomizable() {
        return false;
    }

    @Override
    public void setCustomProperties() {
    }
}

