/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j.tools.filters;

import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.filechooser.FileFilter;
import org.tn5250j.tools.filters.OutputFilterInterface;

public class XTFRFileFilter
extends FileFilter {
    private static String TYPE_UNKNOWN = "Type Unknown";
    private static String HIDDEN_FILE = "Hidden File";
    private Hashtable filters = new Hashtable();
    private String description = null;
    private String fullDescription = null;
    private boolean useExtensionsInDescription = true;
    private String outputFilterClassName;
    private Object o;

    public XTFRFileFilter() {
    }

    public XTFRFileFilter(String extension) {
        this(extension, null);
    }

    public XTFRFileFilter(String extension, String description) {
        this();
        if (extension != null) {
            this.addExtension(extension);
        }
        if (description != null) {
            this.setDescription(description);
        }
    }

    public XTFRFileFilter(String[] filters) {
        this(filters, null);
    }

    public XTFRFileFilter(String[] filters, String description) {
        this();
        for (int i = 0; i < filters.length; ++i) {
            this.addExtension(filters[i]);
        }
        if (description != null) {
            this.setDescription(description);
        }
    }

    @Override
    public boolean accept(File f) {
        if (f != null) {
            if (f.isDirectory()) {
                return true;
            }
            String extension = this.getExtension(f);
            if (extension != null && this.filters.get(this.getExtension(f)) != null) {
                return true;
            }
        }
        return false;
    }

    public String getExtension(File f) {
        if (f != null) {
            return this.getExtension(f.getName());
        }
        return null;
    }

    public String getExtension(String filename) {
        int i;
        if (filename != null && (i = filename.lastIndexOf(46)) > 0 && i < filename.length() - 1) {
            return filename.substring(i + 1).toLowerCase();
        }
        return null;
    }

    public void addExtension(String extension) {
        if (this.filters == null) {
            this.filters = new Hashtable(5);
        }
        this.filters.put(extension.toLowerCase(), this);
        this.fullDescription = null;
    }

    @Override
    public String getDescription() {
        if (this.fullDescription == null) {
            if (this.description == null || this.isExtensionListInDescription()) {
                this.fullDescription = this.description == null ? "(" : this.description + " (";
                Enumeration extensions = this.filters.keys();
                if (extensions != null) {
                    this.fullDescription = this.fullDescription + "." + (String)extensions.nextElement();
                    while (extensions.hasMoreElements()) {
                        this.fullDescription = this.fullDescription + ", ." + (String)extensions.nextElement();
                    }
                }
                this.fullDescription = this.fullDescription + ")";
            } else {
                this.fullDescription = this.description;
            }
        }
        return this.fullDescription;
    }

    public void setDescription(String description) {
        this.description = description;
        this.fullDescription = null;
    }

    public void setExtensionListInDescription(boolean b) {
        this.useExtensionsInDescription = b;
        this.fullDescription = null;
    }

    public boolean isExtensionListInDescription() {
        return this.useExtensionsInDescription;
    }

    public String setExtension(File f) {
        return this.setExtension(f.getAbsolutePath());
    }

    public String setExtension(String f) {
        if (f != null & this.getExtension(f) == null) {
            Enumeration e = this.filters.keys();
            String ext = (String)e.nextElement();
            if (ext.equals("htm")) {
                ext = "html";
            }
            f = f + "." + ext.toLowerCase();
        }
        return f;
    }

    public boolean isExtensionInList(String filename) {
        String ext = null;
        if (filename == null) {
            return false;
        }
        int i = filename.lastIndexOf(46);
        if (i > 0 && i < filename.length() - 1) {
            ext = filename.substring(i + 1).toLowerCase();
        }
        if (ext == null) {
            return false;
        }
        return this.filters.containsKey(ext);
    }

    public void setOutputFilterName(String className) {
        this.outputFilterClassName = className;
    }

    public OutputFilterInterface getOutputFilterInstance() {
        try {
            if (this.o == null) {
                Class<?> c = Class.forName(this.outputFilterClassName);
                this.o = c.newInstance();
            }
        }
        catch (Exception e) {
            System.err.println(e);
        }
        return (OutputFilterInterface)this.o;
    }
}

