/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j.tools.logging;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.tn5250j.interfaces.ConfigureFactory;
import org.tn5250j.tools.logging.ConsoleLogger;
import org.tn5250j.tools.logging.Log4jLogger;
import org.tn5250j.tools.logging.TN5250jLogger;

public final class TN5250jLogFactory {
    private static Map<String, TN5250jLogger> _loggers = new HashMap<String, TN5250jLogger>();
    private static boolean log4j;
    private static String customLogger;
    private static int level;

    TN5250jLogFactory() {
    }

    public static TN5250jLogger getLogger(Class<?> clazz) {
        return TN5250jLogFactory.getLogger(clazz.getName());
    }

    public static TN5250jLogger getLogger(String clazzName) {
        TN5250jLogger logger = null;
        if (_loggers.containsKey(clazzName)) {
            logger = _loggers.get(clazzName);
        } else if (customLogger != null) {
            try {
                Class<?> classObject = Class.forName(customLogger);
                Object object = classObject.newInstance();
                if (object instanceof TN5250jLogger) {
                    logger = (TN5250jLogger)object;
                }
            }
            catch (Exception exception) {}
        } else {
            logger = log4j ? new Log4jLogger() : new ConsoleLogger();
            logger.initialize(clazzName);
            logger.setLevel(level);
            _loggers.put(clazzName, logger);
        }
        return logger;
    }

    public static boolean isLog4j() {
        return log4j;
    }

    public static void setLogLevels(int newLevel) {
        if (level != newLevel) {
            level = newLevel;
            TN5250jLogger logger = null;
            Set<String> loggerSet = _loggers.keySet();
            Iterator<String> loggerIterator = loggerSet.iterator();
            while (loggerIterator.hasNext()) {
                logger = _loggers.get(loggerIterator.next());
                logger.setLevel(newLevel);
            }
        }
    }

    static {
        level = 2;
        try {
            Properties props = ConfigureFactory.getInstance().getProperties("sessions");
            level = Integer.parseInt(props.getProperty("emul.logLevel", Integer.toString(2)));
            String customLogger = System.getProperty(TN5250jLogFactory.class.getName());
            if (customLogger == null) {
                try {
                    Class.forName("org.apache.log4j.Logger");
                    log4j = true;
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

