/*
 * Decompiled with CFR 0.152.
 */
package com.github.veithen.alta;

import com.github.veithen.alta.Bundle;
import com.github.veithen.alta.Context;
import com.github.veithen.alta.template.EvaluationException;
import com.github.veithen.alta.template.InvalidTemplateException;
import com.github.veithen.alta.template.PropertyGroup;
import com.github.veithen.alta.template.Template;
import com.github.veithen.alta.template.TemplateCompiler;
import com.github.veithen.maven.shared.artifactset.ArtifactSet;
import com.github.veithen.maven.shared.artifactset.ArtifactSetResolver;
import com.github.veithen.maven.shared.artifactset.ArtifactSetResolverException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.List;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Repository;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

public abstract class AbstractProcessMojo
extends AbstractMojo {
    private static final TemplateCompiler<Context> templateCompiler = new TemplateCompiler();
    @Parameter(required=true)
    private ArtifactSet artifactSet;
    @Parameter
    private Repository[] repositories;
    @Parameter(property="project", readonly=true, required=true)
    protected MavenProject project;
    @Parameter(property="session", readonly=true, required=true)
    private MavenSession session;
    @Parameter(defaultValue="false")
    private boolean skip;
    @Component
    private ArtifactSetResolver artifactSetResolver;

    public final void execute() throws MojoExecutionException, MojoFailureException {
        List artifacts;
        Log log = this.getLog();
        if (this.skip) {
            log.info((CharSequence)"Skipping plugin execution");
        }
        try {
            artifacts = this.artifactSetResolver.resolveArtifactSet(this.project, this.session, this.artifactSet, this.repositories);
        }
        catch (ArtifactSetResolverException ex) {
            throw new MojoExecutionException("Failed to resolve artifact set", (Exception)((Object)ex));
        }
        this.process(artifacts);
    }

    protected abstract void process(List<Artifact> var1) throws MojoExecutionException, MojoFailureException;

    static File getArtifactFile(Artifact artifact) throws EvaluationException {
        File file = artifact.getFile();
        if (file.isFile()) {
            return file;
        }
        throw new EvaluationException("Artifact has not been packaged yet; it is part of the reactor, but the package phase has not been executed.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Bundle extractBundleMetadata(Artifact artifact) throws EvaluationException {
        File file = AbstractProcessMojo.getArtifactFile(artifact);
        try {
            String symbolicName;
            Manifest manifest = null;
            try (FileInputStream in = new FileInputStream(file);){
                ZipEntry entry;
                ZipInputStream zip = new ZipInputStream(in);
                while ((entry = zip.getNextEntry()) != null) {
                    if (!entry.getName().equals("META-INF/MANIFEST.MF")) continue;
                    manifest = new Manifest(zip);
                    break;
                }
            }
            if (manifest != null && (symbolicName = manifest.getMainAttributes().getValue("Bundle-SymbolicName")) != null) {
                int idx = symbolicName.indexOf(59);
                if (idx != -1) {
                    symbolicName = symbolicName.substring(0, idx);
                }
                return new Bundle(symbolicName.trim());
            }
            return null;
        }
        catch (IOException ex) {
            throw new EvaluationException("Failed to read " + file, ex);
        }
    }

    protected static Template<Context> compileTemplate(String template, String name) throws MojoExecutionException {
        try {
            return templateCompiler.compile(template);
        }
        catch (InvalidTemplateException ex) {
            throw new MojoExecutionException("Invalid " + name + " template", (Exception)ex);
        }
    }

    protected static String evaluateTemplate(Template<Context> template, Artifact artifact) throws MojoExecutionException {
        try {
            return template.evaluate(new Context(artifact));
        }
        catch (EvaluationException ex) {
            throw new MojoExecutionException("Failed to process artifact " + artifact.getId() + ": " + ex.getMessage(), (Exception)ex);
        }
    }

    static {
        PropertyGroup<Context, Artifact> artifactGroup = new PropertyGroup<Context, Artifact>(Artifact.class){

            @Override
            public Artifact prepare(Context context) throws EvaluationException {
                return context.getArtifact();
            }
        };
        artifactGroup.addProperty("artifactId", Artifact::getArtifactId);
        artifactGroup.addProperty("groupId", Artifact::getGroupId);
        artifactGroup.addProperty("version", Artifact::getVersion);
        artifactGroup.addProperty("baseVersion", Artifact::getBaseVersion);
        artifactGroup.addProperty("classifier", Artifact::getClassifier);
        artifactGroup.addProperty("type", Artifact::getType);
        artifactGroup.addProperty("file", artifact -> AbstractProcessMojo.getArtifactFile(artifact).getPath());
        artifactGroup.addProperty("url", artifact -> {
            try {
                return AbstractProcessMojo.getArtifactFile(artifact).toURI().toURL().toString();
            }
            catch (MalformedURLException ex) {
                throw new EvaluationException("Unexpected exception", ex);
            }
        });
        templateCompiler.setDefaultPropertyGroup(artifactGroup);
        PropertyGroup<Context, Bundle> bundleGroup = new PropertyGroup<Context, Bundle>(Bundle.class){

            @Override
            public Bundle prepare(Context context) throws EvaluationException {
                return AbstractProcessMojo.extractBundleMetadata(context.getArtifact());
            }
        };
        bundleGroup.addProperty("symbolicName", Bundle::getSymbolicName);
        templateCompiler.addPropertyGroup("bundle", bundleGroup);
    }
}

