/*
 * Decompiled with CFR 0.152.
 */
package com.github.veithen.alta.template;

import com.github.veithen.alta.template.InvalidTemplateException;

final class Scanner {
    private final String s;
    private int pos;

    Scanner(String s) {
        this.s = s;
    }

    int peek() {
        return this.pos == this.s.length() ? -1 : (int)this.s.charAt(this.pos);
    }

    char consume() throws InvalidTemplateException {
        if (this.pos == this.s.length()) {
            throw new InvalidTemplateException("Unexpected end of string");
        }
        return this.s.charAt(this.pos++);
    }

    void expect(char expected) throws InvalidTemplateException {
        if (this.pos == this.s.length()) {
            throw new InvalidTemplateException("Unexpected end of string");
        }
        char c = this.s.charAt(this.pos);
        if (c != expected) {
            throw new InvalidTemplateException("Expected '" + expected + "' but got '" + c + "'");
        }
        ++this.pos;
    }

    boolean consume(char expected) throws InvalidTemplateException {
        if (this.peek() == expected) {
            this.consume();
            return true;
        }
        return false;
    }

    String parseString(String stopChars) throws InvalidTemplateException {
        StringBuilder buffer = new StringBuilder();
        while (true) {
            int c;
            if ((c = this.peek()) == 92) {
                this.consume();
                if (this.peek() != -1 && stopChars.indexOf(c = (int)this.consume()) == -1) {
                    buffer.append('\\');
                }
                buffer.append((char)c);
                continue;
            }
            if (c == -1 || stopChars.indexOf(c) != -1) {
                return buffer.toString();
            }
            buffer.append(this.consume());
        }
    }

    String parseAtom() throws InvalidTemplateException {
        StringBuilder buffer = new StringBuilder();
        while (Scanner.isAtomChar(this.peek())) {
            buffer.append(this.consume());
        }
        if (buffer.length() == 0) {
            throw new InvalidTemplateException("Expected identifier");
        }
        return buffer.toString();
    }

    private static boolean isAtomChar(int c) {
        return 97 <= c && c <= 122 || 65 <= c && c <= 90;
    }
}

