/*
 * Decompiled with CFR 0.152.
 */
package com.github.veithen.maven.eclipse.settings;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

@Mojo(name="dump")
public class DumpMojo
extends AbstractMojo {
    private static String PREFS_SUFFIX = ".prefs";
    @Parameter(property="project.basedir", readonly=true)
    private File basedir;

    private static void appendSimpleElement(Element parent, String name, String text) {
        Document document = parent.getOwnerDocument();
        Element element = document.createElement(name);
        Text child = text.contains("<") ? document.createCDATASection(text) : document.createTextNode(text);
        element.appendChild(child);
        parent.appendChild(element);
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        Document document;
        File[] files = new File(this.basedir, ".settings").listFiles(f -> f.getName().endsWith(PREFS_SUFFIX));
        if (files == null) {
            return;
        }
        try {
            document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException ex) {
            throw new Error(ex);
        }
        Element configuration = document.createElement("configuration");
        document.appendChild(configuration);
        for (File file : files) {
            Properties prefs = new Properties();
            try (FileInputStream in = new FileInputStream(file);){
                prefs.load(in);
            }
            catch (IOException ex) {
                throw new MojoExecutionException("Failed to read preferences from " + file, (Exception)ex);
            }
            Element bundle = document.createElement("bundle");
            configuration.appendChild(bundle);
            String fileName = file.getName();
            DumpMojo.appendSimpleElement(bundle, "symbolicName", fileName.substring(0, fileName.length() - PREFS_SUFFIX.length()));
            Element properties = document.createElement("properties");
            bundle.appendChild(properties);
            for (Map.Entry<Object, Object> entry : prefs.entrySet()) {
                String name = (String)entry.getKey();
                if (name.equals("eclipse.preferences.version")) continue;
                Element property = document.createElement("property");
                properties.appendChild(property);
                DumpMojo.appendSimpleElement(property, "name", name);
                DumpMojo.appendSimpleElement(property, "value", ((String)entry.getValue()).replaceAll("\\$", "\\$\\$"));
            }
        }
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            transformer.transform(new DOMSource(configuration), new StreamResult(System.out));
        }
        catch (TransformerException ex) {
            throw new Error(ex);
        }
    }
}

