/*
 * Decompiled with CFR 0.152.
 */
package com.github.veithen.maven.eclipse.settings;

import com.github.veithen.maven.eclipse.settings.Bundle;
import com.github.veithen.maven.eclipse.settings.Prefs;
import com.github.veithen.maven.eclipse.settings.Property;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.sonatype.plexus.build.incremental.BuildContext;

@Mojo(name="apply", defaultPhase=LifecyclePhase.INITIALIZE)
public class ApplyMojo
extends AbstractMojo {
    @Component
    private BuildContext buildContext;
    @Parameter(property="project.basedir", readonly=true)
    private File basedir;
    @Parameter(required=true)
    private Bundle[] bundles;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Log log = this.getLog();
        File settingsDir = new File(this.basedir, ".settings");
        settingsDir.mkdirs();
        for (Bundle bundle : this.bundles) {
            File prefsFile = new File(settingsDir, bundle.getSymbolicName() + ".prefs");
            Properties prefs = new Properties();
            if (prefsFile.exists()) {
                try (FileInputStream in = new FileInputStream(prefsFile);){
                    prefs.load(in);
                }
                catch (IOException ex) {
                    throw new MojoFailureException(String.format("Failed to read properties from %s", prefsFile), (Throwable)ex);
                }
            }
            boolean updated = false;
            for (Property property : bundle.getProperties()) {
                Object oldValue = prefs.put(property.getName(), property.getValue());
                updated |= !property.getValue().equals(oldValue);
            }
            if (!updated) continue;
            prefs.put("eclipse.preferences.version", "1");
            log.info((CharSequence)("Applying settings for bundle " + bundle.getSymbolicName()));
            try (OutputStream out = this.buildContext.newFileOutputStream(prefsFile);){
                Prefs.store(prefs, out);
            }
            catch (IOException ex) {
                throw new MojoFailureException(String.format("Failed to write properties to %s", prefsFile), (Throwable)ex);
            }
        }
    }
}

