/*
 * Decompiled with CFR 0.152.
 */
package com.github.veithen.maven.hermetic;

import com.github.veithen.maven.hermetic.PolicyWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketPermission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.shared.transfer.artifact.ArtifactCoordinate;
import org.apache.maven.shared.transfer.artifact.DefaultArtifactCoordinate;
import org.apache.maven.shared.transfer.artifact.resolve.ArtifactResolver;
import org.apache.maven.shared.transfer.artifact.resolve.ArtifactResolverException;
import org.codehaus.plexus.util.IOUtil;

@Mojo(name="generate-policy", defaultPhase=LifecyclePhase.GENERATE_TEST_RESOURCES, threadSafe=true)
public final class GeneratePolicyMojo
extends AbstractMojo {
    private static final String[] defaultSafeMethods = new String[]{"org.apache.tools.ant.types.Path.addExisting", "org.apache.tools.ant.util.JavaEnvUtils.getJdkExecutable"};
    @Parameter(property="project", readonly=true, required=true)
    private MavenProject project;
    @Parameter(property="session", readonly=true, required=true)
    private MavenSession session;
    @Parameter(property="mojoExecution", readonly=true, required=true)
    protected MojoExecution mojoExecution;
    @Component
    private ArtifactResolver resolver;
    @Parameter(defaultValue="${project.build.directory}/test.policy", required=true)
    private File outputFile;
    @Parameter(defaultValue="false", required=true)
    private boolean skip;
    @Parameter(defaultValue="false", required=true)
    private boolean debug;
    @Parameter
    private String[] safeMethods;
    @Deprecated
    @Parameter(defaultValue="false", required=true)
    private boolean allowExec;
    @Parameter(defaultValue="false", required=true)
    private boolean allowCrossProjectAccess;
    @Parameter(defaultValue="argLine", required=true)
    private String property;
    @Parameter(defaultValue="true", required=true)
    private boolean append;
    @Parameter(defaultValue="false", required=true)
    private boolean generatePolicyOnly;

    private static boolean isDescendant(File dir, File path) {
        do {
            if (!path.equals(dir)) continue;
            return true;
        } while ((path = path.getParentFile()) != null);
        return false;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        String currentValue;
        Log log = this.getLog();
        if (this.skip || this.project.getPackaging().equals("pom")) {
            return;
        }
        File projectDir = this.project.getBasedir();
        if (this.allowCrossProjectAccess) {
            File dir2 = projectDir;
            while ((dir2 = dir2.getParentFile()) != null) {
                if (!new File(dir2, "pom.xml").exists()) continue;
                projectDir = dir2;
            }
        }
        this.outputFile.getParentFile().mkdirs();
        try (OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(this.outputFile), "utf-8");){
            File javaHome;
            File jdkHome;
            PolicyWriter writer = new PolicyWriter(out, log);
            writer.start();
            String javaHomeString = System.getenv("JAVA_HOME");
            if (javaHomeString == null) {
                javaHomeString = System.getProperty("java.home");
            }
            File file = jdkHome = (javaHome = new File(javaHomeString)).getName().equals("jre") ? javaHome.getParentFile() : javaHome;
            if (log.isDebugEnabled()) {
                log.debug((CharSequence)("JDK home is " + jdkHome));
            }
            writer.generateDirPermissions(jdkHome, Integer.MAX_VALUE, false);
            String extDirs = System.getProperty("java.ext.dirs");
            if (extDirs != null) {
                List dirs = Stream.of(extDirs.split(Pattern.quote(File.pathSeparator))).map(File::new).filter(dir -> !GeneratePolicyMojo.isDescendant(jdkHome, dir)).collect(Collectors.toList());
                for (File dir3 : dirs) {
                    writer.generateDirPermissions(dir3, 1, false);
                }
            }
            writer.generateDirPermissions(new File(System.getProperty("maven.home")), Integer.MAX_VALUE, false);
            writer.generateDirPermissions(new File(this.session.getSettings().getLocalRepository()), 0, false);
            writer.generateDirPermissions(projectDir, 0, false);
            writer.writePermission(new FilePermission(this.session.getRequest().getUserToolchainsFile().getAbsolutePath(), "read"));
            for (MavenProject project : this.session.getProjects()) {
                File file2 = project.getArtifact().getFile();
                if (file2 != null) {
                    writer.writePermission(new FilePermission(file2.getAbsolutePath(), "read"));
                }
                for (Artifact attachedArtifact : project.getAttachedArtifacts()) {
                    writer.writePermission(new FilePermission(attachedArtifact.getFile().getAbsolutePath(), "read"));
                }
            }
            for (String dir4 : new String[]{this.project.getBuild().getDirectory(), System.getProperty("java.io.tmpdir")}) {
                writer.generateDirPermissions(new File(dir4), 0, true);
            }
            writer.writePermission(new FilePermission(System.getProperty("user.home"), "read"));
            writer.writePermission(new SocketPermission("localhost", "connect,listen,accept,resolve"));
            for (NetworkInterface iface : Collections.list(NetworkInterface.getNetworkInterfaces())) {
                for (InterfaceAddress ifaceAddr : iface.getInterfaceAddresses()) {
                    InetAddress addr = ifaceAddr.getAddress();
                    if (!addr.isLoopbackAddress() && addr.isLinkLocalAddress()) continue;
                    writer.writePermission(new SocketPermission(addr.getHostAddress(), "connect,listen,accept,resolve"));
                }
            }
            if (this.allowExec) {
                writer.writePermission(new FilePermission("<<ALL FILES>>", "execute"));
            }
            writer.end();
        }
        catch (IOException ex) {
            throw new MojoFailureException(String.format("Failed to write %s", this.outputFile), (Throwable)ex);
        }
        Properties props = this.project.getProperties();
        ArrayList<String> args = new ArrayList<String>();
        if (this.append && (currentValue = props.getProperty(this.property)) != null && !currentValue.isEmpty()) {
            args.add(currentValue);
        }
        if (!this.generatePolicyOnly) {
            File securityManagerJarFile;
            DefaultArtifactCoordinate securityManagerArtifact = new DefaultArtifactCoordinate();
            securityManagerArtifact.setGroupId("com.github.veithen");
            securityManagerArtifact.setArtifactId("hermetic-security-manager");
            try (InputStream in = GeneratePolicyMojo.class.getResourceAsStream("hermetic-security-manager.version");){
                securityManagerArtifact.setVersion(IOUtil.toString((InputStream)in, (String)"utf-8"));
            }
            catch (IOException ex) {
                throw new MojoFailureException("Failed to read version information", (Throwable)ex);
            }
            securityManagerArtifact.setExtension("jar");
            try {
                DefaultProjectBuildingRequest projectBuildingRequest = new DefaultProjectBuildingRequest(this.session.getProjectBuildingRequest());
                projectBuildingRequest.setRemoteRepositories(this.project.getPluginArtifactRepositories());
                securityManagerJarFile = this.resolver.resolveArtifact((ProjectBuildingRequest)projectBuildingRequest, (ArtifactCoordinate)securityManagerArtifact).getArtifact().getFile();
            }
            catch (ArtifactResolverException ex) {
                throw new MojoFailureException("Unable to resolve artifact", (Throwable)ex);
            }
            args.add("-Xbootclasspath/a:" + securityManagerJarFile.toString());
            args.add("-Djava.security.manager=com.github.veithen.hermetic.HermeticSecurityManager");
            ArrayList<String> allSafeMethods = new ArrayList<String>(Arrays.asList(defaultSafeMethods));
            if (this.safeMethods != null) {
                allSafeMethods.addAll(Arrays.asList(this.safeMethods));
            }
            args.add("-Dhermetic.safeMethods=" + String.join((CharSequence)",", allSafeMethods));
        }
        args.add("-Djava.security.policy==" + this.outputFile.getAbsolutePath().replace('\\', '/'));
        if (this.debug) {
            args.add("-Djava.security.debug=access,failure");
        }
        String value = String.join((CharSequence)" ", args);
        props.setProperty(this.property, value);
        log.info((CharSequence)String.format("%s set to %s", this.property, value));
    }
}

