/*
 * Decompiled with CFR 0.152.
 */
package com.github.veithen.maven.hermetic;

import com.github.veithen.maven.hermetic.PathSpec;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;

final class PathUtil {
    private PathUtil() {
    }

    private static void enumeratePaths(Path rootDir, Path dir, int depth, int maxDepth, Collection<PathSpec> result) throws IOException {
        if (dir == rootDir) {
            result.add(PathSpec.create(dir, depth, true));
        }
        if (!Files.exists(dir, new LinkOption[0]) || depth == maxDepth) {
            return;
        }
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(dir);){
            for (Path path : directoryStream) {
                if (Files.isSymbolicLink(path)) {
                    Path target = dir.resolve(Files.readSymbolicLink(path)).normalize();
                    if (target.startsWith(rootDir)) continue;
                    if (Files.isDirectory(path, new LinkOption[0])) {
                        PathUtil.enumeratePaths(target, target, depth + 1, maxDepth, result);
                        continue;
                    }
                    result.add(PathSpec.create(target, depth + 1, false));
                    continue;
                }
                if (!Files.isDirectory(path, new LinkOption[0])) continue;
                PathUtil.enumeratePaths(rootDir, path, depth + 1, maxDepth, result);
            }
        }
    }

    static Collection<PathSpec> enumeratePaths(Path dir, int maxDepth) throws IOException {
        HashSet<PathSpec> result = new HashSet<PathSpec>();
        PathUtil.enumeratePaths(dir, dir, 0, maxDepth, result);
        ArrayList<PathSpec> canonicalized = new ArrayList<PathSpec>(result.size());
        for (PathSpec pathSpec : result) {
            if (!Files.exists(pathSpec.path(), new LinkOption[0])) continue;
            canonicalized.add(PathSpec.create(pathSpec.path().toRealPath(new LinkOption[0]), pathSpec.depth(), pathSpec.directory()));
        }
        result.addAll(canonicalized);
        return result;
    }
}

