/*
 * Decompiled with CFR 0.152.
 */
package com.github.veithen.maven.hermetic;

import com.github.veithen.maven.hermetic.PathSpec;
import com.github.veithen.maven.hermetic.PathUtil;
import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.io.Writer;
import java.security.Permission;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.maven.plugin.logging.Log;

final class PolicyWriter {
    private final Writer out;
    private final Log log;

    PolicyWriter(Writer out, Log log) {
        this.out = out;
        this.log = log;
    }

    void start() throws IOException {
        this.out.write("grant {\n");
    }

    void writePermission(String permissionClassName, String targetName, String action) throws IOException {
        StringBuilder buffer = new StringBuilder("permission ");
        buffer.append(permissionClassName);
        buffer.append(" \"");
        buffer.append(StringEscapeUtils.escapeJava((String)targetName));
        buffer.append('\"');
        if (action != null) {
            buffer.append(", \"");
            buffer.append(StringEscapeUtils.escapeJava((String)action));
            buffer.append('\"');
        }
        String permission = buffer.toString();
        if (this.log.isDebugEnabled()) {
            this.log.debug((CharSequence)("Adding " + permission));
        }
        this.out.write("  ");
        this.out.write(permission);
        this.out.write(";\n");
    }

    void writePermission(Permission permission) throws IOException {
        String actions = permission.getActions();
        this.writePermission(permission.getClass().getName(), permission.getName(), actions.isEmpty() ? null : actions);
    }

    void generateDirPermissions(File dir, int maxDepth, boolean allowWrite) throws IOException {
        String rootActions = allowWrite ? "read,readlink,write" : "read,readlink";
        String actions = allowWrite ? "read,readlink,write,delete" : "read,readlink";
        for (PathSpec pathSpec : PathUtil.enumeratePaths(dir.getAbsoluteFile().toPath(), maxDepth)) {
            this.writePermission(new FilePermission(pathSpec.path().toString(), pathSpec.depth() == 0 ? rootActions : actions));
            if (!pathSpec.directory()) continue;
            this.writePermission(new FilePermission(pathSpec.path().resolve("-").toString(), actions));
        }
    }

    void end() throws IOException {
        this.out.write("};\n");
    }
}

