/*
 * Decompiled with CFR 0.152.
 */
package com.github.veithen.maven.jacoco;

import com.github.veithen.maven.jacoco.Source;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jacoco.core.analysis.IBundleCoverage;
import org.jacoco.core.analysis.ISourceFileCoverage;
import org.jacoco.core.data.SessionInfo;
import org.jacoco.core.tools.ExecFileLoader;
import org.jacoco.report.IReportVisitor;
import org.jacoco.report.ISourceFileLocator;
import org.jacoco.report.InputStreamSourceFileLocator;

public final class CoverageContext {
    private static final Pattern autoSessionIdPattern = Pattern.compile(".*-([0-9a-f]{1,8})");
    private final ExecFileLoader loader;
    private final IBundleCoverage bundle;
    private final Map<String, File> sourceFiles;
    private final Supplier<File> rootDirSupplier;

    CoverageContext(ExecFileLoader loader, IBundleCoverage bundle, Map<String, File> sourceFiles, Supplier<File> rootDirSupplier) {
        this.loader = loader;
        this.bundle = bundle;
        this.sourceFiles = sourceFiles;
        this.rootDirSupplier = rootDirSupplier;
    }

    public IBundleCoverage getBundle() {
        return this.bundle;
    }

    static SessionInfo anonymize(SessionInfo sessionInfo) {
        Matcher matcher = autoSessionIdPattern.matcher(sessionInfo.getId());
        if (matcher.matches()) {
            return new SessionInfo(matcher.group(1), sessionInfo.getStartTimeStamp(), sessionInfo.getDumpTimeStamp());
        }
        return sessionInfo;
    }

    public void visit(IReportVisitor visitor) throws IOException {
        visitor.visitInfo(this.loader.getSessionInfoStore().getInfos().stream().map(CoverageContext::anonymize).collect(Collectors.toList()), this.loader.getExecutionDataStore().getContents());
        visitor.visitBundle(this.bundle, (ISourceFileLocator)new InputStreamSourceFileLocator("utf-8", 4){

            protected InputStream getSourceStream(String path) throws IOException {
                File file = (File)CoverageContext.this.sourceFiles.get(path);
                return file == null ? null : new FileInputStream(file);
            }
        });
        visitor.visitEnd();
    }

    public Source lookupSource(ISourceFileCoverage sourceFileCoverage) {
        File sourceFile = this.sourceFiles.get(sourceFileCoverage.getPackageName().replace('.', '/') + "/" + sourceFileCoverage.getName());
        return sourceFile == null ? null : new Source(sourceFile, this.rootDirSupplier);
    }
}

