/*
 * Decompiled with CFR 0.152.
 */
package com.github.veithen.maven.jacoco;

import java.io.IOException;
import java.util.function.Supplier;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.ServerErrorException;

public final class Retry {
    private Retry() {
    }

    public static <T> T withRetry(Supplier<T> retryable) {
        int numAttempts = 0;
        long delay = 500L;
        while (true) {
            ++numAttempts;
            try {
                return retryable.get();
            }
            catch (RuntimeException ex) {
                if (Retry.isRetriable(ex) && numAttempts < 4) {
                    try {
                        Thread.sleep(delay);
                    }
                    catch (InterruptedException ex2) {
                        throw new ProcessingException((Throwable)ex2);
                    }
                    delay *= 2L;
                    continue;
                }
                throw ex;
            }
            break;
        }
    }

    private static boolean isRetriable(RuntimeException ex) {
        return ex instanceof ProcessingException && ex.getCause() instanceof IOException || ex instanceof ServerErrorException;
    }
}

