/*
 * Decompiled with CFR 0.152.
 */
package com.github.veithen.maven.jacoco.codecov;

import com.github.veithen.maven.jacoco.ContinuousIntegrationContext;
import com.github.veithen.maven.jacoco.CoverageContext;
import com.github.veithen.maven.jacoco.CoverageService;
import com.github.veithen.maven.jacoco.Retry;
import com.github.veithen.maven.jacoco.ServiceMap;
import com.github.veithen.maven.jacoco.Source;
import java.util.Map;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import org.jacoco.core.analysis.ICounter;
import org.jacoco.core.analysis.ILine;
import org.jacoco.core.analysis.IPackageCoverage;
import org.jacoco.core.analysis.ISourceFileCoverage;

final class Codecov
implements CoverageService {
    private final WebTarget target;
    private final Client client;
    private final Map<String, String> serviceMap;

    Codecov(WebTarget target, Client client) {
        this.target = target;
        this.client = client;
        this.serviceMap = ServiceMap.loadServiceMap("META-INF/codecov-services.properties");
    }

    @Override
    public String getName() {
        return "Codecov";
    }

    @Override
    public boolean isEnabled(ContinuousIntegrationContext ciContext) {
        if (ciContext == null || !this.serviceMap.containsKey(ciContext.getService())) {
            return false;
        }
        try {
            Retry.withRetry(() -> (JsonObject)this.target.path("api/gh/{user}/{repo}").resolveTemplate("user", (Object)ciContext.getUser()).resolveTemplate("repo", (Object)ciContext.getRepository()).request().accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get(JsonObject.class));
            return true;
        }
        catch (NotFoundException ex) {
            return false;
        }
    }

    @Override
    public String upload(ContinuousIntegrationContext ciContext, CoverageContext coverageContext) {
        JsonObjectBuilder sourceFilesBuilder = Json.createObjectBuilder();
        for (IPackageCoverage packageCoverage : coverageContext.getBundle().getPackages()) {
            for (ISourceFileCoverage sourceFileCoverage : packageCoverage.getSourceFiles()) {
                Source source = coverageContext.lookupSource(sourceFileCoverage);
                if (source == null) continue;
                JsonObjectBuilder coverageBuilder = Json.createObjectBuilder();
                for (int i = sourceFileCoverage.getFirstLine(); i <= sourceFileCoverage.getLastLine(); ++i) {
                    ILine line = sourceFileCoverage.getLine(i);
                    if (line.getStatus() == 0) continue;
                    ICounter branchCounter = line.getBranchCounter();
                    String value = branchCounter.getTotalCount() > 0 ? String.format("%s/%s", branchCounter.getCoveredCount(), branchCounter.getTotalCount()) : (line.getStatus() == 1 ? "0" : "1");
                    coverageBuilder.add(String.valueOf(i), value);
                }
                sourceFilesBuilder.add(source.getPathRelativeToRepositoryRoot(), (JsonValue)coverageBuilder.build());
            }
        }
        JsonObject report = Json.createObjectBuilder().add("coverage", (JsonValue)sourceFilesBuilder.build()).build();
        String[] responseParts = Retry.withRetry(() -> (String)this.target.path("upload/v4").queryParam("service", new Object[]{this.serviceMap.get(ciContext.getService())}).queryParam("slug", new Object[]{ciContext.getRepoSlug()}).queryParam("job", new Object[]{ciContext.getBuildRunId()}).queryParam("build", new Object[]{ciContext.getBuildId()}).queryParam("build_url", new Object[]{ciContext.getBuildUrl()}).queryParam("branch", new Object[]{ciContext.getBranch()}).queryParam("commit", new Object[]{ciContext.getCommit()}).queryParam("pr", new Object[]{ciContext.getPullRequest()}).request().accept(new String[]{"text/plain"}).post(Entity.entity((Object)"", (String)"text/plain"), String.class)).split("\\r?\\n");
        Retry.withRetry(() -> (String)this.client.target(responseParts[1]).request().put(Entity.entity((Object)report, (MediaType)MediaType.APPLICATION_JSON_TYPE), String.class));
        return responseParts[0];
    }
}

