/*
 * Decompiled with CFR 0.152.
 */
package com.github.veithen.maven.jacoco.coveralls;

import com.github.veithen.maven.jacoco.ContinuousIntegrationContext;
import com.github.veithen.maven.jacoco.CoverageContext;
import com.github.veithen.maven.jacoco.CoverageService;
import com.github.veithen.maven.jacoco.Retry;
import com.github.veithen.maven.jacoco.ServiceMap;
import com.github.veithen.maven.jacoco.Source;
import java.util.Map;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import org.apache.maven.plugin.MojoFailureException;
import org.glassfish.jersey.media.multipart.BodyPart;
import org.glassfish.jersey.media.multipart.FormDataBodyPart;
import org.glassfish.jersey.media.multipart.FormDataContentDisposition;
import org.glassfish.jersey.media.multipart.FormDataMultiPart;
import org.jacoco.core.analysis.IPackageCoverage;
import org.jacoco.core.analysis.ISourceFileCoverage;

final class Coveralls
implements CoverageService {
    private final WebTarget target;
    private final Map<String, String> serviceMap;

    Coveralls(WebTarget target) {
        this.target = target;
        this.serviceMap = ServiceMap.loadServiceMap("META-INF/coveralls-services.properties");
    }

    @Override
    public String getName() {
        return "Coveralls";
    }

    @Override
    public boolean isEnabled(ContinuousIntegrationContext ciContext) {
        if (ciContext == null || !this.serviceMap.containsKey(ciContext.getService())) {
            return false;
        }
        try {
            Retry.withRetry(() -> (JsonValue)this.target.path("github/{user}/{repo}.json").resolveTemplate("user", (Object)ciContext.getUser()).resolveTemplate("repo", (Object)ciContext.getRepository()).request().accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get(JsonValue.class));
            return true;
        }
        catch (NotFoundException ex) {
            return false;
        }
    }

    @Override
    public String upload(ContinuousIntegrationContext ciContext, CoverageContext coverageContext) throws MojoFailureException {
        JsonArrayBuilder sourceFilesBuilder = Json.createArrayBuilder();
        for (IPackageCoverage packageCoverage : coverageContext.getBundle().getPackages()) {
            for (ISourceFileCoverage sourceFileCoverage : packageCoverage.getSourceFiles()) {
                int i;
                Source source = coverageContext.lookupSource(sourceFileCoverage);
                if (source == null) continue;
                JsonArrayBuilder coverageBuilder = Json.createArrayBuilder();
                for (i = 1; i < sourceFileCoverage.getFirstLine(); ++i) {
                    coverageBuilder.add(JsonValue.NULL);
                }
                block7: for (i = sourceFileCoverage.getFirstLine(); i <= sourceFileCoverage.getLastLine(); ++i) {
                    switch (sourceFileCoverage.getLine(i).getStatus()) {
                        case 0: {
                            coverageBuilder.add(JsonValue.NULL);
                            continue block7;
                        }
                        case 1: {
                            coverageBuilder.add(0);
                            continue block7;
                        }
                        default: {
                            coverageBuilder.add(1);
                        }
                    }
                }
                sourceFilesBuilder.add((JsonValue)Json.createObjectBuilder().add("name", source.getPathRelativeToRepositoryRoot()).add("source_digest", source.digest()).add("coverage", (JsonValue)coverageBuilder.build()).build());
            }
        }
        JsonObjectBuilder jsonFileBuilder = Json.createObjectBuilder().add("service_name", this.serviceMap.get(ciContext.getService()));
        if (ciContext.getBuildId() != null) {
            jsonFileBuilder.add("service_number", ciContext.getBuildId());
        }
        if (ciContext.getBuildRunId() != null) {
            jsonFileBuilder.add("service_job_id", ciContext.getBuildRunId());
        }
        jsonFileBuilder.add("source_files", (JsonValue)sourceFilesBuilder.build());
        JsonObject jsonFile = jsonFileBuilder.build();
        FormDataMultiPart multipart = new FormDataMultiPart();
        multipart.bodyPart((BodyPart)new FormDataBodyPart(((FormDataContentDisposition.FormDataContentDispositionBuilder)FormDataContentDisposition.name((String)"json_file").fileName("coverage.json")).build(), (Object)jsonFile, MediaType.APPLICATION_JSON_TYPE));
        return Retry.withRetry(() -> ((JsonObject)this.target.path("api/v1/jobs").request().post(Entity.entity((Object)multipart, (MediaType)multipart.getMediaType()), JsonObject.class)).getString("url"));
    }
}

