/*
 * Decompiled with CFR 0.152.
 */
package com.github.veithen.maven.jacoco.githubactions;

import com.github.veithen.maven.jacoco.ContinuousIntegrationContext;
import com.github.veithen.maven.jacoco.ContinuousIntegrationContextFactory;
import java.util.Map;
import org.codehaus.plexus.component.annotations.Component;

@Component(role=ContinuousIntegrationContextFactory.class, hint="github-actions")
public class GithubActionsContextFactory
implements ContinuousIntegrationContextFactory {
    @Override
    public ContinuousIntegrationContext createContext(Map<String, String> env) {
        String action = env.get("GITHUB_ACTION");
        String repoSlug = env.get("GITHUB_REPOSITORY");
        String runId = env.get("GITHUB_RUN_ID");
        String ref = env.get("GITHUB_REF");
        String commit = env.get("GITHUB_SHA");
        if (action != null && repoSlug != null && runId != null && ref != null && commit != null) {
            String pullRequest;
            String branch;
            if (ref.startsWith("refs/heads/")) {
                branch = ref.substring(11);
                pullRequest = null;
            } else if (ref.startsWith("refs/pull/") && ref.endsWith("/merge")) {
                branch = env.get("GITHUB_HEAD_REF");
                if (branch == null) {
                    return null;
                }
                pullRequest = ref.substring(10, ref.length() - 6);
            } else {
                return null;
            }
            return new ContinuousIntegrationContext("github-actions", repoSlug, null, runId, String.format("http://github.com/%s/actions/runs/%s", repoSlug, runId), branch, commit, pullRequest);
        }
        return null;
    }
}

