/*
 * Decompiled with CFR 0.152.
 */
package com.github.veithen.maven.jacoco;

import com.github.veithen.maven.jacoco.CoverageContext;
import com.github.veithen.maven.jacoco.CoverageData;
import com.github.veithen.maven.jacoco.CoverageFileFormat;
import com.github.veithen.maven.jacoco.Lazy;
import com.github.veithen.maven.shared.mojo.aggregating.AggregatingMojo;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.DirectoryScanner;
import org.jacoco.core.analysis.Analyzer;
import org.jacoco.core.analysis.CoverageBuilder;
import org.jacoco.core.analysis.IBundleCoverage;
import org.jacoco.core.analysis.ICoverageVisitor;
import org.jacoco.core.tools.ExecFileLoader;

@Mojo(name="process", defaultPhase=LifecyclePhase.POST_INTEGRATION_TEST, threadSafe=true)
public final class ProcessMojo
extends AggregatingMojo<CoverageData> {
    @Parameter(defaultValue="${project.build.directory}/jacoco.exec", required=true)
    private File dataFile;
    @Parameter(defaultValue="true")
    private boolean includeClasses;
    @Component(role=CoverageFileFormat.class)
    private Map<String, CoverageFileFormat> coverageFileFormats;
    @Parameter(defaultValue="codecov", required=true)
    private String format;

    public ProcessMojo() {
        super(CoverageData.class);
    }

    private static boolean isChild(File parent, File child) {
        for (File candidate = child; candidate != null; candidate = candidate.getParentFile()) {
            if (!candidate.equals(parent)) continue;
            return true;
        }
        return false;
    }

    protected CoverageData doExecute() throws MojoExecutionException, MojoFailureException {
        boolean dataFileExists = this.dataFile.exists();
        HashMap<String, File> sources = new HashMap<String, File>();
        if (this.includeClasses) {
            File buildDirectory = new File(this.project.getBuild().getDirectory());
            for (String compileSourceRoot : this.project.getCompileSourceRoots()) {
                File basedir = new File(compileSourceRoot);
                if (ProcessMojo.isChild(buildDirectory, basedir) || !basedir.exists()) continue;
                DirectoryScanner scanner = new DirectoryScanner();
                scanner.setBasedir(basedir);
                scanner.scan();
                for (String includedFile : scanner.getIncludedFiles()) {
                    sources.put(includedFile, new File(basedir, includedFile));
                }
            }
        }
        if (dataFileExists || !sources.isEmpty()) {
            File classes = new File(this.project.getBuild().getOutputDirectory());
            return new CoverageData(dataFileExists ? this.dataFile : null, this.includeClasses && classes.exists() ? classes : null, sources);
        }
        return null;
    }

    private File findRootDir() {
        File rootDir = this.project.getBasedir();
        while (!new File(rootDir, ".git").exists()) {
            if ((rootDir = rootDir.getParentFile()) != null) continue;
            throw new IllegalStateException("Root directory not found; are we running from a Git clone?");
        }
        return rootDir;
    }

    private static <T> Iterable<T> toIterable(Stream<T> stream) {
        return stream::iterator;
    }

    protected void doAggregate(List<CoverageData> results) throws MojoExecutionException, MojoFailureException {
        Log log = this.getLog();
        if (results.stream().map(CoverageData::getDataFile).allMatch(Objects::isNull)) {
            log.info((CharSequence)"No coverage data collected; skipping execution.");
            return;
        }
        if (results.stream().map(CoverageData::getClasses).allMatch(Objects::isNull)) {
            log.info((CharSequence)"No classes included; skipping execution.");
            return;
        }
        CoverageFileFormat coverageFileFormat = this.coverageFileFormats.get(this.format);
        if (coverageFileFormat == null) {
            throw new MojoExecutionException(String.format("Unknown format \"%s\"", this.format));
        }
        ExecFileLoader loader = new ExecFileLoader();
        for (File dataFile : ProcessMojo.toIterable(results.stream().map(CoverageData::getDataFile).filter(Objects::nonNull))) {
            try {
                loader.load(dataFile);
            }
            catch (IOException ex) {
                throw new MojoExecutionException(String.format("Failed to load exec file %s: %s", dataFile, ex.getMessage()), (Exception)ex);
            }
        }
        CoverageBuilder builder = new CoverageBuilder();
        Analyzer analyzer = new Analyzer(loader.getExecutionDataStore(), (ICoverageVisitor)builder);
        for (File classes : ProcessMojo.toIterable(results.stream().map(CoverageData::getClasses).filter(Objects::nonNull))) {
            try {
                analyzer.analyzeAll(classes);
            }
            catch (IOException ex) {
                throw new MojoExecutionException(String.format("Failed to analyze %s: %s", classes, ex.getMessage()), (Exception)ex);
            }
        }
        HashMap<String, File> sourceFiles = new HashMap<String, File>();
        results.stream().map(CoverageData::getSources).forEach(sourceFiles::putAll);
        IBundleCoverage bundle = builder.getBundle("Coverage Report");
        CoverageContext coverageContext = new CoverageContext(loader, bundle, sourceFiles, new Lazy<File>(this::findRootDir));
        File outputDir = new File(this.mavenSession.getTopLevelProject().getBuild().getDirectory());
        outputDir.mkdirs();
        File outputFile = new File(outputDir, coverageFileFormat.getDefaultFileName());
        try (FileOutputStream out = new FileOutputStream(outputFile);){
            coverageFileFormat.write(coverageContext, out);
        }
        catch (IOException ex) {
            throw new MojoExecutionException(String.format("Failed to write %s: %s", outputFile, ex.getMessage()), (Exception)ex);
        }
    }
}

