/*
 * Decompiled with CFR 0.152.
 */
package com.github.veithen.maven.jacoco.codecov;

import com.github.veithen.maven.jacoco.CoverageContext;
import com.github.veithen.maven.jacoco.CoverageFileFormat;
import com.github.veithen.maven.jacoco.Source;
import jakarta.json.Json;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import java.io.OutputStream;
import org.codehaus.plexus.component.annotations.Component;
import org.jacoco.core.analysis.ICounter;
import org.jacoco.core.analysis.ILine;
import org.jacoco.core.analysis.IPackageCoverage;
import org.jacoco.core.analysis.ISourceFileCoverage;

@Component(role=CoverageFileFormat.class, hint="codecov")
public final class Codecov
implements CoverageFileFormat {
    @Override
    public String getDefaultFileName() {
        return "coverage.json";
    }

    @Override
    public void write(CoverageContext coverageContext, OutputStream out) {
        JsonObjectBuilder sourceFilesBuilder = Json.createObjectBuilder();
        for (IPackageCoverage packageCoverage : coverageContext.getBundle().getPackages()) {
            for (ISourceFileCoverage sourceFileCoverage : packageCoverage.getSourceFiles()) {
                Source source = coverageContext.lookupSource(sourceFileCoverage);
                if (source == null) continue;
                JsonObjectBuilder coverageBuilder = Json.createObjectBuilder();
                for (int i = sourceFileCoverage.getFirstLine(); i <= sourceFileCoverage.getLastLine(); ++i) {
                    ILine line = sourceFileCoverage.getLine(i);
                    if (line.getStatus() == 0) continue;
                    ICounter branchCounter = line.getBranchCounter();
                    String value = branchCounter.getTotalCount() > 0 ? String.format("%s/%s", branchCounter.getCoveredCount(), branchCounter.getTotalCount()) : (line.getStatus() == 1 ? "0" : "1");
                    coverageBuilder.add(String.valueOf(i), value);
                }
                sourceFilesBuilder.add(source.getPathRelativeToRepositoryRoot(), (JsonValue)coverageBuilder.build());
            }
        }
        JsonObject report = Json.createObjectBuilder().add("coverage", (JsonValue)sourceFilesBuilder.build()).build();
        Json.createWriter((OutputStream)out).writeObject(report);
    }
}

