/*
 * Decompiled with CFR 0.152.
 */
package com.github.veithen.maven.p2;

import com.github.veithen.maven.p2.P2Coordinate;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.repository.artifact.ArtifactKeyQuery;

public final class ArtifactCoordinateMapper {
    private static final Set<String> supportedP2Classifiers = new HashSet<String>(Arrays.asList("osgi.bundle"));

    private ArtifactCoordinateMapper() {
    }

    public static P2Coordinate createP2Coordinate(Artifact artifact) {
        Version version;
        String id;
        if (!supportedP2Classifiers.contains(artifact.getGroupId())) {
            return null;
        }
        String classifier = artifact.getClassifier();
        if (classifier.isEmpty()) {
            id = artifact.getArtifactId();
        } else if (classifier.equals("sources")) {
            id = artifact.getArtifactId() + ".source";
        } else {
            return null;
        }
        try {
            version = Version.create((String)artifact.getVersion());
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
        return new P2Coordinate(artifact.getGroupId(), id, version);
    }

    public static ArtifactKeyQuery createArtifactKeyQuery(String groupId, String artifactId) {
        if (!supportedP2Classifiers.contains(groupId)) {
            return null;
        }
        return new ArtifactKeyQuery(groupId, artifactId, null);
    }
}

