/*
 * Decompiled with CFR 0.152.
 */
package com.github.veithen.maven.p2.connector;

import com.github.veithen.cosmos.osgi.runtime.CosmosRuntime;
import com.github.veithen.maven.p2.connector.P2RepositoryConnector;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Named;
import javax.inject.Singleton;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.spi.connector.RepositoryConnector;
import org.eclipse.aether.spi.connector.RepositoryConnectorFactory;
import org.eclipse.aether.transfer.NoRepositoryConnectorException;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.IProvisioningAgentProvider;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.osgi.framework.BundleException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="p2")
@Singleton
public final class P2RepositoryConnectorFactory
implements RepositoryConnectorFactory {
    private static final Logger logger = LoggerFactory.getLogger(P2RepositoryConnectorFactory.class);
    private final Map<File, IProvisioningAgent> provisioningAgents = new HashMap<File, IProvisioningAgent>();

    public float getPriority() {
        return 0.0f;
    }

    private synchronized IProvisioningAgent getProvisioningAgent(File localRepositoryDir) {
        IProvisioningAgent provisioningAgent = this.provisioningAgents.get(localRepositoryDir);
        if (provisioningAgent == null) {
            if (logger.isDebugEnabled()) {
                logger.debug(String.format("Creating new provisioning agent for local repository %s", localRepositoryDir));
            }
            try {
                provisioningAgent = ((IProvisioningAgentProvider)CosmosRuntime.getInstance().getService(IProvisioningAgentProvider.class)).createAgent(new File(localRepositoryDir, ".p2-metadata").toURI());
            }
            catch (ProvisionException | BundleException ex) {
                logger.error(String.format("Failed to create provisioning agent for local repository %s", localRepositoryDir));
                throw new Error(ex);
            }
            this.provisioningAgents.put(localRepositoryDir, provisioningAgent);
        }
        return provisioningAgent;
    }

    public RepositoryConnector newInstance(RepositorySystemSession session, RemoteRepository repository) throws NoRepositoryConnectorException {
        if (repository.getContentType().equals("p2")) {
            File localRepositoryDir = session.getLocalRepository().getBasedir();
            return new P2RepositoryConnector(repository, () -> (IArtifactRepositoryManager)this.getProvisioningAgent(localRepositoryDir).getService(IArtifactRepositoryManager.SERVICE_NAME));
        }
        throw new NoRepositoryConnectorException(repository);
    }
}

