/*
 * Decompiled with CFR 0.152.
 */
package com.github.veithen.phos.jacoco;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.repository.RepositorySystem;
import org.apache.maven.shared.artifact.filter.collection.ArtifactFilterException;
import org.apache.maven.shared.artifact.filter.collection.ArtifactsFilter;
import org.apache.maven.shared.artifact.filter.collection.FilterArtifacts;
import org.apache.maven.shared.artifact.filter.collection.ProjectTransitivityFilter;
import org.apache.maven.shared.artifact.filter.collection.ScopeFilter;
import org.apache.maven.shared.artifact.filter.collection.TypeFilter;
import org.apache.maven.shared.artifact.resolve.ArtifactResolver;
import org.apache.maven.shared.artifact.resolve.ArtifactResolverException;
import org.codehaus.plexus.archiver.UnArchiver;
import org.jacoco.core.analysis.Analyzer;
import org.jacoco.core.analysis.CoverageBuilder;
import org.jacoco.core.analysis.IBundleCoverage;
import org.jacoco.core.analysis.ICoverageVisitor;
import org.jacoco.core.data.SessionInfo;
import org.jacoco.core.tools.ExecFileLoader;
import org.jacoco.report.DirectorySourceFileLocator;
import org.jacoco.report.FileMultiReportOutput;
import org.jacoco.report.IMultiReportOutput;
import org.jacoco.report.IReportVisitor;
import org.jacoco.report.ISourceFileLocator;
import org.jacoco.report.html.HTMLFormatter;

@Mojo(name="aggregate-report", requiresDependencyResolution=ResolutionScope.TEST, defaultPhase=LifecyclePhase.SITE, threadSafe=true)
public class AggregateReportMojo
extends AbstractMojo {
    private static final Pattern autoSessionIdPattern = Pattern.compile(".*-([0-9a-f]{1,8})");
    @Parameter(property="project", required=true, readonly=true)
    private MavenProject project;
    @Parameter(property="session", required=true, readonly=true)
    private MavenSession session;
    @Component
    private RepositorySystem repositorySystem;
    @Component
    private ArtifactResolver resolver;
    @Component(hint="jar")
    private UnArchiver jarUnArchiver;
    @Parameter(defaultValue="${project.build.directory}/site", required=true, readonly=true)
    private File outputDirectory;

    private Set<Artifact> getArtifactsInScope(String scope) throws MojoExecutionException {
        FilterArtifacts filter = new FilterArtifacts();
        filter.addFilter((ArtifactsFilter)new ProjectTransitivityFilter(this.project.getDependencyArtifacts(), true));
        filter.addFilter((ArtifactsFilter)new ScopeFilter(scope, null));
        filter.addFilter((ArtifactsFilter)new TypeFilter("jar", null));
        try {
            return filter.filter(this.project.getArtifacts());
        }
        catch (ArtifactFilterException ex) {
            throw new MojoExecutionException(ex.getMessage(), (Exception)((Object)ex));
        }
    }

    private File resolveArtifact(Artifact baseArtifact, String classifier, String type, boolean localOnly, boolean allowMissing) throws MojoExecutionException {
        ProjectBuildingRequest projectBuildingRequest = this.session.getProjectBuildingRequest();
        if (localOnly) {
            projectBuildingRequest = new DefaultProjectBuildingRequest(projectBuildingRequest);
            projectBuildingRequest.setRemoteRepositories(Collections.emptyList());
        }
        Dependency dependency = new Dependency();
        dependency.setGroupId(baseArtifact.getGroupId());
        dependency.setArtifactId(baseArtifact.getArtifactId());
        dependency.setVersion(baseArtifact.getVersion());
        dependency.setType(type);
        dependency.setClassifier(classifier);
        dependency.setScope("compile");
        Artifact artifact = this.repositorySystem.createDependencyArtifact(dependency);
        try {
            return this.resolver.resolveArtifact(projectBuildingRequest, artifact).getArtifact().getFile();
        }
        catch (ArtifactResolverException ex) {
            if (allowMissing) {
                return null;
            }
            throw new MojoExecutionException("Unable to resolve artifact", (Exception)((Object)ex));
        }
    }

    static SessionInfo anonymize(SessionInfo sessionInfo) {
        Matcher matcher = autoSessionIdPattern.matcher(sessionInfo.getId());
        if (matcher.matches()) {
            return new SessionInfo(matcher.group(1), sessionInfo.getStartTimeStamp(), sessionInfo.getDumpTimeStamp());
        }
        return sessionInfo;
    }

    private static List<SessionInfo> anonymize(List<SessionInfo> sessionInfos) {
        ArrayList<SessionInfo> result = new ArrayList<SessionInfo>(sessionInfos.size());
        for (SessionInfo sessionInfo : sessionInfos) {
            result.add(AggregateReportMojo.anonymize(sessionInfo));
        }
        return result;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        File sourcesDirectory = new File(this.project.getBuild().getDirectory(), "sources");
        sourcesDirectory.mkdirs();
        ExecFileLoader loader = new ExecFileLoader();
        for (Artifact baseArtifact : this.getArtifactsInScope("test")) {
            File file = this.resolveArtifact(baseArtifact, "jacoco", "exec", true, true);
            if (file == null) continue;
            try {
                loader.load(file);
            }
            catch (IOException ex) {
                throw new MojoExecutionException(String.format("Failed to load exec file %s: %s", file, ex.getMessage()), (Exception)ex);
            }
        }
        CoverageBuilder builder = new CoverageBuilder();
        Analyzer analyzer = new Analyzer(loader.getExecutionDataStore(), (ICoverageVisitor)builder);
        for (Artifact baseArtifact : this.getArtifactsInScope("compile")) {
            this.jarUnArchiver.setSourceFile(this.resolveArtifact(baseArtifact, "sources", "jar", false, false));
            this.jarUnArchiver.setDestDirectory(sourcesDirectory);
            this.jarUnArchiver.extract();
            try {
                analyzer.analyzeAll(baseArtifact.getFile());
            }
            catch (IOException ex) {
                throw new MojoExecutionException(String.format("Failed to analyze %s: %s", baseArtifact.getFile(), ex.getMessage()), (Exception)ex);
            }
        }
        IBundleCoverage bundle = builder.getBundle("Coverage Report");
        HTMLFormatter htmlFormatter = new HTMLFormatter();
        htmlFormatter.setOutputEncoding("utf-8");
        htmlFormatter.setLocale(Locale.ENGLISH);
        try {
            IReportVisitor visitor = htmlFormatter.createVisitor((IMultiReportOutput)new FileMultiReportOutput(this.outputDirectory));
            visitor.visitInfo(AggregateReportMojo.anonymize(loader.getSessionInfoStore().getInfos()), loader.getExecutionDataStore().getContents());
            visitor.visitBundle(bundle, (ISourceFileLocator)new DirectorySourceFileLocator(sourcesDirectory, "utf-8", 4));
            visitor.visitEnd();
        }
        catch (IOException ex) {
            throw new MojoExecutionException(String.format("Failed to generate coverage report: %s", ex.getMessage()), (Exception)ex);
        }
    }
}

