/*
 * Decompiled with CFR 0.152.
 */
package com.github.veithen.phos.jacoco;

import java.io.File;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.installer.ArtifactInstallationException;
import org.apache.maven.artifact.installer.ArtifactInstaller;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="install-data-file", defaultPhase=LifecyclePhase.INSTALL)
public class InstallDataFileMojo
extends AbstractMojo {
    @Parameter(property="project", required=true, readonly=true)
    private MavenProject project;
    @Parameter(property="localRepository", required=true, readonly=true)
    private ArtifactRepository localRepository;
    @Component
    private ArtifactFactory artifactFactory;
    @Component
    private ArtifactInstaller installer;
    @Parameter(defaultValue="${project.build.directory}/jacoco.exec", required=true)
    private File dataFile;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.dataFile.exists()) {
            Artifact artifact = this.artifactFactory.createArtifactWithClassifier(this.project.getGroupId(), this.project.getArtifactId(), this.project.getVersion(), "exec", "jacoco");
            try {
                this.installer.install(this.dataFile, artifact, this.localRepository);
            }
            catch (ArtifactInstallationException ex) {
                throw new MojoExecutionException(String.format("Error installing artifact '%s': %s", artifact.getDependencyConflictId(), ex.getMessage()), (Exception)((Object)ex));
            }
        }
    }
}

