/*
 * Decompiled with CFR 0.152.
 */
package com.github.veqryn.collect;

import com.github.veqryn.collect.KeyCodec;
import com.github.veqryn.collect.Trie;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.BitSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class AbstractBinaryTrie<K, V>
implements Trie<K, V>,
Serializable,
Cloneable {
    private static final long serialVersionUID = -6697831108554350305L;
    protected final KeyCodec<K> codec;
    protected transient Node<K, V> root = new Node(null);
    protected transient long size = 0L;
    protected transient int modCount = 0;
    protected transient Set<Map.Entry<K, V>> entrySet = null;
    protected transient Set<K> keySet = null;
    protected transient Collection<V> values = null;

    public AbstractBinaryTrie(KeyCodec<K> keyCodec) {
        if (keyCodec == null) {
            throw new NullPointerException("KeyCodec may not be null");
        }
        this.codec = keyCodec;
    }

    public AbstractBinaryTrie(KeyCodec<K> keyCodec, Map<K, V> otherMap) {
        this(keyCodec);
        this.putAll(otherMap);
    }

    public AbstractBinaryTrie(AbstractBinaryTrie<K, V> otherTrie) {
        this(otherTrie.codec);
        this.buildFromExisting(otherTrie);
    }

    protected static final <K, V> K resolveKey(Node<K, V> node, AbstractBinaryTrie<K, V> trie) {
        Node<K, V> resolved = AbstractBinaryTrie.resolveNode(node, trie);
        return (K)(resolved == null ? null : ((Node)resolved).privateKey);
    }

    protected static final <K, V> Node<K, V> resolveNode(Node<K, V> node, AbstractBinaryTrie<K, V> trie) {
        if (node == null || node.parent == null) {
            return null;
        }
        if (((Node)node).privateKey != null || node.value == null) {
            return node;
        }
        CodecElements elements = node.getCodecElements();
        KeyCodec<K> codec = trie.codec;
        K key = codec.recreateKey(elements.bits, elements.levelsDeep);
        if (key == null) {
            throw new IllegalStateException("Unable to create non-null key with key-codec: " + codec);
        }
        assert (AbstractBinaryTrie.getNode(key, trie.root, 0, codec) == node) : "Created key must equal original key";
        ((Node)node).privateKey = key;
        return node;
    }

    protected static final <K, V> Map.Entry<K, V> exportEntry(Node<K, V> node, AbstractBinaryTrie<K, V> trie) {
        if (node == null || node.value == null) {
            return null;
        }
        return new TrieEntry<K, V>(node, trie);
    }

    protected static final boolean eq(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1 == o2 || o1.equals(o2);
    }

    public KeyCodec<K> getCodec() {
        return this.codec;
    }

    @Override
    public void clear() {
        this.root.value = null;
        this.root.left = null;
        this.root.right = null;
        this.size = 0L;
        ++this.modCount;
    }

    @Override
    public boolean isEmpty() {
        return this.root.isEmpty();
    }

    @Override
    public int size() {
        return this.size > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)this.size;
    }

    public AbstractBinaryTrie<K, V> clone() {
        return new AbstractBinaryTrie<K, V>(this);
    }

    protected void buildFromExisting(AbstractBinaryTrie<K, V> otherTrie) {
        Node<K, V> myNode = this.root;
        Node<K, V> otherNode = otherTrie.root;
        block0: while (otherNode != null) {
            if (otherNode.left != null) {
                otherNode = otherNode.left;
                myNode = myNode.getOrCreateEmpty(true);
                myNode.value = otherNode.value;
                continue;
            }
            if (otherNode.right != null) {
                otherNode = otherNode.right;
                myNode = myNode.getOrCreateEmpty(false);
                myNode.value = otherNode.value;
                continue;
            }
            while (otherNode.parent != null) {
                if (otherNode == otherNode.parent.left && otherNode.parent.right != null) {
                    otherNode = otherNode.parent.right;
                    myNode = myNode.parent.getOrCreateEmpty(false);
                    myNode.value = otherNode.value;
                    continue block0;
                }
                otherNode = otherNode.parent;
                myNode = myNode.parent;
            }
            break block0;
        }
        this.size = otherTrie.size;
        ++this.modCount;
    }

    @Override
    public V put(K key, V value) throws ClassCastException, NullPointerException, IllegalArgumentException {
        if (key == null) {
            throw new NullPointerException(this.getClass().getName() + " does not accept null keys: " + key);
        }
        if (value == null) {
            throw new NullPointerException(this.getClass().getName() + " does not accept null values: " + value);
        }
        int stopDepth = this.codec.length(key);
        if (stopDepth <= 0) {
            throw new IllegalArgumentException(this.getClass().getName() + " does not accept keys of length <= 0: " + key);
        }
        Node<K, V> subNode = this.root;
        int i = 0;
        do {
            subNode = subNode.getOrCreateEmpty(this.codec.isLeft(key, i++));
        } while (i != stopDepth);
        if (subNode.value == null) {
            ++this.size;
        }
        if (((Node)subNode).privateKey != null) {
            ((Node)subNode).privateKey = key;
        }
        ++this.modCount;
        return subNode.setValue(value);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) throws ClassCastException, NullPointerException, IllegalArgumentException {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public V remove(Object key) throws ClassCastException, NullPointerException {
        if (key == null) {
            throw new NullPointerException(this.getClass().getName() + " does not accept null keys: " + key);
        }
        Node<Object, V> p = this.getNode(key);
        if (p == null) {
            return null;
        }
        Object oldValue = p.value;
        this.deleteNode(p);
        return oldValue;
    }

    protected void deleteNode(Node<K, V> node) {
        if (node == null || node.value == null) {
            return;
        }
        --this.size;
        ++this.modCount;
        node.value = null;
        ((Node)node).privateKey = null;
        while (node.isEmpty() && node.parent != null) {
            if (node.parent.left == node) {
                node.parent.left = null;
            } else {
                node.parent.right = null;
            }
            node = node.parent;
        }
    }

    @Override
    public boolean containsValue(Object value) throws ClassCastException, NullPointerException {
        if (value == null) {
            throw new NullPointerException(this.getClass().getName() + " does not allow null values: " + value);
        }
        Node<K, V> e = this.firstNode();
        while (e != null) {
            if (AbstractBinaryTrie.eq(value, e.value)) {
                return true;
            }
            e = AbstractBinaryTrie.successor(e);
        }
        return false;
    }

    @Override
    public boolean containsKey(Object key) throws ClassCastException, NullPointerException {
        if (key == null) {
            throw new NullPointerException(this.getClass().getName() + " does not allow null keys: " + key);
        }
        return this.getNode(key) != null;
    }

    @Override
    public V get(Object key) throws ClassCastException, NullPointerException {
        if (key == null) {
            throw new NullPointerException(this.getClass().getName() + " does not accept null keys: " + key);
        }
        Node<Object, V> node = this.getNode(key);
        return node == null ? null : (V)node.value;
    }

    protected Node<K, V> getNode(K key) {
        return AbstractBinaryTrie.getNode(key, this.root, 0, this.codec);
    }

    protected static <K, V> Node<K, V> getNode(K key, Node<K, V> startingNode, int startingIndex, KeyCodec<K> codec) {
        if (key == null) {
            return null;
        }
        int stopDepth = codec.length(key);
        if (stopDepth <= 0) {
            throw new IllegalArgumentException(AbstractBinaryTrie.class.getClass().getName() + " does not accept keys of length <= 0: " + key);
        }
        Node<K, V> subNode = startingNode;
        do {
            if ((subNode = codec.isLeft(key, startingIndex++) ? subNode.left : subNode.right) == null) {
                return null;
            }
            if (startingIndex != stopDepth || subNode.value == null) continue;
            return subNode;
        } while (startingIndex < stopDepth);
        return null;
    }

    protected Node<K, V> firstNode() {
        return AbstractBinaryTrie.successor(this.root);
    }

    protected static <K, V> Node<K, V> successor(Node<K, V> node) {
        return AbstractBinaryTrie.successor(node, null);
    }

    protected static <K, V> Node<K, V> successor(Node<K, V> node, Node<K, V> parentFence) {
        Node limit;
        Node node2 = limit = parentFence == null ? null : parentFence.parent;
        block0: while (node != null) {
            if (node.left != null) {
                if (node.left.value == null) {
                    node = node.left;
                    continue;
                }
                return node.left;
            }
            if (node.right != null) {
                if (node.right.value == null) {
                    node = node.right;
                    continue;
                }
                return node.right;
            }
            while (node.parent != null && node.parent != limit) {
                if (node == node.parent.left && node.parent.right != null) {
                    if (node.parent.right.value == null) {
                        node = node.parent.right;
                        continue block0;
                    }
                    return node.parent.right;
                }
                node = node.parent;
            }
            return null;
        }
        return null;
    }

    protected Node<K, V> lastNode() {
        Node<K, V> parent = this.root;
        while (parent.right != null || parent.left != null) {
            if (parent.right != null) {
                parent = parent.right;
                continue;
            }
            parent = parent.left;
        }
        return parent == this.root ? null : parent;
    }

    protected static <K, V> Node<K, V> predecessor(Node<K, V> node) {
        return AbstractBinaryTrie.predecessor(node, null);
    }

    protected static <K, V> Node<K, V> predecessor(Node<K, V> node, Node<K, V> parentFence) {
        Node limit;
        Node node2 = limit = parentFence == null ? null : parentFence.parent;
        while (node != null && node.parent != null && node.parent != limit) {
            if (node == node.parent.left || node.parent.left == null) {
                if (node.parent.value == null) {
                    node = node.parent;
                    continue;
                }
                return node.parent;
            }
            node = node.parent.left;
            while (node.right != null || node.left != null) {
                if (node.right != null) {
                    node = node.right;
                    continue;
                }
                node = node.left;
            }
            if (node.value == null) {
                throw new IllegalStateException("Should not have a leaf node with no value");
            }
            return node;
        }
        return null;
    }

    @Override
    public V shortestPrefixOfValue(K key, boolean keyInclusive) {
        Iterator<V> iter = this.prefixOfValues(key, keyInclusive).iterator();
        return iter.hasNext() ? (V)iter.next() : null;
    }

    @Override
    public V longestPrefixOfValue(K key, boolean keyInclusive) {
        Iterator<V> iter = this.prefixOfValues(key, keyInclusive).iterator();
        V value = null;
        while (iter.hasNext()) {
            value = iter.next();
        }
        return value;
    }

    @Override
    public Collection<V> prefixOfValues(K key, boolean keyInclusive) {
        return this.prefixValues(key, true, keyInclusive, false);
    }

    @Override
    public Collection<V> prefixedByValues(K key, boolean keyInclusive) {
        return this.prefixValues(key, false, keyInclusive, true);
    }

    protected Collection<V> prefixValues(K key, boolean includePrefixOf, boolean keyInclusive, boolean includePrefixedBy) {
        if (key == null) {
            throw new NullPointerException(this.getClass().getName() + " does not accept null keys: " + key);
        }
        if (this.codec.length(key) <= 0) {
            throw new IllegalArgumentException(this.getClass().getName() + " does not accept keys of length <= 0: " + key);
        }
        if (includePrefixOf) {
            return new TriePrefixValues(this, null, false, key, keyInclusive);
        }
        return new TriePrefixValues(this, key, keyInclusive, null, false);
    }

    @Override
    public Trie<K, V> prefixOfMap(K key, boolean keyInclusive) {
        return this.prefixMap(key, true, keyInclusive, false);
    }

    @Override
    public Trie<K, V> prefixedByMap(K key, boolean keyInclusive) {
        return this.prefixMap(key, false, keyInclusive, true);
    }

    protected Trie<K, V> prefixMap(K key, boolean includePrefixOf, boolean keyInclusive, boolean includePrefixedBy) {
        if (key == null) {
            throw new NullPointerException(this.getClass().getName() + " does not accept null keys: " + key);
        }
        if (this.codec.length(key) <= 0) {
            throw new IllegalArgumentException(this.getClass().getName() + " does not accept keys of length <= 0: " + key);
        }
        if (includePrefixOf) {
            return new TriePrefixMap(this, null, false, key, keyInclusive);
        }
        return new TriePrefixMap(this, key, keyInclusive, null, false);
    }

    protected static <K> boolean isPrefix(K prefix, K key, boolean includePrefixOfKey, boolean keyInclusive, boolean includePrefixedByKey, KeyCodec<K> codec) {
        if (prefix == null || key == null) {
            return false;
        }
        if (keyInclusive && (prefix == key || prefix.equals(key))) {
            return true;
        }
        int prefixDepth = codec.length(prefix);
        int keyDepth = codec.length(key);
        if (!includePrefixOfKey && keyDepth < prefixDepth || !keyInclusive && keyDepth == prefixDepth || !includePrefixedByKey && keyDepth > prefixDepth) {
            return false;
        }
        int minDepth = Math.min(prefixDepth, keyDepth);
        for (int i = 0; i < minDepth; ++i) {
            if (codec.isLeft(prefix, i) == codec.isLeft(key, i)) continue;
            return false;
        }
        return true;
    }

    protected final Iterator<K> keyIterator() {
        return new KeyIterator(this);
    }

    @Override
    public Set<K> keySet() {
        Set<K> ks = this.keySet;
        return ks != null ? ks : (this.keySet = new TrieKeySet(this));
    }

    @Override
    public Collection<V> values() {
        Collection<V> vs = this.values;
        return vs != null ? vs : (this.values = new TrieValues(this));
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        TrieEntrySet es = this.entrySet;
        return es != null ? es : (this.entrySet = new TrieEntrySet());
    }

    @Override
    public int hashCode() {
        int h = 0;
        Node<K, V> node = this.firstNode();
        while (node != null) {
            Object value = node.value;
            K key = AbstractBinaryTrie.resolveKey(node, this);
            h += (key == null ? 0 : key.hashCode()) ^ (value == null ? 0 : value.hashCode());
            node = AbstractBinaryTrie.successor(node);
        }
        return h;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof AbstractBinaryTrie) {
            AbstractBinaryTrie t = (AbstractBinaryTrie)o;
            if (t.size() != this.size()) {
                return false;
            }
            return AbstractBinaryTrie.compareAllNodes(this.root, t.root);
        }
        if (o instanceof Map) {
            Map m = (Map)o;
            if (m.size() != this.size()) {
                return false;
            }
            try {
                Node<K, V> node = this.firstNode();
                while (node != null) {
                    Object value = node.value;
                    K key = AbstractBinaryTrie.resolveKey(node, this);
                    if (value == null ? m.get(key) != null || !m.containsKey(key) : !value.equals(m.get(key))) {
                        return false;
                    }
                    node = AbstractBinaryTrie.successor(node);
                }
            }
            catch (ClassCastException unused) {
                return false;
            }
            catch (NullPointerException unused) {
                return false;
            }
            return true;
        }
        return false;
    }

    protected static final <K, V> boolean compareNodeAndExistenceOfChildren(Node<K, V> myNode, Node<K, V> otherNode) {
        if (myNode == null && otherNode == null) {
            return true;
        }
        if (myNode == null && otherNode != null || myNode != null && otherNode == null) {
            return false;
        }
        if (myNode.left == null && otherNode.left != null || myNode.left != null && otherNode.left == null) {
            return false;
        }
        if (myNode.right == null && otherNode.right != null || myNode.right != null && otherNode.right == null) {
            return false;
        }
        return AbstractBinaryTrie.eq(myNode.value, otherNode.value);
    }

    protected static final <K, V> boolean compareAllNodes(Node<K, V> myNode, Node<K, V> otherNode) {
        block0: while (otherNode != null) {
            if (otherNode.left != null) {
                myNode = myNode.left;
                otherNode = otherNode.left;
                if (AbstractBinaryTrie.compareNodeAndExistenceOfChildren(myNode, otherNode)) continue;
                return false;
            }
            if (otherNode.right != null) {
                myNode = myNode.right;
                otherNode = otherNode.right;
                if (AbstractBinaryTrie.compareNodeAndExistenceOfChildren(myNode, otherNode)) continue;
                return false;
            }
            while (otherNode.parent != null) {
                if (otherNode == otherNode.parent.left && otherNode.parent.right != null) {
                    myNode = myNode.parent.right;
                    otherNode = otherNode.parent.right;
                    if (AbstractBinaryTrie.compareNodeAndExistenceOfChildren(myNode, otherNode)) continue block0;
                    return false;
                }
                otherNode = otherNode.parent;
                myNode = myNode.parent;
            }
            break block0;
        }
        return AbstractBinaryTrie.compareNodeAndExistenceOfChildren(myNode, otherNode);
    }

    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        Node<K, V> node = this.firstNode();
        while (node != null) {
            Object value = node.value;
            K key = AbstractBinaryTrie.resolveKey(node, this);
            sb.append((Object)(key == this ? "(this Map)" : key));
            sb.append('=');
            sb.append((Object)(value == this ? "(this Map)" : value));
            node = AbstractBinaryTrie.successor(node);
            if (node == null) break;
            sb.append(',').append(' ');
        }
        return sb.append('}').toString();
    }

    private final void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeLong(this.size);
        Node<K, V> node = this.firstNode();
        while (node != null) {
            s.writeObject(AbstractBinaryTrie.resolveKey(node, this));
            s.writeObject(node.value);
            node = AbstractBinaryTrie.successor(node);
        }
    }

    private final void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        long originalSize = s.readLong();
        this.root = new Node(null);
        int i = 0;
        while ((long)i < originalSize) {
            Object key = s.readObject();
            Object value = s.readObject();
            this.put(key, value);
            ++i;
        }
        assert (this.size == originalSize);
    }

    protected final class TrieEntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        protected TrieEntrySet() {
        }

        @Override
        public final Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator(AbstractBinaryTrie.this);
        }

        @Override
        public final boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)o;
            Object value = entry.getValue();
            Node p = AbstractBinaryTrie.this.getNode(entry.getKey());
            return p != null && AbstractBinaryTrie.eq(p.value, value);
        }

        @Override
        public final boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)o;
            Object value = entry.getValue();
            Node p = AbstractBinaryTrie.this.getNode(entry.getKey());
            if (p != null && AbstractBinaryTrie.eq(p.value, value)) {
                AbstractBinaryTrie.this.deleteNode(p);
                return true;
            }
            return false;
        }

        @Override
        public final int size() {
            return AbstractBinaryTrie.this.size();
        }

        @Override
        public final void clear() {
            AbstractBinaryTrie.this.clear();
        }
    }

    protected static final class TrieValues<K, V>
    extends AbstractCollection<V> {
        protected final AbstractBinaryTrie<K, V> m;

        protected TrieValues(AbstractBinaryTrie<K, V> map) {
            this.m = map;
        }

        @Override
        public final Iterator<V> iterator() {
            return new ValueIterator<K, V>(this.m);
        }

        @Override
        public final int size() {
            return this.m.size();
        }

        @Override
        public final boolean isEmpty() {
            return this.m.isEmpty();
        }

        @Override
        public final boolean contains(Object o) {
            return this.m.containsValue(o);
        }

        @Override
        public final boolean remove(Object o) {
            Node<K, V> e = this.m.firstNode();
            while (e != null) {
                if (AbstractBinaryTrie.eq(e.value, o)) {
                    this.m.deleteNode(e);
                    return true;
                }
                e = AbstractBinaryTrie.successor(e);
            }
            return false;
        }

        @Override
        public final void clear() {
            this.m.clear();
        }
    }

    protected static final class TrieKeySet<K>
    extends AbstractSet<K>
    implements Set<K> {
        protected final AbstractBinaryTrie<K, ? extends Object> m;

        protected TrieKeySet(AbstractBinaryTrie<K, ? extends Object> map) {
            this.m = map;
        }

        @Override
        public final Iterator<K> iterator() {
            return this.m.keyIterator();
        }

        @Override
        public final int size() {
            return this.m.size();
        }

        @Override
        public final boolean isEmpty() {
            return this.m.isEmpty();
        }

        @Override
        public final boolean contains(Object o) {
            return this.m.containsKey(o);
        }

        @Override
        public final void clear() {
            this.m.clear();
        }

        @Override
        public final boolean remove(Object o) {
            return this.m.remove(o) != null;
        }
    }

    protected static abstract class AbstractNodeIterator<K, V, T>
    implements Iterator<T> {
        protected final AbstractBinaryTrie<K, V> m;
        protected Node<K, V> next;
        protected Node<K, V> lastReturned;
        protected int expectedModCount;

        protected AbstractNodeIterator(AbstractBinaryTrie<K, V> map, Node<K, V> first) {
            this.m = map;
            this.expectedModCount = this.m.modCount;
            this.lastReturned = null;
            this.next = first;
        }

        @Override
        public final boolean hasNext() {
            return this.next != null;
        }

        protected final Node<K, V> nextNode() {
            Node<K, V> e = this.next;
            if (e == null) {
                throw new NoSuchElementException();
            }
            if (this.m.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            this.next = AbstractBinaryTrie.successor(e);
            this.lastReturned = e;
            return e;
        }

        @Override
        public final void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            if (this.m.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            this.m.deleteNode(this.lastReturned);
            this.expectedModCount = this.m.modCount;
            this.lastReturned = null;
        }
    }

    protected static final class KeyIterator<K, V>
    extends AbstractNodeIterator<K, V, K> {
        protected KeyIterator(AbstractBinaryTrie<K, V> map) {
            super(map, map.firstNode());
        }

        @Override
        public final K next() {
            return AbstractBinaryTrie.resolveKey(this.nextNode(), this.m);
        }
    }

    protected static final class ValueIterator<K, V>
    extends AbstractNodeIterator<K, V, V> {
        protected ValueIterator(AbstractBinaryTrie<K, V> map) {
            super(map, map.firstNode());
        }

        @Override
        public final V next() {
            return this.nextNode().value;
        }
    }

    protected static final class EntryIterator<K, V>
    extends AbstractNodeIterator<K, V, Map.Entry<K, V>> {
        protected EntryIterator(AbstractBinaryTrie<K, V> map) {
            super(map, map.firstNode());
        }

        @Override
        public final Map.Entry<K, V> next() {
            return AbstractBinaryTrie.exportEntry(this.nextNode(), this.m);
        }
    }

    protected static class TriePrefixMap<K, V>
    extends AbstractMap<K, V>
    implements Trie<K, V>,
    Serializable {
        private static final long serialVersionUID = 2656477599768768535L;
        protected final AbstractBinaryTrie<K, V> trie;
        protected final K mustBePrefixedBy;
        protected final boolean mustBePrefixedByInclusive;
        protected final K mustBePrefixOf;
        protected final boolean mustBePrefixOfInclusive;
        private transient long size = -1L;
        private transient int sizeModCount = -1;
        protected transient Set<Map.Entry<K, V>> entrySet = null;
        protected transient Set<K> keySet = null;
        protected transient Collection<V> values = null;

        protected TriePrefixMap(AbstractBinaryTrie<K, V> trie, K mustBePrefixedBy, boolean mustBePrefixedByInclusive, K mustBePrefixOf, boolean mustBePrefixOfInclusive) {
            this.trie = trie;
            this.mustBePrefixedBy = mustBePrefixedBy;
            this.mustBePrefixedByInclusive = mustBePrefixedByInclusive;
            this.mustBePrefixOf = mustBePrefixOf;
            this.mustBePrefixOfInclusive = mustBePrefixOfInclusive;
        }

        @Override
        public final int size() {
            if (this.size == -1L || this.sizeModCount != this.trie.modCount) {
                this.sizeModCount = this.trie.modCount;
                this.size = 0L;
                Iterator<Map.Entry<K, V>> i = this.entrySet().iterator();
                while (i.hasNext()) {
                    ++this.size;
                    i.next();
                }
            }
            return this.size > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)this.size;
        }

        @Override
        public final boolean isEmpty() {
            return !this.entrySet().iterator().hasNext();
        }

        @Override
        public V put(K key, V value) throws ClassCastException, NullPointerException, IllegalArgumentException {
            if (key == null) {
                throw new NullPointerException(this.getClass().getName() + " does not accept null keys: " + key);
            }
            if (!this.inRange(key, false)) {
                throw new IllegalArgumentException("key out of range: " + key);
            }
            return this.trie.put(key, value);
        }

        @Override
        public V remove(Object key) throws ClassCastException, NullPointerException {
            if (key == null) {
                throw new NullPointerException(this.getClass().getName() + " does not accept null keys: " + key);
            }
            if (!this.inRange(key, false)) {
                return null;
            }
            return this.trie.remove(key);
        }

        @Override
        public boolean containsKey(Object key) {
            return this.get(key) != null;
        }

        @Override
        public V get(Object key) {
            if (key == null) {
                throw new NullPointerException(this.getClass().getName() + " does not allow null keys: " + key);
            }
            if (!this.inRange(key, false)) {
                return null;
            }
            return this.trie.get(key);
        }

        @Override
        public V shortestPrefixOfValue(K key, boolean keyInclusive) {
            Iterator<V> iter = this.prefixOfValues(key, keyInclusive).iterator();
            return iter.hasNext() ? (V)iter.next() : null;
        }

        @Override
        public V longestPrefixOfValue(K key, boolean keyInclusive) {
            Iterator<V> iter = this.prefixOfValues(key, keyInclusive).iterator();
            V value = null;
            while (iter.hasNext()) {
                value = iter.next();
            }
            return value;
        }

        @Override
        public Collection<V> prefixOfValues(K key, boolean keyInclusive) {
            return this.prefixValues(key, true, keyInclusive, false);
        }

        @Override
        public Collection<V> prefixedByValues(K key, boolean keyInclusive) {
            return this.prefixValues(key, false, keyInclusive, true);
        }

        protected Collection<V> prefixValues(K key, boolean includePrefixOf, boolean keyInclusive, boolean includePrefixedBy) {
            this.checkKeyValidAndInRange(key, !keyInclusive);
            if (includePrefixOf) {
                return new TriePrefixValues<K, V>(this.trie, this.mustBePrefixedBy, this.mustBePrefixedByInclusive, key, keyInclusive);
            }
            return new TriePrefixValues<K, V>(this.trie, key, keyInclusive, this.mustBePrefixOf, this.mustBePrefixOfInclusive);
        }

        @Override
        public Trie<K, V> prefixOfMap(K key, boolean keyInclusive) {
            return this.prefixMap(key, true, keyInclusive, false);
        }

        @Override
        public Trie<K, V> prefixedByMap(K key, boolean keyInclusive) {
            return this.prefixMap(key, false, keyInclusive, true);
        }

        protected Trie<K, V> prefixMap(K key, boolean includePrefixOf, boolean keyInclusive, boolean includePrefixedBy) {
            this.checkKeyValidAndInRange(key, !keyInclusive);
            if (includePrefixOf) {
                return new TriePrefixMap<K, V>(this.trie, this.mustBePrefixedBy, this.mustBePrefixedByInclusive, key, keyInclusive);
            }
            return new TriePrefixMap<K, V>(this.trie, key, keyInclusive, this.mustBePrefixOf, this.mustBePrefixOfInclusive);
        }

        protected boolean inRange(K key, boolean forceInclusive) {
            if (this.mustBePrefixOf != null && !AbstractBinaryTrie.isPrefix(this.mustBePrefixOf, key, true, this.mustBePrefixOfInclusive || forceInclusive, false, this.trie.codec)) {
                return false;
            }
            return this.mustBePrefixedBy == null || AbstractBinaryTrie.isPrefix(this.mustBePrefixedBy, key, false, this.mustBePrefixedByInclusive || forceInclusive, true, this.trie.codec);
        }

        protected void checkKeyValidAndInRange(K key, boolean forceInclusive) {
            if (key == null) {
                throw new NullPointerException(this.getClass().getName() + " does not accept null keys: " + key);
            }
            if (this.trie.codec.length(key) <= 0) {
                throw new IllegalArgumentException(this.getClass().getName() + " does not accept keys of length <= 0: " + key);
            }
            if (!this.inRange(key, forceInclusive)) {
                throw new IllegalArgumentException("key out of range: " + key);
            }
        }

        @Override
        public Set<K> keySet() {
            Set<K> ks = this.keySet;
            return ks != null ? ks : (this.keySet = new TriePrefixKeySet<K, V>(this.trie, this.mustBePrefixedBy, this.mustBePrefixedByInclusive, this.mustBePrefixOf, this.mustBePrefixOfInclusive));
        }

        @Override
        public Collection<V> values() {
            Collection<V> vs = this.values;
            return vs != null ? vs : (this.values = new TriePrefixValues<K, V>(this.trie, this.mustBePrefixedBy, this.mustBePrefixedByInclusive, this.mustBePrefixOf, this.mustBePrefixOfInclusive));
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            Set<Map.Entry<K, V>> es = this.entrySet;
            return es != null ? es : (this.entrySet = new TriePrefixEntrySet<K, V>(this.trie, this.mustBePrefixedBy, this.mustBePrefixedByInclusive, this.mustBePrefixOf, this.mustBePrefixOfInclusive));
        }
    }

    protected static class TriePrefixEntrySet<K, V>
    extends AbstractSet<Map.Entry<K, V>> {
        protected final AbstractBinaryTrie<K, V> trie;
        private transient long size = -1L;
        private transient int sizeModCount = -1;
        protected final K mustBePrefixedBy;
        protected final boolean mustBePrefixedByInclusive;
        protected final K mustBePrefixOf;
        protected final boolean mustBePrefixOfInclusive;

        protected TriePrefixEntrySet(AbstractBinaryTrie<K, V> trie, K mustBePrefixedBy, boolean mustBePrefixedByInclusive, K mustBePrefixOf, boolean mustBePrefixOfInclusive) {
            this.trie = trie;
            this.mustBePrefixedBy = mustBePrefixedBy;
            this.mustBePrefixedByInclusive = mustBePrefixedByInclusive;
            this.mustBePrefixOf = mustBePrefixOf;
            this.mustBePrefixOfInclusive = mustBePrefixOfInclusive;
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryPrefixIterator<K, V>(this.trie, this.mustBePrefixedBy, this.mustBePrefixedByInclusive, this.mustBePrefixOf, this.mustBePrefixOfInclusive);
        }

        @Override
        public final int size() {
            if (this.size == -1L || this.sizeModCount != this.trie.modCount) {
                this.sizeModCount = this.trie.modCount;
                this.size = 0L;
                Iterator<Map.Entry<K, V>> i = this.iterator();
                while (i.hasNext()) {
                    ++this.size;
                    i.next();
                }
            }
            return this.size > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)this.size;
        }

        @Override
        public final boolean isEmpty() {
            return !this.iterator().hasNext();
        }

        protected boolean inRange(K key) {
            if (this.mustBePrefixOf != null && !AbstractBinaryTrie.isPrefix(this.mustBePrefixOf, key, true, this.mustBePrefixOfInclusive, false, this.trie.codec)) {
                return false;
            }
            return this.mustBePrefixedBy == null || AbstractBinaryTrie.isPrefix(this.mustBePrefixedBy, key, false, this.mustBePrefixedByInclusive, true, this.trie.codec);
        }

        @Override
        public final boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)o;
            Object key = entry.getKey();
            if (key == null) {
                throw new NullPointerException(this.getClass().getName() + " does not accept null keys: " + key);
            }
            if (!this.inRange(key)) {
                return false;
            }
            Node<K, V> node = this.trie.getNode(key);
            return node != null && AbstractBinaryTrie.eq(node.value, entry.getValue());
        }

        @Override
        public final boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)o;
            Object key = entry.getKey();
            if (key == null) {
                throw new NullPointerException(this.getClass().getName() + " does not accept null keys: " + key);
            }
            if (!this.inRange(key)) {
                return false;
            }
            Node<K, V> node = this.trie.getNode(key);
            if (node != null && AbstractBinaryTrie.eq(node.value, entry.getValue())) {
                this.trie.deleteNode(node);
                return true;
            }
            return false;
        }
    }

    protected static class TriePrefixValues<K, V>
    extends AbstractCollection<V> {
        protected final AbstractBinaryTrie<K, V> trie;
        private transient long size = -1L;
        private transient int sizeModCount = -1;
        protected final K mustBePrefixedBy;
        protected final boolean mustBePrefixedByInclusive;
        protected final K mustBePrefixOf;
        protected final boolean mustBePrefixOfInclusive;

        protected TriePrefixValues(AbstractBinaryTrie<K, V> trie, K mustBePrefixedBy, boolean mustBePrefixedByInclusive, K mustBePrefixOf, boolean mustBePrefixOfInclusive) {
            this.trie = trie;
            this.mustBePrefixedBy = mustBePrefixedBy;
            this.mustBePrefixedByInclusive = mustBePrefixedByInclusive;
            this.mustBePrefixOf = mustBePrefixOf;
            this.mustBePrefixOfInclusive = mustBePrefixOfInclusive;
        }

        @Override
        public Iterator<V> iterator() {
            return new ValuePrefixIterator<K, V>(this.trie, this.mustBePrefixedBy, this.mustBePrefixedByInclusive, this.mustBePrefixOf, this.mustBePrefixOfInclusive);
        }

        @Override
        public final int size() {
            if (this.size == -1L || this.sizeModCount != this.trie.modCount) {
                this.sizeModCount = this.trie.modCount;
                this.size = 0L;
                Iterator<V> i = this.iterator();
                while (i.hasNext()) {
                    ++this.size;
                    i.next();
                }
            }
            return this.size > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)this.size;
        }

        @Override
        public final boolean isEmpty() {
            return !this.iterator().hasNext();
        }

        @Override
        public boolean remove(Object o) {
            Node node = null;
            NodePrefixIterator<K, V> iter = new NodePrefixIterator<K, V>(this.trie, this.mustBePrefixedBy, this.mustBePrefixedByInclusive, this.mustBePrefixOf, this.mustBePrefixOfInclusive);
            while (iter.hasNext()) {
                node = (Node)iter.next();
                if (!AbstractBinaryTrie.eq(node.value, o)) continue;
                iter.remove();
                return true;
            }
            return false;
        }
    }

    protected static class TriePrefixKeySet<K, V>
    extends AbstractSet<K>
    implements Set<K> {
        protected final AbstractBinaryTrie<K, V> trie;
        private transient long size = -1L;
        private transient int sizeModCount = -1;
        protected final K mustBePrefixedBy;
        protected final boolean mustBePrefixedByInclusive;
        protected final K mustBePrefixOf;
        protected final boolean mustBePrefixOfInclusive;

        protected TriePrefixKeySet(AbstractBinaryTrie<K, V> trie, K mustBePrefixedBy, boolean mustBePrefixedByInclusive, K mustBePrefixOf, boolean mustBePrefixOfInclusive) {
            this.trie = trie;
            this.mustBePrefixedBy = mustBePrefixedBy;
            this.mustBePrefixedByInclusive = mustBePrefixedByInclusive;
            this.mustBePrefixOf = mustBePrefixOf;
            this.mustBePrefixOfInclusive = mustBePrefixOfInclusive;
        }

        @Override
        public Iterator<K> iterator() {
            return new KeyPrefixIterator<K, V>(this.trie, this.mustBePrefixedBy, this.mustBePrefixedByInclusive, this.mustBePrefixOf, this.mustBePrefixOfInclusive);
        }

        @Override
        public final int size() {
            if (this.size == -1L || this.sizeModCount != this.trie.modCount) {
                this.sizeModCount = this.trie.modCount;
                this.size = 0L;
                Iterator<K> i = this.iterator();
                while (i.hasNext()) {
                    ++this.size;
                    i.next();
                }
            }
            return this.size > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)this.size;
        }

        @Override
        public final boolean isEmpty() {
            return !this.iterator().hasNext();
        }

        protected boolean inRange(K key) {
            if (this.mustBePrefixOf != null && !AbstractBinaryTrie.isPrefix(this.mustBePrefixOf, key, true, this.mustBePrefixOfInclusive, false, this.trie.codec)) {
                return false;
            }
            return this.mustBePrefixedBy == null || AbstractBinaryTrie.isPrefix(this.mustBePrefixedBy, key, false, this.mustBePrefixedByInclusive, true, this.trie.codec);
        }

        @Override
        public final boolean contains(Object key) {
            if (key == null) {
                throw new NullPointerException(this.getClass().getName() + " does not accept null keys: " + key);
            }
            if (!this.inRange(key)) {
                return false;
            }
            return this.trie.getNode(key) != null;
        }

        @Override
        public final boolean remove(Object key) {
            if (key == null) {
                throw new NullPointerException(this.getClass().getName() + " does not accept null keys: " + key);
            }
            if (!this.inRange(key)) {
                return false;
            }
            Node<Object, V> node = this.trie.getNode(key);
            if (node != null) {
                this.trie.deleteNode(node);
                return true;
            }
            return false;
        }
    }

    protected static abstract class AbstractPrefixIterator<K, V, T>
    implements Iterator<T> {
        protected final AbstractBinaryTrie<K, V> trie;
        protected int expectedModCount;
        protected Node<K, V> next;
        protected Node<K, V> lastReturned;
        protected int index = 0;
        protected final int prefixDepth;
        protected final int minDepth;
        protected Node<K, V> upperLimitNode = null;
        protected final K mustBePrefixedBy;
        protected final boolean mustBePrefixedByInclusive;
        protected final K mustBePrefixOf;
        protected final boolean mustBePrefixOfInclusive;

        protected AbstractPrefixIterator(AbstractBinaryTrie<K, V> trie, K mustBePrefixedBy, boolean mustBePrefixedByInclusive, K mustBePrefixOf, boolean mustBePrefixOfInclusive, boolean descending) {
            this.trie = trie;
            this.expectedModCount = trie.modCount;
            this.mustBePrefixedBy = mustBePrefixedBy;
            this.mustBePrefixedByInclusive = mustBePrefixedByInclusive;
            this.mustBePrefixOf = mustBePrefixOf;
            this.mustBePrefixOfInclusive = mustBePrefixOfInclusive;
            boolean prefixOf = mustBePrefixOf != null;
            this.prefixDepth = trie.codec.length(prefixOf ? mustBePrefixOf : mustBePrefixedBy);
            this.minDepth = mustBePrefixedBy == null ? 1 : (mustBePrefixedByInclusive ? 0 : 1) + (prefixOf ? trie.codec.length(mustBePrefixedBy) : this.prefixDepth);
            if (this.prefixDepth <= 0) {
                throw new IllegalArgumentException(AbstractBinaryTrie.class.getClass().getName() + " does not accept keys of length <= 0: " + (prefixOf ? mustBePrefixOf : mustBePrefixedBy));
            }
            this.lastReturned = null;
            this.next = this.getNextPrefixNode(trie.root);
            if (descending) {
                while (this.hasNext()) {
                    this.nextNode();
                }
                this.next = this.lastReturned;
                this.lastReturned = null;
            }
        }

        protected Node<K, V> getNextPrefixNode(Node<K, V> node) {
            K prefixKey;
            boolean prefixOf = this.mustBePrefixOf != null;
            K k = prefixKey = prefixOf ? this.mustBePrefixOf : this.mustBePrefixedBy;
            while (node != null) {
                if (prefixOf && !this.mustBePrefixOfInclusive && this.index + 1 == this.prefixDepth || prefixOf && this.index >= this.prefixDepth) {
                    return null;
                }
                if (this.index >= this.prefixDepth) {
                    node = AbstractBinaryTrie.successor(node, this.upperLimitNode);
                    ++this.index;
                } else {
                    node = this.trie.codec.isLeft(prefixKey, this.index++) ? node.left : node.right;
                    if (this.index == this.prefixDepth) {
                        this.upperLimitNode = node;
                    }
                }
                if (node == null) {
                    return null;
                }
                if (node.value == null || this.index < this.minDepth || !this.subInRange(node)) continue;
                return node;
            }
            return null;
        }

        protected boolean subInRange(Node<K, V> node) {
            return true;
        }

        @Override
        public final boolean hasNext() {
            return this.next != null;
        }

        protected final Node<K, V> nextNode() {
            Node<K, V> e = this.next;
            if (e == null) {
                throw new NoSuchElementException();
            }
            if (this.trie.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            this.next = this.getNextPrefixNode(e);
            this.lastReturned = e;
            return e;
        }

        @Override
        public final void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            if (this.trie.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            this.trie.deleteNode(this.lastReturned);
            this.expectedModCount = this.trie.modCount;
            this.lastReturned = null;
        }
    }

    protected static final class NodePrefixIterator<K, V>
    extends AbstractPrefixIterator<K, V, Node<K, V>> {
        protected NodePrefixIterator(AbstractBinaryTrie<K, V> trie, K mustBePrefixedBy, boolean mustBePrefixedByInclusive, K mustBePrefixOf, boolean mustBePrefixOfInclusive) {
            super(trie, mustBePrefixedBy, mustBePrefixedByInclusive, mustBePrefixOf, mustBePrefixOfInclusive, false);
        }

        @Override
        public final Node<K, V> next() {
            return this.nextNode();
        }
    }

    protected static final class EntryPrefixIterator<K, V>
    extends AbstractPrefixIterator<K, V, Map.Entry<K, V>> {
        protected EntryPrefixIterator(AbstractBinaryTrie<K, V> trie, K mustBePrefixedBy, boolean mustBePrefixedByInclusive, K mustBePrefixOf, boolean mustBePrefixOfInclusive) {
            super(trie, mustBePrefixedBy, mustBePrefixedByInclusive, mustBePrefixOf, mustBePrefixOfInclusive, false);
        }

        @Override
        public final Map.Entry<K, V> next() {
            return AbstractBinaryTrie.exportEntry(this.nextNode(), this.trie);
        }
    }

    protected static final class ValuePrefixIterator<K, V>
    extends AbstractPrefixIterator<K, V, V> {
        protected ValuePrefixIterator(AbstractBinaryTrie<K, V> trie, K mustBePrefixedBy, boolean mustBePrefixedByInclusive, K mustBePrefixOf, boolean mustBePrefixOfInclusive) {
            super(trie, mustBePrefixedBy, mustBePrefixedByInclusive, mustBePrefixOf, mustBePrefixOfInclusive, false);
        }

        @Override
        public final V next() {
            return this.nextNode().value;
        }
    }

    protected static final class KeyPrefixIterator<K, V>
    extends AbstractPrefixIterator<K, V, K> {
        protected KeyPrefixIterator(AbstractBinaryTrie<K, V> trie, K mustBePrefixedBy, boolean mustBePrefixedByInclusive, K mustBePrefixOf, boolean mustBePrefixOfInclusive) {
            super(trie, mustBePrefixedBy, mustBePrefixedByInclusive, mustBePrefixOf, mustBePrefixOfInclusive, false);
        }

        @Override
        public final K next() {
            return AbstractBinaryTrie.resolveKey(this.nextNode(), this.trie);
        }
    }

    protected static final class TrieEntry<K, V>
    implements Map.Entry<K, V>,
    Serializable {
        private static final long serialVersionUID = 5057054103095394644L;
        private final AbstractBinaryTrie<K, V> trie;
        private final Node<K, V> node;

        protected TrieEntry(Node<K, V> node, AbstractBinaryTrie<K, V> trie) {
            this.trie = trie;
            this.node = node;
        }

        @Override
        public K getKey() {
            return AbstractBinaryTrie.resolveKey(this.node, this.trie);
        }

        @Override
        public V getValue() {
            return this.node.value;
        }

        @Override
        public V setValue(V value) {
            return this.node.setValue(value);
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return AbstractBinaryTrie.eq(this.getKey(), e.getKey()) && AbstractBinaryTrie.eq(this.getValue(), e.getValue());
        }

        @Override
        public int hashCode() {
            K key = this.getKey();
            V value = this.getValue();
            return (key == null ? 0 : key.hashCode()) ^ (value == null ? 0 : value.hashCode());
        }

        public String toString() {
            return this.getKey() + "=" + this.getValue();
        }
    }

    protected static final class CodecElements
    implements Serializable {
        private static final long serialVersionUID = 361855129249641777L;
        protected final BitSet bits;
        protected final int levelsDeep;

        protected CodecElements(BitSet bits, int levelsDeep) {
            this.bits = bits;
            this.levelsDeep = levelsDeep;
        }

        public final int hashCode() {
            throw new IllegalStateException("CodecElements should not be hashed or compared");
        }

        public final boolean equals(Object obj) {
            throw new IllegalStateException("CodecElements should not be hashed or compared");
        }

        public final String toString() {
            return this.levelsDeep + "/" + this.bits;
        }
    }

    protected static final class Node<K, V>
    implements Serializable {
        private static final long serialVersionUID = -1866950138115794051L;
        private transient K privateKey = null;
        protected V value = null;
        protected Node<K, V> left = null;
        protected Node<K, V> right = null;
        protected final Node<K, V> parent;

        protected Node(Node<K, V> parent) {
            this.parent = parent;
        }

        protected final Node<K, V> getOrCreateEmpty(boolean leftNode) {
            if (leftNode) {
                if (this.left == null) {
                    this.left = new Node<K, V>(this);
                }
                return this.left;
            }
            if (this.right == null) {
                this.right = new Node<K, V>(this);
            }
            return this.right;
        }

        protected final boolean isEmpty() {
            return this.value == null && this.left == null && this.right == null;
        }

        protected final V setValue(V value) {
            V oldValue = this.value;
            this.value = value;
            return oldValue;
        }

        protected final CodecElements getCodecElements() {
            if (this.parent == null) {
                return null;
            }
            BitSet bits = new BitSet();
            int levelsDeep = 0;
            Node<K, V> node = this;
            while (node.parent != null) {
                if (node.parent.right == node) {
                    bits.set(levelsDeep);
                }
                node = node.parent;
                ++levelsDeep;
            }
            return new CodecElements(bits, levelsDeep);
        }

        public final int hashCode() {
            throw new IllegalStateException("Nodes should not be hashed or compared");
        }

        public final boolean equals(Object obj) {
            throw new IllegalStateException("Nodes should not be hashed or compared");
        }

        public final String toString() {
            return (this.privateKey != null ? this.privateKey : this.getCodecElements()) + "=" + this.value;
        }
    }
}

