/*
 * Decompiled with CFR 0.152.
 */
package com.github.veqryn.collect;

import com.github.veqryn.collect.KeyCodec;
import java.io.Serializable;
import java.util.BitSet;
import java.util.Comparator;

public abstract class AbstractKeyCodec<K>
implements KeyCodec<K>,
Serializable {
    private static final long serialVersionUID = -3361215683005193832L;
    protected final Comparator<? super K> comparator = new KeyComparator();

    @Override
    public Comparator<? super K> comparator() {
        return this.comparator;
    }

    public static final byte[] toByteArray(BitSet bits, int numBits) {
        int bitsLength = numBits;
        int maxByteIndex = (bitsLength + 7) / 8 - 1;
        byte[] bytes = new byte[maxByteIndex + 1];
        for (int i = 0; i < bitsLength; ++i) {
            if (!bits.get(i)) continue;
            int n = maxByteIndex - i / 8;
            bytes[n] = (byte)(bytes[n] | 1 << i % 8);
        }
        return bytes;
    }

    public class KeyComparator
    implements Comparator<K>,
    Serializable {
        private static final long serialVersionUID = 695712059554821573L;

        @Override
        public int compare(K o1, K o2) {
            if (o1 == null || o2 == null) {
                throw new NullPointerException("Null keys not allowed");
            }
            if (o1 == o2 || o1.equals(o2)) {
                return 0;
            }
            int l1 = AbstractKeyCodec.this.length(o1);
            int l2 = AbstractKeyCodec.this.length(o2);
            int min = Math.min(l1, l2);
            for (int i = 0; i < min; ++i) {
                boolean left1 = AbstractKeyCodec.this.isLeft(o1, i);
                boolean left2 = AbstractKeyCodec.this.isLeft(o2, i);
                if (left1 && !left2) {
                    return -1;
                }
                if (left1 || !left2) continue;
                return 1;
            }
            return l1 - l2;
        }
    }
}

