/*
 * Decompiled with CFR 0.152.
 */
package com.github.veqryn.collect;

import com.github.veqryn.collect.AbstractBinaryTrie;
import com.github.veqryn.collect.KeyCodec;
import com.github.veqryn.net.Cidr4;
import java.io.Serializable;
import java.util.BitSet;
import java.util.Comparator;
import java.util.Map;

public final class Cidr4Trie<V>
extends AbstractBinaryTrie<Cidr4, V> {
    private static final long serialVersionUID = -8113898642923790939L;

    public Cidr4Trie() {
        super(new Cidr4Codec());
    }

    public Cidr4Trie(Map<Cidr4, V> otherMap) {
        super(new Cidr4Codec(), otherMap);
    }

    public Cidr4Trie(Cidr4Trie<V> otherTrie) {
        super(otherTrie);
    }

    public static final class Cidr4Codec
    implements KeyCodec<Cidr4>,
    Serializable {
        private static final long serialVersionUID = 5349501966718289752L;

        @Override
        public final int length(Cidr4 cidr) {
            return cidr.getMaskBits();
        }

        @Override
        public final boolean isLeft(Cidr4 cidr, int index) {
            return (cidr.getLowBinaryInteger(true) & 1 << 31 - index) == 0;
        }

        @Override
        public final Cidr4 recreateKey(BitSet bits, int numElements) {
            if (bits.length() == 0) {
                return new Cidr4(0, numElements);
            }
            int binary = (int)bits.toLongArray()[0];
            int move = 32 - numElements;
            if (move > 0) {
                binary <<= move;
            }
            return new Cidr4(binary, numElements);
        }

        @Override
        public final Comparator<Cidr4> comparator() {
            return null;
        }
    }
}

