/*
 * Decompiled with CFR 0.152.
 */
package com.github.veqryn.collect;

import com.github.veqryn.collect.AbstractBinaryTrie;
import com.github.veqryn.collect.AbstractKeyCodec;
import com.github.veqryn.collect.KeyCodec;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.BitSet;
import java.util.Map;

public final class PatriciaTrie<V>
extends AbstractBinaryTrie<String, V> {
    private static final long serialVersionUID = -6067883352977753038L;

    public PatriciaTrie() {
        super(new PatriciaCodec());
    }

    public PatriciaTrie(Map<String, V> otherMap) {
        super(new PatriciaCodec(), otherMap);
    }

    public PatriciaTrie(PatriciaTrie<V> otherTrie) {
        super(otherTrie);
    }

    public static final class PatriciaCodec
    extends AbstractKeyCodec<String>
    implements KeyCodec<String>,
    Serializable {
        private static final long serialVersionUID = -3361216681617901600L;
        protected static final Charset CHARSET = StandardCharsets.UTF_16BE;
        protected static final int CHARSET_BIT_LENGTH = 16;

        @Override
        public final int length(String key) {
            return key.length() * 16;
        }

        @Override
        public final boolean isLeft(String key, int index) {
            byte[] bytes = key.getBytes(CHARSET);
            int bitIndex = index / 8;
            int bitPosition = index % 8 + 1;
            if (bitIndex >= bytes.length) {
                return true;
            }
            return (bytes[bitIndex] >> 8 - bitPosition & 1) == 0;
        }

        @Override
        public final String recreateKey(BitSet bits, int numElements) {
            return new String(PatriciaCodec.toByteArray(bits, numElements), CHARSET);
        }
    }
}

