/*
 * Decompiled with CFR 0.152.
 */
package com.github.veqryn.net;

import com.github.veqryn.net.Cidrs;
import com.github.veqryn.net.Ip4;
import com.github.veqryn.net.Ips;
import java.io.Serializable;
import java.util.regex.Matcher;

public final class Cidr4
implements Comparable<Cidr4>,
Serializable {
    private static final long serialVersionUID = -5580964083176413038L;
    private final int low;
    private final int high;

    public Cidr4(String cidrNotation) {
        Matcher matcher = Cidrs.cidrPattern.matcher(cidrNotation);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Could not parse [" + cidrNotation + "]");
        }
        int address = Ips.toInteger(Ips.matchAddress(matcher), true);
        int netmask = Cidrs.getNetMask(Ips.rangeCheck(Integer.parseInt(matcher.group(5)), 0, 32));
        int network = Cidrs.getLowestBinaryWithNetmask(address, netmask);
        this.low = network ^ Integer.MIN_VALUE;
        this.high = Cidrs.getHighestBinaryWithNetmask(network, netmask) ^ Integer.MIN_VALUE;
    }

    public Cidr4(String cidrNotation, boolean acceptAddressWithoutRange) {
        this(acceptAddressWithoutRange && !cidrNotation.contains("/") ? cidrNotation + "/32" : cidrNotation);
    }

    public Cidr4(String address, String mask) {
        this(Cidrs.toCidrNotation(address, mask));
    }

    public Cidr4(int address, int maskBits) {
        this(address, true, maskBits);
    }

    protected Cidr4(int address, boolean binary, int maskBits) {
        address = binary ? address : address ^ Integer.MIN_VALUE;
        int netmask = Cidrs.getNetMask(Ips.rangeCheck(maskBits, 0, 32));
        int network = Cidrs.getLowestBinaryWithNetmask(address, netmask);
        this.low = network ^ Integer.MIN_VALUE;
        this.high = Cidrs.getHighestBinaryWithNetmask(network, netmask) ^ Integer.MIN_VALUE;
    }

    public Cidr4(Cidr4 cidr) {
        this.low = cidr.low;
        this.high = cidr.high;
    }

    public Cidr4(Ip4 address) {
        this.high = this.low = address.getSortableInteger();
    }

    public Cidr4(Ip4 lowIp, Ip4 highIp) {
        this(lowIp.getSortableInteger(), highIp.getSortableInteger(), false);
    }

    protected Cidr4(int lowIp, int highIp, boolean binary) {
        int network = binary ? lowIp : lowIp ^ Integer.MIN_VALUE;
        int broadcast = binary ? highIp : highIp ^ Integer.MIN_VALUE;
        int netmask = Cidrs.getDifferenceNetmask(network, broadcast);
        network = Cidrs.getLowestBinaryWithNetmask(network, netmask);
        this.low = network ^ Integer.MIN_VALUE;
        this.high = Cidrs.getHighestBinaryWithNetmask(network, netmask) ^ Integer.MIN_VALUE;
        if (this.low > this.high) {
            throw new IllegalArgumentException("Low IP value must be <= High IP value");
        }
    }

    public Cidr4(int octet1, int octet2, int octet3, int octet4, int maskBits) {
        int address = Ips.toInteger(new int[]{octet1, octet2, octet3, octet4}, true);
        int netmask = Cidrs.getNetMask(Ips.rangeCheck(maskBits, 0, 32));
        int network = Cidrs.getLowestBinaryWithNetmask(address, netmask);
        this.low = network ^ Integer.MIN_VALUE;
        this.high = Cidrs.getHighestBinaryWithNetmask(network, netmask) ^ Integer.MIN_VALUE;
    }

    public final String getAddressRange() {
        StringBuilder buf = new StringBuilder();
        buf.append('[').append(this.getLowAddress(true)).append("--").append(this.getHighAddress(true)).append(']');
        return buf.toString();
    }

    public final String getLowAddress(boolean hostCountInclusive) {
        return Ips.format(Ips.toArray(this.getLowSortableInteger(hostCountInclusive), false));
    }

    protected final int getLowSortableInteger(boolean hostCountInclusive) {
        if (hostCountInclusive) {
            return this.low;
        }
        if (this.high > this.low + 1) {
            return this.low + 1;
        }
        return Integer.MIN_VALUE;
    }

    public final int getLowBinaryInteger(boolean hostCountInclusive) {
        if (hostCountInclusive) {
            return this.low ^ Integer.MIN_VALUE;
        }
        if (this.high > this.low + 1) {
            return this.low + 1 ^ Integer.MIN_VALUE;
        }
        return 0;
    }

    public final Ip4 getLowIp(boolean hostCountInclusive) {
        return new Ip4(this.getLowSortableInteger(hostCountInclusive), false);
    }

    public final Cidr4 getLowCidr(boolean hostCountInclusive) {
        int lowest = this.getLowSortableInteger(hostCountInclusive);
        return new Cidr4(lowest, lowest, false);
    }

    public final Cidr4 getLowestContainingCidr(int maskBits) {
        return Cidrs.getLowestContainingCidrForRange(this.low, this.high, maskBits, false);
    }

    public final String getHighAddress(boolean hostCountInclusive) {
        return Ips.format(Ips.toArray(this.getHighSortableInteger(hostCountInclusive), false));
    }

    protected final int getHighSortableInteger(boolean hostCountInclusive) {
        if (hostCountInclusive) {
            return this.high;
        }
        if (this.high > this.low + 1) {
            return this.high - 1;
        }
        return Integer.MIN_VALUE;
    }

    public final int getHighBinaryInteger(boolean hostCountInclusive) {
        if (hostCountInclusive) {
            return this.high ^ Integer.MIN_VALUE;
        }
        if (this.high > this.low + 1) {
            return this.high - 1 ^ Integer.MIN_VALUE;
        }
        return 0;
    }

    public final Ip4 getHighIp(boolean hostCountInclusive) {
        return new Ip4(this.getHighSortableInteger(hostCountInclusive), false);
    }

    public final Cidr4 getHighCidr(boolean hostCountInclusive) {
        int highest = this.getHighSortableInteger(hostCountInclusive);
        return new Cidr4(highest, highest, false);
    }

    public final int getBinaryNetmask() {
        return ~(this.low ^ this.high);
    }

    public final String getNetmask() {
        return Ips.format(Ips.toArray(this.getBinaryNetmask(), true));
    }

    public final int getMaskBits() {
        return Cidrs.getMaskBitCount(this.getBinaryNetmask());
    }

    public final String getCidrSignature() {
        return this.getLowAddress(true) + '/' + this.getMaskBits();
    }

    public final long getAddressCount(boolean hostCountInclusive) {
        return Math.max(0L, Ips.integerToUnsignedLong(this.high, false) - Ips.integerToUnsignedLong(this.low, false) + (long)(hostCountInclusive ? 1 : -1));
    }

    public final String[] getAllAddresses(boolean hostCountInclusive) {
        int count = Math.max(0, (int)this.getAddressCount(hostCountInclusive));
        String[] addresses = new String[count];
        if (count == 0) {
            return addresses;
        }
        int max = this.getHighSortableInteger(hostCountInclusive);
        int j = 0;
        for (int add = this.getLowSortableInteger(hostCountInclusive); add <= max; ++add) {
            addresses[j] = Ips.format(Ips.toArray(add, false));
            ++j;
        }
        return addresses;
    }

    public final Ip4[] getAllIps(boolean hostCountInclusive) {
        int count = Math.max(0, (int)this.getAddressCount(hostCountInclusive));
        Ip4[] addresses = new Ip4[count];
        if (count == 0) {
            return addresses;
        }
        int max = this.getHighSortableInteger(hostCountInclusive);
        int j = 0;
        for (int add = this.getLowSortableInteger(hostCountInclusive); add <= max; ++add) {
            addresses[j] = new Ip4(add, false);
            ++j;
        }
        return addresses;
    }

    public final boolean isInRange(String address, boolean hostCountInclusive) {
        return this.isInRange(Ips.toInteger(address, false), hostCountInclusive);
    }

    public final boolean isInRange(Ip4 address, boolean hostCountInclusive) {
        return this.isInRange(address.getSortableInteger(), hostCountInclusive);
    }

    protected final boolean isInRange(int address, boolean hostCountInclusive) {
        if (hostCountInclusive) {
            return address >= this.low && address <= this.high;
        }
        return address >= this.low + 1 && address <= this.high - 1;
    }

    public final boolean isInRange(Cidr4 cidr, boolean hostCountInclusive) {
        if (hostCountInclusive) {
            return cidr.low >= this.low && cidr.high <= this.high;
        }
        return cidr.low >= this.low + 1 && cidr.high <= this.high - 1;
    }

    public final int hashCode() {
        return (31 + this.high) * 31 + this.low;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Cidr4 other = (Cidr4)obj;
        if (this.high != other.high) {
            return false;
        }
        return this.low == other.low;
    }

    @Override
    public final int compareTo(Cidr4 other) {
        int lowDiff = Integer.compare(this.low, other.low);
        if (lowDiff != 0) {
            return lowDiff;
        }
        int highDiff = Integer.compare(this.high, other.high);
        if (highDiff != 0) {
            return -highDiff;
        }
        return 0;
    }

    public final String toString() {
        return this.getCidrSignature();
    }
}

