/*
 * Decompiled with CFR 0.152.
 */
package com.github.veqryn.net;

import com.github.veqryn.net.Cidr4;
import com.github.veqryn.net.Ips;
import java.util.regex.Pattern;

final class Cidrs {
    protected static final String SLASH_FORMAT = "(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})/(\\d{1,3})";
    protected static final Pattern cidrPattern = Pattern.compile("(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})/(\\d{1,3})");
    protected static final int NBITS = 32;

    private Cidrs() {
    }

    protected static final Cidr4 getLowestContainingCidrForRange(int low, int high, int maskBits, boolean binary) {
        int netmask = Cidrs.getNetMask(maskBits);
        int network = binary ? low : low ^ Integer.MIN_VALUE;
        int newLow = Cidrs.getLowestBinaryWithNetmask(network, netmask) ^ Integer.MIN_VALUE;
        int newHigh = Math.max(binary ? high ^ Integer.MIN_VALUE : high, Cidrs.getHighestBinaryWithNetmask(network, netmask) ^ Integer.MIN_VALUE);
        return new Cidr4(newLow, newHigh, false);
    }

    protected static final int getDifferenceNetmask(int low, int high) {
        int diff = low ^ high;
        diff |= diff >> 1;
        diff |= diff >> 2;
        diff |= diff >> 4;
        diff |= diff >> 8;
        diff |= diff >> 16;
        return ~diff;
    }

    protected static final int getLowestBinaryWithNetmask(int binaryIntegerAddress, int netmask) {
        return binaryIntegerAddress & netmask;
    }

    protected static final int getHighestBinaryWithNetmask(int binaryIntegerAddress, int netmask) {
        return binaryIntegerAddress | ~netmask;
    }

    protected static final int getNetMask(int cidrRangePart) {
        int netmask = 0;
        for (int j = 0; j < cidrRangePart; ++j) {
            netmask |= 1 << 31 - j;
        }
        return netmask;
    }

    protected static final int getMaskBitCount(int netmask) {
        return 32 - Integer.bitCount(~netmask);
    }

    protected static final String toCidrNotation(String address, String mask) {
        return address + "/" + Integer.bitCount(Ips.toInteger(mask, true));
    }
}

