/*
 * Decompiled with CFR 0.152.
 */
package com.github.veqryn.net;

import com.github.veqryn.net.Cidr4;
import com.github.veqryn.net.Cidrs;
import com.github.veqryn.net.Ips;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;

public final class Ip4
implements Comparable<Ip4>,
Serializable {
    private static final long serialVersionUID = 1929530070657767617L;
    private final int address;

    public Ip4(String ipAddress) {
        this.address = Ips.toInteger(ipAddress, false);
    }

    public Ip4(Ip4 ip) {
        this.address = ip.address;
    }

    public Ip4(int octet1, int octet2, int octet3, int octet4) {
        this.address = Ips.toInteger(new int[]{octet1, octet2, octet3, octet4}, false);
    }

    public Ip4(int ipIntegerValue) {
        this(ipIntegerValue, true);
    }

    protected Ip4(int ipIntegerValue, boolean binary) {
        this.address = binary ? ipIntegerValue ^ Integer.MIN_VALUE : ipIntegerValue;
    }

    protected final int getSortableInteger() {
        return this.address;
    }

    public final int getBinaryInteger() {
        return this.address ^ Integer.MIN_VALUE;
    }

    public final String getAddress() {
        return Ips.format(Ips.toArray(this.address, false));
    }

    public final Cidr4 getCidr() {
        return new Cidr4(this);
    }

    public final Cidr4 getLowestContainingCidr(int maskBits) {
        return Cidrs.getLowestContainingCidrForRange(this.address, this.address, maskBits, false);
    }

    public final InetAddress getInetAddress() throws UnknownHostException {
        int[] ints = Ips.toArray(this.address, false);
        return InetAddress.getByAddress(new byte[]{(byte)ints[0], (byte)ints[1], (byte)ints[2], (byte)ints[3]});
    }

    public final int hashCode() {
        return this.address;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.address == ((Ip4)obj).address;
    }

    @Override
    public final int compareTo(Ip4 other) {
        return Integer.compare(this.address, other.address);
    }

    public final String toString() {
        return this.getAddress();
    }
}

