/*
 * Decompiled with CFR 0.152.
 */
package com.github.veqryn.net;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class Ips {
    protected static final String IP_ADDRESS = "(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})";
    protected static final Pattern addressPattern = Pattern.compile("(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})");

    private Ips() {
    }

    protected static final int toInteger(String address, boolean binary) {
        Matcher matcher = addressPattern.matcher(address);
        if (matcher.matches()) {
            return Ips.toInteger(Ips.matchAddress(matcher), binary);
        }
        throw new IllegalArgumentException("Could not parse [" + address + "]");
    }

    protected static final int toInteger(int[] ipValues, boolean binary) {
        int address = 0;
        for (int i = 0; i <= 3; ++i) {
            int n = Ips.rangeCheck(ipValues[i], -1, 255);
            address |= (n & 0xFF) << 8 * (3 - i);
        }
        if (!binary) {
            address ^= Integer.MIN_VALUE;
        }
        return address;
    }

    protected static final int[] matchAddress(Matcher matcher) {
        return new int[]{Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2)), Integer.parseInt(matcher.group(3)), Integer.parseInt(matcher.group(4))};
    }

    protected static final int rangeCheck(int value, int begin, int end) {
        if (value > begin && value <= end) {
            return value;
        }
        throw new IllegalArgumentException("Value [" + value + "] not in range (" + begin + "," + end + "]");
    }

    protected static final byte getBinaryOctet1(int address, boolean binary) {
        return (byte)((binary ? address : address ^ Integer.MIN_VALUE) >>> 24 & 0xFF);
    }

    protected static final byte getBinaryOctet2(int address) {
        return (byte)(address >>> 16 & 0xFF);
    }

    protected static final byte getBinaryOctet3(int address) {
        return (byte)(address >>> 8 & 0xFF);
    }

    protected static final byte getBinaryOctet4(int address) {
        return (byte)(address & 0xFF);
    }

    protected static final int[] toArray(int address, boolean binary) {
        int[] ipValues = new int[4];
        for (int j = 3; j >= 0; --j) {
            int n = j;
            ipValues[n] = ipValues[n] | (j != 0 || binary ? address : address ^ Integer.MIN_VALUE) >>> 8 * (3 - j) & 0xFF;
        }
        return ipValues;
    }

    protected static final byte[] getBits(long binary, int start, int end) {
        if (start < 0 || start > 64 || end < 0 || end > 64 || start > end) {
            throw new IllegalArgumentException("Illegal position arguments: start: " + start + ", end: " + end);
        }
        int min = 64 - end;
        byte[] bits = new byte[end - start];
        int j = 0;
        for (int i = 63 - start; i >= min; --i) {
            bits[j] = (byte)(binary >> i & 1L);
            ++j;
        }
        return bits;
    }

    protected static final byte[] getBits(int binary, int start, int end) {
        if (start < 0 || start > 32 || end < 0 || end > 32 || start > end) {
            throw new IllegalArgumentException("Illegal position arguments: start: " + start + ", end: " + end);
        }
        int min = 32 - end;
        byte[] bits = new byte[end - start];
        int j = 0;
        for (int i = 31 - start; i >= min; --i) {
            bits[j] = (byte)(binary >> i & 1);
            ++j;
        }
        return bits;
    }

    protected static final byte[] getBits(short binary, int start, int end) {
        if (start < 0 || start > 16 || end < 0 || end > 16 || start > end) {
            throw new IllegalArgumentException("Illegal position arguments: start: " + start + ", end: " + end);
        }
        int min = 16 - end;
        byte[] bits = new byte[end - start];
        int j = 0;
        for (int i = 15 - start; i >= min; --i) {
            bits[j] = (byte)(binary >> i & 1);
            ++j;
        }
        return bits;
    }

    protected static final byte[] getBits(byte binary, int start, int end) {
        if (start < 0 || start > 8 || end < 0 || end > 8 || start > end) {
            throw new IllegalArgumentException("Illegal position arguments: start: " + start + ", end: " + end);
        }
        int min = 8 - end;
        byte[] bits = new byte[end - start];
        int j = 0;
        for (int i = 7 - start; i >= min; --i) {
            bits[j] = (byte)(binary >> i & 1);
            ++j;
        }
        return bits;
    }

    protected static final String format(int[] octets) {
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < octets.length; ++i) {
            str.append(octets[i]);
            if (i == octets.length - 1) continue;
            str.append(".");
        }
        return str.toString();
    }

    protected static final long integerToUnsignedLong(int address, boolean binary) {
        if (binary) {
            return address < 0 ? 0xFFFFFFFF00000000L ^ (long)address : (long)address;
        }
        return address < 0 ? Integer.MIN_VALUE ^ (long)address : 0x80000000L ^ (long)address;
    }

    protected static final int unsignedLongToInteger(long longAddress, boolean binary) {
        return binary ? (int)longAddress : Integer.MIN_VALUE ^ (int)longAddress;
    }
}

