/*
 * Decompiled with CFR 0.152.
 */
package com.github.veqryn.util;

public class BitSetUtil {
    private BitSetUtil() {
    }

    public static long[] shiftLeft(long[] words, int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Number to shift left must be >= 0: " + n);
        }
        if (n == 0) {
            return words;
        }
        int needed = n / 64;
        int carryArray = 0;
        int carry = 64 - (n %= 64);
        if (words[words.length - 1] >>> carry > 0L) {
            ++carryArray;
        }
        if (needed > 0 || carryArray > 0) {
            long[] tmp = new long[words.length + needed + carryArray];
            System.arraycopy(words, 0, tmp, needed, words.length);
            words = tmp;
        }
        for (int i = words.length - 1; i > 0; --i) {
            int n2 = i;
            words[n2] = words[n2] << n;
            int n3 = i;
            words[n3] = words[n3] | words[i - 1] >>> carry;
        }
        words[0] = words[0] << n;
        return words;
    }

    public static long[] shiftRight(long[] words, int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Number to shift right must be >= 0: " + n);
        }
        if (n == 0) {
            return words;
        }
        int removed = n / 64;
        int carryArray = 0;
        if (words[words.length - 1] >>> (n %= 64) == 0L) {
            ++carryArray;
        }
        int carry = 64 - n;
        for (int i = 0; i < words.length - 1; ++i) {
            int n2 = i;
            words[n2] = words[n2] >>> n;
            int n3 = i;
            words[n3] = words[n3] | words[i + 1] << carry;
        }
        int n4 = words.length - 1;
        words[n4] = words[n4] >>> n;
        if (removed > 0 || carryArray > 0) {
            int newSize = words.length - removed - carryArray;
            long[] tmp = new long[Math.max(1, newSize)];
            if (newSize <= 0) {
                tmp[0] = 0L;
                return tmp;
            }
            System.arraycopy(words, removed, tmp, 0, tmp.length);
            return tmp;
        }
        return words;
    }
}

