/*
 * Decompiled with CFR 0.152.
 */
package com.github.vertical_blank.sqlformatter.core;

import com.github.vertical_blank.sqlformatter.core.Token;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Queue;

public class Params {
    private Holder params;

    public Params(Map<String, ?> params) {
        this.params = new NamedParamHolder(params);
    }

    public Params(List<?> params) {
        this.params = new IndexedParamHolder(params);
    }

    public Params(Holder holder) {
        this.params = holder;
    }

    Object get(Token token) {
        if (this.params == null || this.params.isEmpty()) {
            return token.value;
        }
        if (token.key != null && !token.key.isEmpty()) {
            return this.params.getByName(token.key);
        }
        return this.params.get();
    }

    public static class IndexedParamHolder
    implements Holder {
        private Queue<?> params;

        IndexedParamHolder(List<?> params) {
            this.params = new PriorityQueue(params);
        }

        @Override
        public boolean isEmpty() {
            return this.params.isEmpty();
        }

        @Override
        public Object get() {
            return this.params.poll();
        }

        @Override
        public Object getByName(String key) {
            return null;
        }
    }

    public static class NamedParamHolder
    implements Holder {
        private Map<String, ?> params;

        NamedParamHolder(Map<String, ?> params) {
            this.params = params;
        }

        @Override
        public boolean isEmpty() {
            return this.params.isEmpty();
        }

        @Override
        public Object get() {
            return null;
        }

        @Override
        public Object getByName(String key) {
            return this.params.get(key);
        }
    }

    public static interface Holder {
        public boolean isEmpty();

        public Object get();

        public Object getByName(String var1);

        public static Holder of(Map<String, ?> params) {
            return new NamedParamHolder(params);
        }

        public static Holder of(List<?> params) {
            return new IndexedParamHolder(params);
        }
    }
}

