/*
 * Decompiled with CFR 0.152.
 */
package com.github.viclovsky.swagger.coverage;

import com.github.viclovsky.swagger.coverage.CoverageOutputReader;
import com.github.viclovsky.swagger.coverage.SwaggerCoverageReadException;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Stream;

public class FileSystemOutputReader
implements CoverageOutputReader {
    private final Path outputDirectory;

    public FileSystemOutputReader(Path outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    @Override
    public Set<Path> getOutputs() {
        HashSet<Path> outputs = new HashSet<Path>();
        try (Stream<Path> paths = Files.walk(this.outputDirectory, new FileVisitOption[0]);){
            paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(outputs::add);
        }
        catch (IOException e) {
            throw new SwaggerCoverageReadException("can't read coverage file's", e);
        }
        return outputs;
    }
}

