/*
 * Decompiled with CFR 0.152.
 */
package com.github.viclovsky.swagger.coverage;

import com.github.viclovsky.swagger.coverage.CoverageOutputWriter;
import com.github.viclovsky.swagger.coverage.FileSystemOutputWriter;
import io.restassured.filter.FilterContext;
import io.restassured.filter.OrderedFilter;
import io.restassured.specification.FilterableRequestSpecification;
import io.restassured.specification.FilterableResponseSpecification;
import io.swagger.models.Operation;
import io.swagger.models.Path;
import io.swagger.models.Response;
import io.swagger.models.Scheme;
import io.swagger.models.Swagger;
import io.swagger.models.parameters.BodyParameter;
import io.swagger.models.parameters.FormParameter;
import io.swagger.models.parameters.HeaderParameter;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.parameters.PathParameter;
import io.swagger.models.parameters.QueryParameter;
import java.net.URI;
import java.nio.file.Paths;
import java.util.Objects;

public class SwaggerCoverageRestAssured
implements OrderedFilter {
    private CoverageOutputWriter writer;

    public SwaggerCoverageRestAssured(CoverageOutputWriter writer) {
        this.writer = writer;
    }

    public SwaggerCoverageRestAssured() {
        this.writer = new FileSystemOutputWriter(Paths.get("swagger-coverage-output", new String[0]));
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    public io.restassured.response.Response filter(FilterableRequestSpecification requestSpec, FilterableResponseSpecification responseSpec, FilterContext ctx) {
        Operation operation = new Operation();
        requestSpec.getPathParams().forEach((n, v) -> operation.addParameter((Parameter)((PathParameter)new PathParameter().name(n)).example(v)));
        try {
            requestSpec.getQueryParams().forEach((n, v) -> operation.addParameter((Parameter)((QueryParameter)new QueryParameter().name(n)).example(v)));
        }
        catch (ClassCastException ex) {
            requestSpec.getQueryParams().keySet().forEach(n -> operation.addParameter((Parameter)new QueryParameter().name(n)));
        }
        try {
            requestSpec.getFormParams().forEach((n, v) -> operation.addParameter((Parameter)((FormParameter)new FormParameter().name(n)).example(v)));
        }
        catch (ClassCastException ex) {
            requestSpec.getFormParams().keySet().forEach(n -> operation.addParameter((Parameter)new FormParameter().name(n)));
        }
        requestSpec.getHeaders().forEach(header -> operation.addParameter((Parameter)((HeaderParameter)new HeaderParameter().name(header.getName())).example(header.getValue())));
        requestSpec.getMultiPartParams().forEach(multiPartSpecification -> operation.addParameter((Parameter)new FormParameter().name(multiPartSpecification.getControlName())));
        if (Objects.nonNull(requestSpec.getBody())) {
            operation.addParameter((Parameter)new BodyParameter().name("body"));
        }
        io.restassured.response.Response response = ctx.next(requestSpec, responseSpec);
        operation.addResponse(String.valueOf(response.statusCode()), new Response());
        Swagger swagger = new Swagger().scheme(Scheme.forValue((String)URI.create(requestSpec.getURI()).getScheme())).host(URI.create(requestSpec.getURI()).getHost()).consumes(requestSpec.getContentType()).produces(response.getContentType()).path(requestSpec.getUserDefinedPath(), new Path().set(requestSpec.getMethod().toLowerCase(), operation));
        this.writer.write(swagger);
        return response;
    }
}

