/*
 * Decompiled with CFR 0.152.
 */
package com.github.victools.jsonschema.generator.impl.module;

import com.github.victools.jsonschema.generator.FieldScope;
import com.github.victools.jsonschema.generator.Module;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfigBuilder;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfigPart;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.List;

public class ConstantValueModule
implements Module {
    private static List<?> extractConstantFieldValue(FieldScope field) {
        if (field.isStatic() && field.isFinal() && !((Field)field.getRawMember()).isEnumConstant()) {
            Field rawField = (Field)field.getRawMember();
            if (!rawField.canAccess(null)) {
                try {
                    rawField.setAccessible(true);
                }
                catch (Exception ex) {
                    return null;
                }
            }
            try {
                return Collections.singletonList(((Field)field.getRawMember()).get(null));
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException(ex);
            }
        }
        return null;
    }

    private static Boolean isNullableConstantField(FieldScope field) {
        List<?> constantValues = ConstantValueModule.extractConstantFieldValue(field);
        if (constantValues == null) {
            return null;
        }
        return constantValues.get(0) == null;
    }

    @Override
    public void applyToConfigBuilder(SchemaGeneratorConfigBuilder builder) {
        ((SchemaGeneratorConfigPart)builder.forFields().withEnumResolver(ConstantValueModule::extractConstantFieldValue)).withNullableCheck(ConstantValueModule::isNullableConstantField);
    }
}

