/*
 * Decompiled with CFR 0.152.
 */
package com.github.victools.jsonschema.generator;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.victools.jsonschema.generator.SchemaBuilder;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfig;
import com.github.victools.jsonschema.generator.TypeContext;
import com.github.victools.jsonschema.generator.impl.TypeContextFactory;
import java.lang.reflect.Type;

public class SchemaGenerator {
    private final SchemaGeneratorConfig config;
    private final TypeContext typeContext;

    public SchemaGenerator(SchemaGeneratorConfig config) {
        this(config, TypeContextFactory.createDefaultTypeContext(config));
    }

    public SchemaGenerator(SchemaGeneratorConfig config, TypeContext context) {
        this.config = config;
        this.typeContext = context;
    }

    public ObjectNode generateSchema(Type mainTargetType, Type ... typeParameters) {
        return SchemaBuilder.createSingleTypeSchema(this.config, this.typeContext, mainTargetType, typeParameters);
    }

    public SchemaBuilder buildMultipleSchemaDefinitions() {
        return SchemaBuilder.forMultipleTypes(this.config, this.typeContext);
    }
}

