/*
 * Decompiled with CFR 0.152.
 */
package com.github.victools.jsonschema.generator;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.ResolvedTypeWithMembers;
import com.fasterxml.classmate.members.ResolvedMember;
import com.github.victools.jsonschema.generator.TypeContext;
import com.github.victools.jsonschema.generator.TypeScope;
import com.github.victools.jsonschema.generator.impl.LazyValue;
import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;

public abstract class MemberScope<M extends ResolvedMember<T>, T extends Member>
extends TypeScope {
    private final M member;
    private final ResolvedType overriddenType;
    private final String overriddenName;
    private final ResolvedTypeWithMembers declaringTypeMembers;
    private Integer fakeContainerItemIndex;
    private final LazyValue<String> schemaPropertyName = new LazyValue<String>(this::doGetSchemaPropertyName);

    protected MemberScope(M member, ResolvedType overriddenType, String overriddenName, ResolvedTypeWithMembers declaringTypeMembers, Integer fakeContainerItemIndex, TypeContext context) {
        super(Optional.ofNullable(overriddenType).orElseGet(() -> member.getType()), context);
        this.member = member;
        this.overriddenType = overriddenType;
        this.overriddenName = overriddenName;
        this.declaringTypeMembers = declaringTypeMembers;
        this.fakeContainerItemIndex = fakeContainerItemIndex;
    }

    protected Integer getFakeContainerItemIndex() {
        return this.fakeContainerItemIndex;
    }

    public abstract MemberScope<M, T> withOverriddenType(ResolvedType var1);

    public MemberScope<M, T> asFakeContainerItemScope() {
        if (!this.isContainerType()) {
            return this.withOverriddenType(this.getOverriddenType());
        }
        MemberScope<M, T> result = this.withOverriddenType(this.getContainerItemType());
        result.fakeContainerItemIndex = 0;
        return result;
    }

    public MemberScope<M, T> asFakeContainerItemScope(Class<?> referenceType, int containerItemIndex) {
        MemberScope<M, T> result = this.withOverriddenType(this.getTypeParameterFor(referenceType, containerItemIndex));
        result.fakeContainerItemIndex = containerItemIndex;
        return result;
    }

    public abstract MemberScope<M, T> withOverriddenName(String var1);

    public M getMember() {
        return this.member;
    }

    public ResolvedTypeWithMembers getDeclaringTypeMembers() {
        return this.declaringTypeMembers;
    }

    public ResolvedType getDeclaredType() {
        return this.member.getType();
    }

    public ResolvedType getOverriddenType() {
        return this.overriddenType;
    }

    public boolean isFakeContainerItemScope() {
        return this.fakeContainerItemIndex != null;
    }

    public String getDeclaredName() {
        return this.member.getName();
    }

    public String getOverriddenName() {
        return this.overriddenName;
    }

    public String getName() {
        return Optional.ofNullable(this.getOverriddenName()).orElseGet(this::getDeclaredName);
    }

    public final ResolvedType getDeclaringType() {
        return this.member.getDeclaringType();
    }

    public T getRawMember() {
        return (T)this.member.getRawMember();
    }

    public boolean isStatic() {
        return this.member.isStatic();
    }

    public boolean isFinal() {
        return this.member.isFinal();
    }

    public boolean isPrivate() {
        return this.member.isPrivate();
    }

    public boolean isProtected() {
        return this.member.isProtected();
    }

    public boolean isPublic() {
        return this.member.isPublic();
    }

    public <A extends Annotation> A getAnnotation(Class<A> annotationClass) {
        return this.getAnnotation(annotationClass, TypeContext.IGNORE_ANNOTATIONS_ON_ANNOTATIONS);
    }

    public <A extends Annotation> A getAnnotation(Class<A> annotationClass, Predicate<Annotation> considerOtherAnnotation) {
        List annotationList = this.member.getAnnotations().asList();
        return this.getContext().getAnnotationFromList(annotationClass, annotationList, considerOtherAnnotation);
    }

    public <A extends Annotation> A getContainerItemAnnotation(Class<A> annotationClass) {
        return this.getContainerItemAnnotation(annotationClass, TypeContext.IGNORE_ANNOTATIONS_ON_ANNOTATIONS);
    }

    public abstract <A extends Annotation> A getContainerItemAnnotation(Class<A> var1, Predicate<Annotation> var2);

    public <A extends Annotation> A getAnnotationConsideringFieldAndGetter(Class<A> annotationClass) {
        return this.getAnnotationConsideringFieldAndGetter(annotationClass, TypeContext.IGNORE_ANNOTATIONS_ON_ANNOTATIONS);
    }

    public abstract <A extends Annotation> A getAnnotationConsideringFieldAndGetter(Class<A> var1, Predicate<Annotation> var2);

    public <A extends Annotation> A getAnnotationConsideringFieldAndGetterIfSupported(Class<A> annotationClass) {
        return this.getAnnotationConsideringFieldAndGetterIfSupported(annotationClass, TypeContext.IGNORE_ANNOTATIONS_ON_ANNOTATIONS);
    }

    public <A extends Annotation> A getAnnotationConsideringFieldAndGetterIfSupported(Class<A> annotationClass, Predicate<Annotation> considerOtherAnnotation) {
        if (this.isFakeContainerItemScope()) {
            return null;
        }
        return this.getAnnotationConsideringFieldAndGetter(annotationClass, considerOtherAnnotation);
    }

    public <A extends Annotation> A getContainerItemAnnotationConsideringFieldAndGetter(Class<A> annotationClass) {
        return this.getContainerItemAnnotationConsideringFieldAndGetter(annotationClass, TypeContext.IGNORE_ANNOTATIONS_ON_ANNOTATIONS);
    }

    public abstract <A extends Annotation> A getContainerItemAnnotationConsideringFieldAndGetter(Class<A> var1, Predicate<Annotation> var2);

    public <A extends Annotation> A getContainerItemAnnotationConsideringFieldAndGetterIfSupported(Class<A> annotationClass) {
        return this.getContainerItemAnnotationConsideringFieldAndGetterIfSupported(annotationClass, TypeContext.IGNORE_ANNOTATIONS_ON_ANNOTATIONS);
    }

    public <A extends Annotation> A getContainerItemAnnotationConsideringFieldAndGetterIfSupported(Class<A> annotationClass, Predicate<Annotation> considerOtherAnnotation) {
        if (this.isFakeContainerItemScope()) {
            return this.getContainerItemAnnotationConsideringFieldAndGetter(annotationClass, considerOtherAnnotation);
        }
        if (this.getOverriddenType() != null && this.getDeclaredType().getErasedType() == Optional.class && this.getOverriddenType().getErasedType() == ((ResolvedType)this.getDeclaredType().getTypeParameters().get(0)).getErasedType()) {
            return this.getContainerItemAnnotationConsideringFieldAndGetter(annotationClass, considerOtherAnnotation);
        }
        return null;
    }

    public String getSchemaPropertyName() {
        return this.schemaPropertyName.get();
    }

    protected abstract String doGetSchemaPropertyName();

    @Override
    public String toString() {
        return this.getSimpleTypeDescription() + " " + this.getSchemaPropertyName();
    }
}

